#include "mainwindow.h"
#ifdef WIN32
#include "include/resource.h"
#else
#include "resource.h"
#endif
#ifdef WIN32
#include <qwindowsstyle.h>
#include <qmotifstyle.h>
#include <qmotifplusstyle.h>
#include <qcdestyle.h>
#include <qplatinumstyle.h>
#include <qsgistyle.h>
#else
#include <qstylefactory.h>
#include <qsettings.h>
#endif
#include <qmenubar.h>

void MainWindow::slot_windows()
{
	option.style = 0;
	menuBar()->setItemChecked(ID_DEFAULT_STYLE, FALSE);
	menuBar()->setItemChecked(ID_CDE,FALSE);
	menuBar()->setItemChecked(ID_MOTIF,FALSE);
	menuBar()->setItemChecked(ID_MOTIF_PLUS,FALSE);
	menuBar()->setItemChecked(ID_PLATINUM,FALSE);	
	menuBar()->setItemChecked(ID_SGI,FALSE);	
//	menuBar()->setItemChecked(ID_JFC, FALSE);	
//	menuBar()->setItemChecked(ID_NEXTSTEP, FALSE);	
	menuBar()->setItemChecked(ID_WINDOWS,TRUE);

#ifdef WIN32	
	qApp->setStyle(new QWindowsStyle());
#else
	qApp->setStyle(QStyleFactory::create("windows"));
#endif
}

void MainWindow::slot_cde()
{
	option.style = 1;
	menuBar()->setItemChecked(ID_DEFAULT_STYLE, FALSE);
	menuBar()->setItemChecked(ID_MOTIF,FALSE);
	menuBar()->setItemChecked(ID_MOTIF_PLUS,FALSE);
	menuBar()->setItemChecked(ID_WINDOWS,FALSE);
	menuBar()->setItemChecked(ID_PLATINUM,FALSE);	
	menuBar()->setItemChecked(ID_SGI,FALSE);	
	//menuBar()->setItemChecked(ID_JFC, FALSE);	
	//menuBar()->setItemChecked(ID_NEXTSTEP, FALSE);	
	menuBar()->setItemChecked(ID_CDE,TRUE);
	
#ifdef WIN32	
	qApp->setStyle(new QCDEStyle());
#else
	qApp->setStyle(QStyleFactory::create("cde"));
#endif
}

void MainWindow::slot_motif()
{
	option.style = 2;
	menuBar()->setItemChecked(ID_DEFAULT_STYLE, FALSE);
	menuBar()->setItemChecked(ID_CDE,FALSE);
	menuBar()->setItemChecked(ID_MOTIF_PLUS,FALSE);
	menuBar()->setItemChecked(ID_WINDOWS,FALSE);
	menuBar()->setItemChecked(ID_PLATINUM,FALSE);	
	menuBar()->setItemChecked(ID_SGI,FALSE);	
	//menuBar()->setItemChecked(ID_JFC, FALSE);	
	//menuBar()->setItemChecked(ID_NEXTSTEP, FALSE);	
	menuBar()->setItemChecked(ID_MOTIF,TRUE);

#ifdef WIN32	
	qApp->setStyle(new QMotifStyle());
#else
	qApp->setStyle(QStyleFactory::create("motif"));
#endif
}

void MainWindow::slot_motif_plus()
{
	option.style = 3;
	menuBar()->setItemChecked(ID_DEFAULT_STYLE, FALSE);
	menuBar()->setItemChecked(ID_CDE,FALSE);
	menuBar()->setItemChecked(ID_MOTIF,FALSE);
	menuBar()->setItemChecked(ID_WINDOWS,FALSE);
	menuBar()->setItemChecked(ID_PLATINUM,FALSE);	
	menuBar()->setItemChecked(ID_SGI,FALSE);	
	//menuBar()->setItemChecked(ID_JFC, FALSE);	
	//menuBar()->setItemChecked(ID_NEXTSTEP, FALSE);	
	menuBar()->setItemChecked(ID_MOTIF_PLUS,TRUE);

#ifdef WIN32	
	qApp->setStyle(new QMotifPlusStyle());
#else
	qApp->setStyle(QStyleFactory::create("motifplus"));
#endif
}

void MainWindow::slot_platinum()
{
	option.style = 4;
	menuBar()->setItemChecked(ID_DEFAULT_STYLE, FALSE);
	menuBar()->setItemChecked(ID_CDE,FALSE);
	menuBar()->setItemChecked(ID_MOTIF,FALSE);
	menuBar()->setItemChecked(ID_MOTIF_PLUS,FALSE);
	menuBar()->setItemChecked(ID_WINDOWS,FALSE);
	menuBar()->setItemChecked(ID_SGI,FALSE);	
	//menuBar()->setItemChecked(ID_JFC, FALSE);	
	//menuBar()->setItemChecked(ID_NEXTSTEP, FALSE);	
	menuBar()->setItemChecked(ID_PLATINUM,TRUE);	

#ifdef WIN32	
	qApp->setStyle(new QPlatinumStyle());
#else
	qApp->setStyle(QStyleFactory::create("platinum"));
#endif
}

void MainWindow::slot_sgi()
{
	option.style = 5;
	menuBar()->setItemChecked(ID_DEFAULT_STYLE, FALSE);
	menuBar()->setItemChecked(ID_CDE,FALSE);
	menuBar()->setItemChecked(ID_MOTIF,FALSE);
	menuBar()->setItemChecked(ID_MOTIF_PLUS,FALSE);
	menuBar()->setItemChecked(ID_WINDOWS,FALSE);
	menuBar()->setItemChecked(ID_PLATINUM,FALSE);	
	//menuBar()->setItemChecked(ID_JFC, FALSE);	
	//menuBar()->setItemChecked(ID_NEXTSTEP, FALSE);	
	menuBar()->setItemChecked(ID_SGI, TRUE);	

#ifdef WIN32	
	qApp->setStyle(new QSGIStyle());
#else
	qApp->setStyle(QStyleFactory::create("sgi"));
#endif
}

void MainWindow::slot_jfc()
{
/*
#ifndef WIN32	
	option.style = 6;
	menuBar()->setItemChecked(ID_CDE,FALSE);
	menuBar()->setItemChecked(ID_MOTIF,FALSE);
	menuBar()->setItemChecked(ID_MOTIF_PLUS,FALSE);
	menuBar()->setItemChecked(ID_WINDOWS,FALSE);
	menuBar()->setItemChecked(ID_PLATINUM,FALSE);	
	menuBar()->setItemChecked(ID_SGI, FALSE);	
	menuBar()->setItemChecked(ID_NEXTSTEP, FALSE);	
	menuBar()->setItemChecked(ID_JFC, TRUE);	

	qApp->setStyle(new JFCStyle());
#endif	
*/
}

void MainWindow::slot_nextstep()
{
/*
	option.style = 7;
	menuBar()->setItemChecked(ID_CDE,FALSE);
	menuBar()->setItemChecked(ID_MOTIF,FALSE);
	menuBar()->setItemChecked(ID_MOTIF_PLUS,FALSE);
	menuBar()->setItemChecked(ID_WINDOWS,FALSE);
	menuBar()->setItemChecked(ID_PLATINUM,FALSE);	
	menuBar()->setItemChecked(ID_SGI, FALSE);	
	menuBar()->setItemChecked(ID_JFC, FALSE);	
	menuBar()->setItemChecked(ID_NEXTSTEP, TRUE);	

	qApp->setStyle(new StepStyle());
*/
}

void MainWindow::slot_default_style()
{
	option.style = -1;
	menuBar()->setItemChecked(ID_WINDOWS,FALSE);
	menuBar()->setItemChecked(ID_CDE,FALSE);
	menuBar()->setItemChecked(ID_MOTIF,FALSE);
	menuBar()->setItemChecked(ID_MOTIF_PLUS,FALSE);
	menuBar()->setItemChecked(ID_PLATINUM,FALSE);	
	menuBar()->setItemChecked(ID_SGI,FALSE);	
//	menuBar()->setItemChecked(ID_JFC, FALSE);	
//	menuBar()->setItemChecked(ID_NEXTSTEP, FALSE);	
	menuBar()->setItemChecked(ID_DEFAULT_STYLE, TRUE);

#ifndef WIN32
	// Read the default style from Qt's settings
	QSettings settings;
	qApp->setStyle(settings.readEntry("/qt/style"));
#else
	qApp->setStyle(new QWindowsStyle());
#endif
}
