#include "copy.h"
#include "mainwindow.h"
#include "include/sql.h"

#include <qmessagebox.h>

void 
Copy::slot_close()
{
	parentWidget()->close();
}

void 
Copy::slot_fire()
{
	if(table2->text().isEmpty())
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Please enter table name."));
		table2->setFocus();
		return;
	}

	if(mode == M_COPY)
	{
		if(database2->currentText() == "mysql")
		{
			QMessageBox::critical(this, tr("MySQL Navigator"), tr("Can't copy table to mysql database."));
			return;
		}

		QString v;

		v += "create table ";
		v += database2->currentText();
		v += ".";
		v += table2->text();
		v += " ";

		v += "select * from ";
		v += database1->currentText();
		v += ".";
		v += table1->currentText();

		/*
		switch(QMessageBox::warning(this, tr("MySQL Navigator"), tr("The following query will copy table. are you sure?") + "\n\n" + v, "&Yes", "&No", "&Edit", 0, 1 ))
		{
				case 1: 
					return;
					break;
				case 2:
					((MainWindow *)qApp->mainWidget())->slot_query2(v, database1->currentText());
					return;
		}
		*/

		if(SQL::sql_query(v.latin1()))
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&((MainWindow *)qApp->mainWidget())->mysql)));
		}
		else
		{
			emit signal_schema();
			QMessageBox::warning(this, tr("MySQL Navigator"), tr("Copy table has been suceeded."));
		}
	}
	else if(mode == M_MOVE)
	{
		if(database1->currentText() == "mysql")
		{
			QMessageBox::critical(this, tr("MySQL Navigator"), tr("Can't move table in mysql database."));
			return;
		}

		if(database2->currentText() == "mysql")
		{
			QMessageBox::critical(this, tr("MySQL Navigator"), tr("Can't move table to mysql database."));
			return;
		}

		QString v;

		v += "alter table ";
		v += database1->currentText();
		v += ".";
		v += table1->currentText();
		v += " ";

		v += "rename to ";
		v += database2->currentText();
		v += ".";
		v += table2->text();

		/*
		switch(QMessageBox::warning(this, tr("MySQL Navigator"), tr("The following query will copy table. are you sure?") + "\n\n" + v, "&Yes", "&No", "&Edit", 0, 1 ))
		{
				case 1: 
					return;
					break;
				case 2:
					((MainWindow *)qApp->mainWidget())->slot_query2(v, database1->currentText());
					return;
		}
		*/

		if(SQL::sql_query(v.latin1()))
		{
			QMessageBox::warning(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(&((MainWindow *)qApp->mainWidget())->mysql)));
		}
		else
		{
			emit signal_schema();
			QMessageBox::warning(this, tr("MySQL Navigator"), tr("Move table has been suceeded."));
		}
	}
}

void
Copy::slot_database1()
{
	QList<QString> value;
	value = ((MainWindow *)qApp->mainWidget())->database->get_value();
	database1->slot_value(value);
	slot_table1(0);
}

void 
Copy::slot_database2()
{
	QList<QString> value;
	value = ((MainWindow *)qApp->mainWidget())->database->get_value();
	database2->slot_value(value);
}

void 
Copy::slot_table1(int)
{
	MYSQL_RES *result;
    MYSQL_ROW row;
	QList<QString> value;

	table1->clear();

	if(mysql_select_db(&((MainWindow *)qApp->mainWidget())->mysql, database1->currentText().latin1()))
		return;

	result = mysql_list_tables(&((MainWindow *)qApp->mainWidget())->mysql, NULL);

	if(result == NULL)
	{
		return;
	}

    while((row = mysql_fetch_row(result)))
    {
		QString *s = new QString;
		*s = row[0];
		value.append(s);
	}

	mysql_free_result(result);

	table1->slot_value(value);
}

void 
Copy::slot_value(const QString &database, const QString &table)
{
	int z;

	for(z = 0; z < this->database1->count(); z++)
	{
		if(this->database1->text(z) == database)
		{
			this->database1->setCurrentItem(z);
			this->database1->data  = database;
			break;
		}
	}

	slot_table1(0);

	for(z = 0; z < this->table1->count(); z++)
	{
		if(this->table1->text(z) == table)
		{
			this->table1->setCurrentItem(z);
			this->table1->data  = table;
			break;
		}
	}
}

void
Copy::slot_clear()
{
	database1->setCurrentItem(0);
	database2->setCurrentItem(0);
	slot_table1(0);
	table2->setText("");
}