// scaledarea.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include <InterViews/canvas.h>
#include <InterViews/painter.h>
#include <InterViews/perspective.h>
#include <InterViews/sensor.h>
#include <InterViews/shape.h>
#include "scale.h"
#include "scaledarea.h"
#include "margin.h"
#include "range.h"

BorderedArea::BorderedArea() {
	Init();
}

BorderedArea::~BorderedArea() {
	Resource::unref(perspective);
	delete myMargin;
}

void
BorderedArea::Init() {
	SetClassName("BorderedArea");
	input = new Sensor(noEvents);
	input->Catch(KeyEvent);
	oldxmax = oldymax = 0;
	perspective = new Perspective;
	myMargin = new Margin;
}

void
BorderedArea::Update() {
	if(IsMapped()) {
		doAdjust();
		Draw();
	}
}

int
BorderedArea::currentHeight() {
	int h = (canvas != nil) ? ymax + 1 : shape->height;
	return h  - myMargin->top - myMargin->bottom;
}
int
BorderedArea::currentWidth() {
	int w = (canvas != nil) ? xmax + 1 : shape->width;
	return w - myMargin->left - myMargin->right;
}

boolean 
BorderedArea::IsMapped() {
	return (canvas != nil && canvas->status() == Canvas::mapped);
}


boolean
BorderedArea::isResized() {
	if(widthChanged() || heightChanged()) {
		return true;
	}
	return false;
}
// ********

ScaledArea::ScaledArea(const Range &vertRange, Scale *vs)
	: referenceRange(vertRange), verticalRange(vertRange), vscale(vs) {
	Init();
}

void
ScaledArea::Init() {
	SetClassName("ScaledArea");
}

ScaledArea::~ScaledArea() {
}

void
ScaledArea::Reconfig() {
	checkScales();
	adjustVerticalRange();
}

void
ScaledArea::Resize() {
	BorderedArea::Resize();
	checkScales();
	adjustVerticalRange();
}

void
ScaledArea::Update() {
	checkScales();
	BorderedArea::Update();
}

double
ScaledArea::vertScaleFactor() {
	return currentHeight()/verticalRange.spread();
}

int
ScaledArea::vertOriginLocation() {
	double factor = 1.0 - verticalRange.max()/verticalRange.spread();
	return iround(currentHeight() * factor) + BorderedArea::bottomBorder();
}

// FIX ME:  this probably only needs to be done during Reconfig and Resize

void
ScaledArea::checkScales() {
	if(vscale != nil) {
		setVertMargins(vscale->topMargin(), vscale->bottomMargin());
//		shape->height = vscale->Height();
	}
}

void
ScaledArea::setReferenceRange(const Range &r) {
	referenceRange = r;
	referenceRange.check();
}

double
ScaledArea::currentHGrain() {
	int nframes = perspective->curwidth;
	return (nframes > 0) ? currentWidth()/double(nframes) : 1.0;
}

double
ScaledArea::currentVGrain() {
	return double(perspective->curheight)/perspective->height;
}

void
ScaledArea::doAdjust() {
	adjustVerticalRange();
}

void
ScaledArea::adjustVerticalRange() {
	verticalRange = referenceRange;
	verticalRange.scaleBy(currentVGrain()).check();
}
