/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.connector.rmi;

import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;

import javax.management.Notification;
import javax.management.NotificationFilter;

/**
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 */
class RemoteNotificationFilterImpl extends RemoteObject implements RemoteNotificationFilter
{
	private NotificationFilter m_realFilter;

	RemoteNotificationFilterImpl(NotificationFilter realFilter)
	{
		m_realFilter = realFilter;
	}

	public boolean isNotificationEnabled(Notification notification) throws RemoteException
	{
		// We are on the client

		// Forward the call to the real filter
		return m_realFilter.isNotificationEnabled(notification);
	}
}
