/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.adaptor.rmi;

import java.util.Properties;

/**
 * Management interface for the RMIAdaptor MBean.
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 */
public interface RMIAdaptorMBean
{
   /**
    * Starts this adaptor, so that it can accept incoming calls
    * @see #stop
    * @see #isRunning
    */
   public void start() throws Exception;

   /**
    * Stops this adaptor, so that it does not accept incoming calls anymore
    * @see #start
    */
   public void stop() throws Exception;

   /**
    * Returns whether this adaptor has been started and not been stopped.
    * @see #stop
    */
   public boolean isRunning();

   /**
    * Returns the protocol of this adaptor
    */
   public String getProtocol();

   /**
    * Returns the JNDI name under which this RMI Adaptor is registered
    */
   public String getJNDIName();

   /**
    * Sets the JNDI name under which the RMI adaptor should be registered. <br> This method can be called only if this adaptor is not running.
    */
   public void setJNDIName(String name);

   /**
    * Puts a JNDI property in the environment for the JNDI Initial Context used by this adaptor. <br> This method can be called only if this adaptor is not running.
    * @see #clearJNDIProperties
    */
   public void putJNDIProperty(Object property, Object value);

   /**
    * @deprecated Replaced by {link #putJNDIProperty}
    */
   public void putNamingProperty(Object property, Object value);

   /**
    * Resets the JNDI properties set for this adaptor. <br> This method can be called only if this adaptor is not running.
    * @see #putJNDIProperty
    */
   public void clearJNDIProperties();

   /**
    * @deprecated Replaced by {link #clearJNDIProperties}
    */
   public void clearNamingProperties();

   /**
    * Returns the JNDI properties for this adaptor. <br>
    * @see #putJNDIProperty
    */
   public Properties getJNDIProperties();

   /**
    * @deprecated Replaced by {link #getJNDIProperties}
    */
   public Properties getNamingProperties();

   /**
    * Returns the host name on which this adaptor is running
    */
   public String getHostName();

   /**
    * Returns the host address on which this adaptor is running
    */
   public String getHostAddress();
}
