//LabPlot : Rect.h

#ifndef RECT_H
#define RECT_H

#include <qcolor.h>
#include <qpainter.h>
#include <qstringlist.h>
#include "Point.h"

class Rect
{
public:
	Rect(Point s=0,Point e=0,QColor c="black",int w=1,bool f=true, QColor fi="white");
	QStringList Info();
	void save(QTextStream *t);
	void open(QTextStream *t,int version);
	Point startPoint() { return start; }
	Point endPoint() { return end; }
	void setStartPoint(double x, double y) { start=Point(x,y);}
	void setEndPoint(double x, double y) { end=Point(x,y);}
	int Width() { return width; }
	QColor Color() { return color; }
	QColor FillColor() { return fill; }
	void draw(QPainter *p, double w, double h);
	bool isFilled() { return filled; }
	bool inside(int x, int y, int w, int h);
protected:
	Point start, end;
	QColor color;
	int width;
	bool filled;
	QColor fill;
};

#endif //RECT_H
