//LabPlot : OperationsListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <qstring.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qcolordialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "OperationsListDialog.h"

#ifdef HAVE_GSL
#include <gsl/gsl_fft_real.h>
#include <gsl/gsl_fft_halfcomplex.h>
#endif

inline int MAX(int x,int y) {if (x>y) return x; else return y;}

OperationsListDialog::OperationsListDialog(Worksheet *p, Spreadsheet *s, const char *name)
	: ListDialog(p, s, name)
{
	setCaption(i18n("Operations Dialog"));

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);
	
	QHBox *hb = new QHBox(tab1);
	
	type = new KComboBox(hb);
	QStringList tlist;
	tlist << i18n("add") << i18n("substract") << i18n("multiply") << i18n("divide");
	type->insertStringList(tlist);
	type->setCurrentItem(0);
	
	hb = new QHBox(tab1);
	new QLabel(i18n("set "),hb);
	set1le = new KLineEdit(QString("1"),hb);
	new QLabel(i18n("with set "),hb);
	set2le = new KLineEdit(QString("2"),hb);
	
	Style style;
	Symbol symbol;
	QVBox *styletab;
	if(p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw);
	else
		styletab = simpleStyle(tw,0, &style, &symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));
	
	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void OperationsListDialog::apply_clicked() {
	unsigned int item1 = set1le->text().toInt()-1;
	unsigned int item2 = set2le->text().toInt()-1;
	int t = type->currentItem();
	
	GraphList *gl = p->getPlot(p->API())->getGraphList();

	if (item1 > gl->getNumber() || item2 > gl->getNumber()) {
		KMessageBox::error(this, i18n("Sorry. Can not find selected data sets!"));
		return;
	}
	
	GRAPHType s1 = gl->getStruct(item1);
	GRAPHType s2 = gl->getStruct(item2);

	if (s1 == GRAPH2D && s2 == GRAPH2D ) {
		Graph2D *g1 = gl->getGraph2D(item1);
		Graph2D *g2 = gl->getGraph2D(item2);
		int nr1=g1->Number();//, nr2 =g2->Number() ;

		Point *data1=g1->Data(), *data2=g2->Data();

		// make new data set from conv[signr];
		Point *ptr = new Point[nr1];
		double xmin=0, xmax=1, ymin=0, ymax=1;
		for (int i = 0;i<nr1;i++) {
			double x=data1[i].X();
			double y;
			 
			switch(t) {
			case 0 : y=data1[i].Y()+data2[i].Y();break; 
			case 1 : y=data1[i].Y()-data2[i].Y();break; 
			case 2 : y=data1[i].Y()*data2[i].Y();break; 
			case 3 : y=data1[i].Y()/data2[i].Y();break; 
			}
			
			// new ranges
			if (i==0) {
				xmin=xmax=x;
				ymin=ymax=y;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}

			ptr[i].setPoint(x,y);
		}

		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		QString fun;
		if (t==0)
			fun = QString(i18n("sum of ")+g1->Label()+i18n(" with ")+g2->Label());
		else if (t==1)
			fun = QString(i18n("substract of ")+g1->Label()+i18n(" from ")+g2->Label());
		else if (t==2)
			fun = QString(i18n("multiply of ")+g1->Label()+i18n(" with ")+g2->Label());
		else if (t==3)
			fun = QString(i18n("divide of ")+g1->Label()+i18n(" through ")+g2->Label());
			
		Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			widthle->text().toInt(),pencb->currentItem(),brushcb->currentItem());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
		
		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,nr1);
		p->addGraph2D(ng);
	}
	else if (s1 == GRAPH3D) {
		// TODO
	}
	else if (s1 == GRAPHM) {
		// TODO
	}

	updateList();
}
