//LabPlot : Arrow.h

#ifndef ARROW_H
#define ARROW_H

#include <qcolor.h>
#include <qpainter.h>
#include <qstringlist.h>
#include "Point.h"

class Arrow
{
public:
	Arrow(bool l=0,bool e=false,double le=0.1,double a=30,bool f=true,
		QColor fc=QColor("blue"));
	QStringList Info();
	void save(QTextStream *t);
	void open(QTextStream *t,int version);
	void setLocation(bool l) { location=l; }
	bool Enabled() { return enabled; }
	double Length() { return length; }
	double Angle() { return angle; }
	bool Filled() { return filled; }
	QColor fillColor() { return fillcolor; }
	void draw(QPainter *p, Point start, Point end, int X, int Y);
	
protected:
	bool location;		// 0-start, 1-end
	bool enabled;
	double length;	// 0..1
	double angle;
	bool filled;
	QColor fillcolor;
};

#endif //ARROW_H
