/*
                   (C) Copyright 2000-2002 NAVICON ApS
                   Author: Carsten O. Madsen
$Id: GRASSSiteLayer.h,v 1.2 2002/04/23 09:28:18 com Exp $
*/

#ifndef GRASSSITELAYER_H
#define GRASSSITELAYER_H

#include <GRASSLayer.h>

#include <stdio.h>



class GRASSPainter;
class QPainter;



extern "C" {
#include <gis.h>
#include <raster.h>
#include <site.h>

}


/**
 *
 *
 **/

class GRASSSiteLayer : public GRASSLayer {
public:  
  
  GRASSSiteLayer(GRASSPainter* painter, 
		 char* name,
		 char* mapset);

  ~GRASSSiteLayer();

  virtual void draw(QPainter* p);

  virtual int rtti();

  static int const GRASSSiteLayerID = 3;
  
private:
  
  GRASSPainter* _painter;


  void draw_points_diamond(QPainter* p);

  int next_point(double* U_X, double* U_Y);

  FILE* infile;

  // size in pixels
  short _pixSize;

  Site *s;

};




#endif /* GRASSSITELAYER_H */
