//
// C++ Implementation: textfields
//
// Description:
//
//
// Author: John Volpe <jtvolpe@cape.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <qstring.h>
#include <qstringlist.h>

#include <klocale.h>

#include "textfields.h"

QStringList TextFieldNames ;
QStringList TextFieldData ;
QString FieldName ;
QString FieldData ;

TextFields::TextFields(void)

{
int idx ;

for(idx = ID_ITEM_FIRST ; idx < ID_ITEM_END ; idx++)
    {
    TextFieldData += TextField(idx) ;
    TextFieldNames += FieldName ;
    }
}

QString TextFields::TextFieldName( int index )
{
    TextField(index) ;
    return FieldName ;
}

QString TextFields::TextField( int index )
{
    switch( index ) {
        case ID_ITEM_GROUP:
            FieldData = "[group]";
            FieldName = i18n("Group") ;
            break;
        case ID_ITEM_FILENAME:
            FieldData = "[filename]";
            FieldName = i18n("File Name") ;
            break;
        case ID_ITEM_DATE:
            FieldData = "[date]";
            FieldName = i18n("Date") ;
            break;
        case ID_ITEM_ARTICLE_NO:
            FieldData = "[article_no]";
            FieldName = i18n("Article Number") ;
            break;
        case ID_ITEM_ARTICLE_DESCRIPTION:
            FieldData = "[article_desc]";
            FieldName = i18n("Article Description") ;
            break;
        case ID_ITEM_BARCODE_NO:
            FieldData = "[barcode_no]";
            FieldName = i18n("Barcode Number") ;
            break;
        case ID_ITEM_BARCODE_NO_BASIC:
            FieldData = "[barcode_no_basic]";
            FieldName = i18n("Barcode Number Basic") ;
            break;
        case ID_ITEM_BARCODE_NO_CUSTOMER:
            FieldData="[barcode_no_customer]";
            FieldName = i18n("Barocde Number Customer") ;
            break;
        case ID_ITEM_ARTICLE_NO_CUSTOMER:
            FieldData="[article_no_customer]";
            FieldName = i18n("Article Number Customer") ;
            break;
        case ID_ITEM_FIELD_0:
            FieldData = "[field0]";
            FieldName = i18n("Field 0") ;
            break;
        case ID_ITEM_FIELD_1:
            FieldData = "[field1]";
            FieldName = i18n("Field 1") ;
            break;
        case ID_ITEM_FIELD_2:
            FieldData = "[field2]";
            FieldName = i18n("Field 2") ;
            break;
        case ID_ITEM_FIELD_3:
            FieldData = "[field3]";
            FieldName = i18n("Field 3") ;
            break;
        case ID_ITEM_FIELD_4:
            FieldData = "[field4]";
            FieldName = i18n("Field 4") ;
            break;
        case ID_ITEM_FIELD_5:
            FieldData = "[field5]";
            FieldName = i18n("Field 5") ;
            break;
        case ID_ITEM_FIELD_6:
            FieldData = "[field6]";
            FieldName = i18n("Field 6") ;
            break;
        case ID_ITEM_FIELD_7:
            FieldData = "[field7]";
            FieldName = i18n("Field 7") ;
            break;
        case ID_ITEM_FIELD_8:
            FieldData = "[field8]";
            FieldName = i18n("Field 8") ;
            break;
        case ID_ITEM_FIELD_9:
            FieldData = "[field9]";
            FieldName = i18n("Field 9") ;
            break;
        case ID_ITEM_CUSTOMER_NAME:
            FieldData = "[customer_name]";
            FieldName = i18n("Customer Name") ;
            break;
        case ID_ITEM_CUSTOMER_NO:
            FieldData = "[customer_no]";
            FieldName = i18n("Customer Number") ;
            break;
        case ID_ITEM_LINE_0:
            FieldData = "[line0]";
            FieldName = i18n("Line 0") ;
            break;
        case ID_ITEM_LINE_1:
            FieldData = "[line1]";
            FieldName = i18n("Line 1") ;
            break;
        case ID_ITEM_LINE_2:
            FieldData = "[line2]";
            FieldName = i18n("Line 2") ;
            break;
        case ID_ITEM_LINE_3:
            FieldData = "[line3]";
            FieldName = i18n("Line 3") ;
            break;
        case ID_ITEM_LINE_4:
            FieldData = "[line4]";
            FieldName = i18n("Line 4") ;
            break;
        case ID_ITEM_LINE_5:
            FieldData = "[line5]";
            FieldName = i18n("Line 5") ;
            break;
        case ID_ITEM_LINE_6:
            FieldData = "[line6]";
            FieldName = i18n("Line 6") ;
            break;
        case ID_ITEM_LINE_7:
            FieldData = "[line7]";
            FieldName = i18n("Line 7") ;
            break;
        case ID_ITEM_LINE_8:
            FieldData = "[line8]";
            FieldName = i18n("Line 8") ;
            break;
        case ID_ITEM_LINE_9:
            FieldData = "[line9]";
            FieldName = i18n("Line 9") ;
            break;
        case ID_ITEM_ENCODING_TYPE:
            FieldData = "[encoding_type]";
            FieldName = i18n("Encoding Type") ;
            break;
        case ID_RESOLUTION:
            FieldData = "[resolution]";
            FieldName = i18n("Resolution") ;
            break;
        case ID_INDEX:
            FieldData = "[index]";
            FieldName = i18n("Index") ;
            break;
        case ID_SERIAL:
            FieldData = "[serial]";
            FieldName = i18n("Serial Number") ;
            break;
        case ID_ITEM_SHORT_WEEKDAY_NAME:   // %a
            FieldData = "[date:%a]";
            FieldName = i18n("Short Weekday Name") ;
            break;
        case ID_ITEM_FULL_WEEKDAY_NAME:    // %A
            FieldData = "[date:%A]";
            FieldName = i18n("Full Weekday Name") ;
            break;
        case ID_ITEM_SHORT_MONTH_NAME:     // %b
            FieldData = "[date:%b]";
            FieldName = i18n("Short Month Name") ;
            break;
        case ID_ITEM_FULL_MONTH_NAME:      // %B
            FieldData = "[date:%B]";
            FieldName = i18n("Full Month Name") ;
            break;
        case ID_ITEM_DATE_TIME:            // %c
            FieldData = "[date:%c]";
            FieldName = i18n("Date-Time") ;
            break;
        case ID_ITEM_CENTURY:              // %C
            FieldData = "[date:%C]";
            FieldName = i18n("Century") ;
            break;
        case ID_ITEM_DAY_NUMBER_NN:      // %d
            FieldData = "[date:%d]";
            FieldName = i18n("Day Number (01-31)") ;
            break;
        case ID_ITEM_MONTH_DAY_YEAR:       // %D
            FieldData = "[date:%D]";
            FieldName = i18n("Month-Day-year") ;
            break;
        case ID_ITEM_DAY_NUMBER__N:      // %e
            FieldData = "[date:%e]";
            FieldName = i18n("Day Number ( 1-31)") ;
            break;
        case ID_ITEM_YEAR_MONTH_DAY:       // %F
            FieldData = "[date:%F]";
            FieldName = i18n("Year-Month-day") ;
            break;
        case ID_ITEM_WEEK_YY:              // %g
            FieldData = "[date:%g]";
            FieldName = i18n("Week Year (yy)") ;
            break;
        case ID_ITEM_WEEK_YYYY:            // %G
            FieldData = "[date:%G]";
            FieldName = i18n("Week Year (yyyy)") ;
            break;
        case ID_ITEM_HOUR_HH:              // %H
            FieldData = "[date:%H]";
            FieldName = i18n("Hour (01-24)") ;
            break;
        case ID_ITEM_HOUR_hh:              // %I
            FieldData = "[date:%I]";
            FieldName = i18n("Hour (1-12)") ;
            break;
        case ID_ITEM_DAY_OF_YEAR:          // %J
            FieldData = "[date:%J]";
            FieldName = i18n("Day of Year") ;
            break;
        case ID_ITEM_MONTH_mm:             // %m
            FieldData = "[date:%m]";
            FieldName = i18n("Month Number (01-12)") ;
            break;
        case ID_ITEM_MINUTE_mm:            // %M
            FieldData = "[date:%M]";
            FieldName = i18n("Minute (00-59)") ;
            break;
        case ID_ITEM_AM_PM:                // %p
            FieldData = "[date:%p]";
            FieldName = i18n("a.m./p.m.") ;
            break;
        case ID_ITEM_TIME_r:               // %r
            FieldData = "[date:%r]";
            FieldName = i18n("Time (h:m:s am/pm)") ;
            break;
        case ID_ITEM_TIME_R:               // %R
            FieldData = "[date:%R]";
            FieldName = i18n("Time (HH:MM)") ;
            break;
        case ID_ITEM_SECONDS_ss:           // %S
            FieldData = "[date:%S]";
            FieldName = i18n("Seconds (00-59)") ;
            break;
        case ID_ITEM_TIME_HHMMSS:          // %T
            FieldData = "[date:%T]";
            FieldName = i18n("Time (HH:MM:SS)") ;
            break;
        case ID_ITEM_WEEKDAY_nn:           // %u
            FieldData = "[date:%u]";
            FieldName = i18n("Weekday (1=Monday...)") ;
            break;
        case ID_ITEM_WEEK_U:            // %U
            FieldData = "[date:%U]";
            FieldName = i18n("Week Number (00-53)") ;
            break;
        case ID_ITEM_WEEK_V:            // %V
            FieldData = "[date:%V]";
            FieldName = i18n("Week Number (01-53)") ;
            break;
        case ID_ITEM_WEEKDAY_w:            // %w
            FieldData = "[date:%w]";
            FieldName = i18n("Weekday (0=Sunday...)") ;
            break;
        case ID_ITEM_WEEK_W:              // %W
            FieldData = "[date:%W]";
            FieldName = i18n("Week Number (00-53)") ;
            break;
        case ID_ITEM_DATE_x:               // %x
            FieldData = "[date:%x]";
            FieldName = i18n("Local Date") ;
            break;
        case ID_ITEM_TIME_X:               // %X
            FieldData = "[date:%X]";
            FieldName = i18n("Local Time") ;
            break;
        case ID_ITEM_YEAR_yy:              // %y
            FieldData = "[date:%y]";
            FieldName = i18n("Year (00-99)") ;
            break;
        case ID_ITEM_YEAR_YYYY:            // %Y
            FieldData = "[date:%Y]";
            FieldName = i18n("Year (YYYY)") ;
            break;
        case ID_ITEM_UTC_OFFSET:           // %z
            FieldData = "[date:%z]";
            FieldName = i18n("Offset from UTC") ;
            break;
        case ID_ITEM_TIMEZONE:             // %Z
            FieldData = "[date:%Z]";
            FieldName = i18n("Timezone Name") ;
            break;
        default :
            FieldData = "[******]" ;
            FieldName = i18n("Undefined") ;
            break ;
        }

    return FieldData ;
}
