/***************************************************************************
                          label.cpp  -  description
                             -------------------
    begin                : Mon Apr 29 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "label.h"
#include "kbarcode.h"
#include "printersettings.h"
#include "sqltables.h"

// Qt includes
#include <qimage.h>
#include <qiodevice.h>
#include <qpaintdevicemetrics.h>
#include <qpainter.h>
#include <qpen.h>
#include <qsqlcursor.h>
#include <qxml.h>

// KDE includes
#include <kapplication.h>
#include <klocale.h>
#include <kprinter.h>

Label::Label( Definition* _def, QIODevice* device, QString labelname, QPaintDevice* _printer, QString customer_id, QString _article_no, QString _group )
    : TokenProvider( _printer )
{
    m_sequence = false;
    m_printer = 0;
   
    setCustomerNo( customer_id );
    setArticleNo( _article_no );
    setGroup( _group );
    setLabelName( labelname.right( labelname.length() - labelname.findRev( "/" ) - 1 ) );

    d = _def;

    load( device );
    draw();
}

Label::~Label()
{
    delete doc;
}

QPicture* Label::picture()
 {
    if( update() || m_sequence )
        draw();
      
    return &p;
 }
 

void Label::draw()
{
    QPaintDeviceMetrics metrics( paintDevice() );
    double scalex = (double)metrics.logicalDpiX() / (double)QPaintDevice::x11AppDpiX();
    double scaley = (double)metrics.logicalDpiY() / (double)QPaintDevice::x11AppDpiY();

    // First look for the first barcodes
    // to set barcode_no and encoding_type
    QDomNodeList list = doc->elementsByTagName( "barcode" );
    for( unsigned int i = 0; i < list.count(); i++ ) {
        QDomElement e = list.item( i ).toElement();
        if( !e.isNull() ) {
            barcodeData data = readBarcode( &e );
            m_sequence = data.sequence.enabled || m_sequence;
            setBarcodeValue( &data );

            BarCode barcode( &data );
            barcode.setIndex( index() );
            setBarcodeNo( barcode.sequenceValue() );
            
            setEncodingTypeName( data.type );

            // we care only about the first barcode of the label
            // only relevant for labels that contain e.g. 2 barcodes
            break;
        }
    }
    
    // now start painting
    QPainter painter( &p );

    // get the lowest z value from XML
    int lowz = getLowestZ();

    // get highest z value from XML
    int highz = getHighestZ();
    
    // paint in z order   
    for( int z = lowz; z <= highz; z++ ) {
        QDomNodeList bcodelist = doc->elementsByTagName( "barcode" );
        for( unsigned int i = 0; i < bcodelist.count(); i++ ) {
            QDomElement e = bcodelist.item( i ).toElement();
            if( !e.isNull() && e.attribute( "z", "0" ).toInt() == z ) {
                barcodeData data = readBarcode( &e );
                setBarcodeValue( &data );
                BarCode* b = new BarCode( &data );
                b->setIndex( index() );

                QPixmap barcode = b->printerPixmap( paintDevice() );
                QPoint point( int(data.xml.x * scalex), int(data.xml.y * scaley) );

                QPicture pic;
                QPainter p( &pic );
                p.drawPixmap( 0, 0, barcode );
                p.end();

                /* this hack is required to work around a bug,
                 * probably in qt.
                 * barcodes where printed in the wrong place
                 * when drawing the pixmap directly.
                 * Maybe the z coordinate is related to this bug.
                 */
                painter.drawPicture( point, pic );

                delete b;
            }
        }    

        // TODO: create a global static map of pictures
        // so that they only have to be loaded once
        bcodelist = doc->elementsByTagName( "picture" );
        for( unsigned int i = 0; i < bcodelist.count(); i++ ) {
            QDomElement e = bcodelist.item( i ).toElement();
            if( !e.isNull() && e.attribute( "z", "0" ).toInt() == z ) {
                QRect r = readXMLRect( &e );
                QImage img;
                img.loadFromData( e.text().utf8(), "XPM" );

                // restore image geometry
                img = img.smoothScale( r.width(), r.height() );

                QWMatrix m;
                m.rotate( e.attribute("rotation", "0.0" ).toDouble() );
                img = img.xForm( m );

                painter.save();
                    painter.scale( scalex, scaley );
                    painter.drawImage( r.x(), r.y(), img );
                painter.restore();
            }
        }

        bcodelist = doc->elementsByTagName( "rect" );
        for( unsigned int i = 0; i < bcodelist.count(); i++ ) {
            QDomElement e = bcodelist.item( i ).toElement();
            if( !e.isNull() && e.attribute( "z", "0" ).toInt() == z ) {
                QColor c = readXMLColor( &e, "color", Qt::black );

                QRect r = readXMLRect( &e );

                int m_border = e.attribute( "borderwidth", "1" ).toInt();
                QRect rect( r.x() + m_border, r.y() + m_border, r.width() - 2 * m_border, r.height() - 2 * m_border );
                    
                painter.save();
                    painter.scale( scalex, scaley );
                    painter.setPen( QPen( readXMLColor( &e, "bordercolor", Qt::black ),
                        m_border, (Qt::PenStyle)e.attribute( "borderstyle", "1" ).toInt() ) );
                    painter.setBrush( QBrush( c, Qt::SolidPattern ) );
                        
                    if( e.attribute( "circle", "0" ).toInt() )
                        painter.drawEllipse( rect );
                    else
                        painter.drawRect( rect );
                painter.restore();
            }
        }

        bcodelist = doc->elementsByTagName( "line" );
        for( unsigned int i = 0; i < bcodelist.count(); i++ ) {
            QDomElement e = bcodelist.item( i ).toElement();
            if( !e.isNull() && e.attribute( "z", "0" ).toInt() == z ) {
                int m_border = e.attribute( "width", "1" ).toInt();
                QPen pen( readXMLColor( &e, "color", Qt::black ),
                          m_border, (Qt::PenStyle)e.attribute( "style", "1" ).toInt() );

                painter.save();
                    painter.scale( scalex, scaley );
                    painter.setPen( pen );
                    int x = e.attribute( "x", "0" ).toInt();
                    int y = e.attribute( "y", "0" ).toInt();
                    painter.drawLine( e.attribute( "x1", "0" ).toInt() - x, e.attribute( "y1", "0" ).toInt() - y,
                                      e.attribute( "x2", "0" ).toInt() - x, e.attribute( "y2", "0" ).toInt() - y );
                painter.restore();
            }
        }
                        
        bcodelist = doc->elementsByTagName( "textfield" );
        for( unsigned int i = 0; i < bcodelist.count(); i++ ) {
            QDomElement e = bcodelist.item( i ).toElement();
            if( !e.isNull() && e.attribute( "z", "0" ).toInt() == z ) {
                QString text;
                QDomNode n = e.firstChild();
                painter.setPen( Qt::black );

                while( !n.isNull() ) {
                    QDomElement e = n.toElement();
                    if( !e.isNull() && e.tagName() == "text" )
                        text = e.text();

                    n = n.nextSibling();
                }

                // autotext!!!
                bool autosize = false;
                QString tmp = parse( text );
                if( tmp != text )
                    autosize = true;
                text = tmp;
                                                
                QRect r = readXMLRect( &e );
                if( autosize ) {
                    QSize s = stringSize( text );
                    if( r.width() < s.width() && r.height() < s.height() ) {
                        r.setHeight( s.height() );
                        r.setWidth( s.width() );
                    }                        
                }
                                        
                double rot = e.attribute("rotation", "0.0" ).toDouble();
                if( rot != 0.0 ) {
                    painter.save();
                    painter.scale( scalex, scaley );
                    QPixmap* pix = drawString( text, r.width(), r.height(), rot );
                    painter.drawPixmap( r.x(), r.y(), *pix );
                    delete pix;
                    painter.restore();
                } else {
                    painter.save();
                    painter.translate( int(r.x() * scalex), int(r.y() * scaley) );
                    renderString( &painter, text, r.width(), r.height(), scalex, scaley );
                    painter.translate( -(int)(r.x() * scalex), -(int)(r.y()*scaley) );
                    painter.restore();
                }
            }
        }
    }

    updateDone();
}

void Label::setBarcodeValue( barcodeData* data )
{
    // use the same i18n() for static as in BarcodeSettingsDlg
    if( data->xml.caption.lower() != "static" && data->xml.caption != i18n("Static") ) {
        QString encoding_type = getTypeFromCaption( data->xml.caption );
        QString mode = getModeFromCaption( data->xml.caption );
        QSqlQuery query( "select barcode_no, encoding_type from " TABLE_BASIC 
                         " where article_no = '" + articleNo() + "'" ); 
        while ( query.next() ) {
            data->value = query.value(0).toString();
            data->type = query.value(1).toString();
        }

        if( mode.lower() != "main" ) {
            QSqlQuery query1( "select barcode_no from " TABLE_CUSTOMER_TEXT " where customer_no ='"+ mode +
                             "' and article_no='" + articleNo() + "'" );
            while ( query1.next() ) {
                if( !query1.value(0).toString().isEmpty() ) {
                    data->value = query1.value(0).toString();
                    data->type = encoding_type;
                }
            }
        }
    }
}

void Label::load( QIODevice* device )
{
    if( !device ) return;

    if( !device->isOpen() )
        device->open( IO_ReadOnly );

    doc = new QDomDocument( "KBarcodeLabel" );        
    doc->setContent( device );
    device->close();    
}

int Label::getLowestZ()
{
    int z = 0;

    QStringList tags;
    tags << "barcode" << "picture" << "textfield" << "rect" << "line";

    for( unsigned int a = 0; a < tags.count(); a++ ) {
        QDomNodeList list = doc->elementsByTagName( tags[a] );
        for( unsigned int i = 0; i < list.count(); i++ ) {
            QDomElement e = list.item( i ).toElement();
            if( !e.isNull() ) {
                int v = e.attribute( "z", "0" ).toInt();
                z = v < z ? v : z;
            }
        }
    }
        
    return z;
}

int Label::getHighestZ()
{
    int z = 0;

    QStringList tags;
    tags << "barcode" << "picture" << "textfield" << "rect" << "line";

    for( unsigned int a = 0; a < tags.count(); a++ ) {
        QDomNodeList list = doc->elementsByTagName( tags[a] );
        for( unsigned int i = 0; i < list.count(); i++ ) {
            QDomElement e = list.item( i ).toElement();
            if( !e.isNull() ) {
                int v = e.attribute( "z", "0" ).toInt();
                z = v > z ? v : z;
            }
        }
    }
        
    return z;
}


void Label::getXLabel( double x, double y, double width, double height, QPainter* painter, int mode, QString value )
{
    painter->save();
    if( mode == LABEL_X ) {
        painter->setPen( QPen( Qt::black, 5) );
        painter->drawLine( (int)x, (int)y, int(x+width), int(y+height) );
        painter->drawLine( (int)x, int(y+height), int(x+width), (int)y );
    } else if( mode == ARTICLE_GROUP_NO ) {
        painter->setPen( QPen( QPen::black, 1 ) );
        QFont f( "helvetica", 15 );
        int w = 0;
        do {
            f.setPointSize( f.pointSize() - 1 );
            painter->setFont( f );
            w = painter->fontMetrics().width( value );
        } while( w > width && f.pointSize() > 0 );

        painter->drawText( int(x + (width-w)/2), int(y + (height-f.pointSize())/2), value);
    }

    painter->restore();
    return;
}

int Label::getId() const
{
    if( d )
        return d->getId();

    return -1;
};

