/***************************************************************************
                          batchprinter.h  -  description
                             -------------------
    begin                : Sat Jan 10 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BATCHPRINTER_H
#define BATCHPRINTER_H

#include <qvaluelist.h>

class Definition;
class Label;
class KPrinter;
class Measurements;
class QBuffer;
class QPainter;
class QProgressDialog;
class QWidget;

/**
    This class is responsible for batch printing of articles.
    It is also responsible for creating images of all articles.
    @author Dominik Seichter
*/
class BatchPrinter
{
    public:
        struct data {
            int number;
            QString article_no;
            QString group;
        };

        /** Use this constructor if you want to print to
          * a printer.
          */
        BatchPrinter( KPrinter* p, QWidget* _parent );
        /** This constructor is used in image gernaration mode.
          * @p path is the path to an existing directory where
          * the images are saved.
          */
        BatchPrinter( const QString & path, QWidget* p );
        ~BatchPrinter();

        void setBuffer( QBuffer* b ) { buffer = b; }
        void setCustomer( const QString & s ) { m_customer = s; }
        void setMove( int m ) { m_move = m; }
        void setData( QValueList<data>* list ) { m_data = list; }
        void setSerial( const QString & s, unsigned int inc ) { m_serial = s; m_increment = inc; }
        void setName( const QString & s ) { m_name = s; }
        void setDefinition( Definition* d ) { def = d; }
        void setLabels( int l ) { m_labels = l; }
        void setEvents( bool b ) { m_events = b; }

        /** start the batch printing on a printer
          */
        void start();
        /** start image generation
          */
        void startImages();

    private:
        /** starts a new page on the printer, if the
          * current label does not fit anymore on the current pageh
          */
        void checkForNewPage( Label* label );
        /** draw a border around the current label using QPainter @p painter
          */
        void drawBorders();
        /** start a "new line" on the printer,
          * i.e. beginn the second row of labels
          * on the page.
          */
        void changeLine();
        void proccessEvents( int lb, QString value = QString::null, Label* label = 0 );
        void printXLabel( int lb, Label* label, const QString & value );
        void moveLabels();
        /** Create and return a progressdialog
          */
        QProgressDialog* createProgressDialog( const QString & caption );
        bool checkProgressDialog( QProgressDialog* progress );

        Definition* def;
        Measurements* measure;
        QValueList<data>* m_data;

        QString m_serial;
        QString m_name;
        QString m_customer;
        /** Path for image output
          */
        QString m_path;

        /** defines the format of the filename for images
         */
        bool m_filename_article;
        /** enable/disable events
          */
        bool m_events;

        /** defines the image format to be used
          */
        QString m_format;

        unsigned int m_increment;
        unsigned int m_move;
        /** number of labels to print for the progress dialog
          */
        unsigned int m_labels;

        /** height of the current page in pixel.
          */
        double pageh;
        double curw;
        double curh;
        int c_h;
        int c_w;

        QBuffer* buffer;
        KPrinter* printer;
        QPainter* painter;
        /** parent for dialogs
          */
        QWidget* parent;
};

#endif
