# -*- coding: iso-8859-1 -*-
""" Album wizard implementation

    begin                : Sat Dec 14 2002
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: AlbumWiz.py,v 1.24 2004/07/31 16:59:09 niederberger Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__version__ = "$Revision: 1.24 $"

from string import *
from HTMLAlbum import *

try:
    from AlbumForm import *
    from BatchEditWnd import *
except:
    print "AlbumWiz: Unable to import some imgSeek modules. Some features will not work."

class AlbumWiz(htmlalbumform):

    def __init__(self, parent,env):
        htmlalbumform.__init__(self,parent)
        self.env = env
        self.helpButton().hide()        #show help for this wizard. Until it's not done, just hide the button
        self.curdb = self.env.curdb
        self.curBatch = -1
        self.setFinishEnabled(self.page3,1)
        self.themecomboBox.insertItem("Acqua")
        self.themecomboBox.insertItem("Slides")
        for cap in self.curdb.metafields:#TODO0: sort these alphabetically
            self.availablecaptionlist.insertItem(cap)
        self.curdb.cbs["Batch"].append(self.updateDirList)
        self.updateDirList()

    def showEvent(self,e):
        self.updateDirList()

    def updateDirList(self,what = None):
        """call it to sync curdb batch list to what the ui shows """
        self.batchcombo.clear()
        for bid in self.curdb.batches.keys():
            self.batchcombo.insertItem(self.curdb.batches[bid][0])
        if self.curBatch != -1:
            self.showBatch(self.curBatch)
        else:
            if len(self.curdb.batches.keys()):
                self.showBatch(self.curdb.batches.keys()[0])
            else:
                self.htmlsourcelistbox.clear()

    def showBatch(self,bid):
        txt = self.curdb.BatchToText(bid)
        self.htmlsourcelistbox.clear()
        self.curBatch = bid
        if not txt:
            return
        for it in txt:
            self.htmlsourcelistbox.insertItem(it[1]+" - "+it[0])

    def accept(self):
        htmlalbumform.accept(self)
        ha = HTMLAlbum(self)
        str = ha.start()
        QMessageBox.information( self, "imgSeek",str)

    def reject(self):
        htmlalbumform.reject(self)

    def htmlalbumform_helpClicked(self):
        pass

    def removehtmlsourcebtn_clicked(self):
        torem = []
        for i in range(self.htmlsourcelistbox.count()):
            if self.htmlsourcelistbox.isSelected(i): torem.append(i)
        while len(torem):
            wasrem = torem[0]
            self.htmlsourcelistbox.removeItem(torem[0])
            del torem[0]
            for i in range(len( torem)):
                if torem[i]>wasrem:torem[i] = torem[i]-1

    def addinfothumbbtn_clicked(self):
        for i in range(self.availablecaptionlist.count()):
            if self.availablecaptionlist.isSelected(i):
                self.includedcaptionlist.insertItem(self.availablecaptionlist.text(i))
                self.availablecaptionlist.removeItem(i)
                self.addinfothumbbtn_clicked()

    def delinfothumbbtn_clicked(self):
        for i in range(self.includedcaptionlist.count()):
            if self.includedcaptionlist.isSelected(i):
                self.availablecaptionlist.insertItem(self.includedcaptionlist.text(i))
                self.includedcaptionlist.removeItem(i)
                self.delinfothumbbtn_clicked()

    def inplaceradio_toggled(self,a0):
        return
        #self.destoptionsgroup.setEnabled(0)

    def symlinkradio_toggled(self,a0):
        return
        #self.destoptionsgroup.setEnabled(1)

    def batchedbtn_clicked(self):
        self.parent().editcategaction_activated()

    def batchcombo_activated(self,a0):
        try:
            bid = self.curdb.batches.keys()[a0]
        except:
            print "key Error showing desired batch"
            return
        self.showBatch(bid)
