<?php
// File           tb_show.php / ibWebAdmin
// Purpose        html sequence for the tb_show-panel in tables.php
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <00/09/08 12:12:25 lb>
//
// $Id: tb_show.php,v 1.16 2003/11/02 09:25:41 lbrueckner Exp $

$tcnt = 0;
if ($s_connected == TRUE && is_array($s_tables)) {
    foreach($s_tables as $tablename => $properties) {
        if ($properties['is_view'] == TRUE) {
            continue;
        }
        $tcnt++;

        $title    = ($s_tables_counts == 'yes'  &&  isset($properties['count'])) ? $tablename.'&nbsp;['.$properties['count'].']' : $tablename;
        $fold_url = fold_detail_url('table', $properties['status'], $tablename, $title);

        echo '      <div id="'.'t_'.$tablename."\" style=\"border-bottom: 1px solid black; margin: 1px;\">\n";

        if ($properties['status'] == 'open') {

            echo get_opened_table($tablename, $title, $fold_url);
        }
        else {   // $properties['status'] == 'close'
            
            echo get_closed_detail($title, $fold_url);
        }

        echo "      </div>\n";

    }    // foreach $s_tables
}

echo '<form method="post" action="'.$HTTP_SERVER_VARS['PHP_SELF']."\" name=\"tb_show_form\">\n"
     .hidden_session_field()
     .'<input type="checkbox" name="tb_show_counts" value="yes"'.($s_tables_counts == 'yes' ? ' checked' : '').">\n"
     .$tb_strings['DispCounts']."&nbsp;&nbsp;&nbsp;\n"
     .'<input type="submit" name="tb_show_reload" value="'.$button_strings['Reload']."\">&nbsp;&nbsp;&nbsp;\n";

if ($tcnt > 1) {
    echo '<input type="submit" name="tb_table_open" value="'.$button_strings['OpenAll']."\">&nbsp;&nbsp;&nbsp;\n";
    echo '<input type="submit" name="tb_table_close" value="'.$button_strings['CloseAll']."\">\n";
}

echo "</form>\n";

?>
