<?php
// File           script_start.inc.php
// Purpose        includes and initialisations needed in every main script
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <00/10/18 09:22:43 lb>
//
// $Id: script_start.inc.php,v 1.25 2004/05/30 16:53:37 lbrueckner Exp $

//apd_set_pprof_trace();

require('./inc/configuration.inc.php');

session_start();

if (DEBUG) $start_time = @microtime();

require('./lang/' . (isset($HTTP_SESSION_VARS['s_cust']['language']) ? $HTTP_SESSION_VARS['s_cust']['language'] : LANGUAGE) . '.inc.php');
require('./inc/session.inc.php');
require('./inc/functions.inc.php');
require('./inc/array_functions.inc.php');
require('./inc/interbase.inc.php');
require('./inc/panel_elements.inc.php');
require('./inc/javascript.inc.php');

if (DEBUG  ||  DEBUG_HTML) {
    include('./inc/debug_funcs.inc.php');
}

set_error_handler('error_handler');

ini_set('magic_quotes_runtime', '0');

if (!in_array('interbase', get_loaded_extensions())) {
    @dl('interbase.so')  ||  @dl('interbase.dll');
}

send_http_headers();

if (!isset($HTTP_SESSION_VARS['s_init'])
||  ($HTTP_SESSION_VARS['s_cookies'] === 'untested')) {
    if (!in_array('interbase', get_loaded_extensions())) {

        die($ERRORS['NO_IBASE_MODULE']);
    }
    initialize_session();
    fallback_session();
}
else {
    localize_session_vars();
}


// warnings and messages are collected in this strings, the output happens in panels/info.php
$message   = '';
$warning   = '';
$error     = '';
$ib_error  = '';
$php_error = '';
$debug     = array();
$externcmd = '';


// this string is filled in the panels and echoed in script_end.inc.php
// to avoid problems ns4.7 has with javascript inside of tables
$js_stack = '';

// the different tasks storing their sql-statements in this string
// for joint execution just before the panel-output
$sql =  '';


// connecting the database, the handle is used as a global variable,
// the connection is closed in inc/script_end.inc.php
if ($s_connected == TRUE  &&  !isset($HTTP_GET_VARS['unconnected'])) {

    $dbhandle = db_connect();

    if ($dbhandle === FALSE) {
        $ib_error = ibase_errmsg();
        $s_connected = FALSE;
        $s_tables_valid = FALSE;
        unset($s_watch_table);
    }

    if (empty($s_charsets)) {
        $s_charsets = get_charsets();
    }
}

// determine server family and version
list($family, $version) = server_info($s_login['server']);
define('SERVER_FAMILY', $family);
define('SERVER_VERSION', $version);


// set the path to the navigation icons used on the panels
$icon_path = DATAPATH . (BG_TRANSPARENT == TRUE ? 'transparent/' : 'opaque/') . strtolower(ICON_SIZE) . '/';
$open_icon  = $icon_path.'open.png';
$close_icon = $icon_path.'close.png';
$red_triangle_icon   = $icon_path.'red_triangle.png';
$green_triangle_icon = $icon_path.'green_triangle.png';


// check the availabillity of the isql binary
if ($s_binpath != BINPATH) {
    if (!is_dir(BINPATH)
    ||  (!is_file(BINPATH.'isql')  &&  !is_file(BINPATH.'isql.exe'))) {

        $warning = sprintf($WARNINGS['BAD_ISQLPATH'], BINPATH);
    }

    $s_binpath = BINPATH;
}

if (DEBUG_HTML) ob_start();

?>
