/* $Id: colors.cpp,v 1.4 2005/04/05 11:32:54 ellson Exp $ $Revision: 1.4 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/
#include "StringDict.h"
#include <map>
#include <stdio.h>
#include <stdlib.h>
#include "colors.h"
using namespace std;

typedef struct hsbcolor_t {
	char			*name;
	unsigned char	h,s,b;
} hsbcolor_t;

#include "../../tools/src/colortbl.h"

typedef map<DString,Color> named_colors;
named_colors g_namedColors;
void initNamed() {
    for(unsigned int i = 0; i<sizeof(color_lib)/sizeof(hsbcolor_t); ++i)
        g_namedColors[color_lib[i].name] = Color(color_lib[i].h/255.0f,color_lib[i].s/255.0f,color_lib[i].b/255.0f);
}
Color findColor(DString s) {
    if(g_namedColors.empty())
        initNamed();
    named_colors::iterator ci = g_namedColors.find(s);
    if(ci==g_namedColors.end())
        throw ColorNotFound(s);
    return ci->second;
}
