/*
 * GPG Keys 
 * cdlgsign.h
 * (c) 2001 Peter Mathiasson <peter@mathiasson.nu>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation
 */

#ifndef __CDLGSIGN_H__
#define __CDLGSIGN_H__

#include "cdlgsignui.h"

class QString;
class QProcess;
class QStatusBar;
class QStringList;

class CDlgSign : public CDlgSignUI
{
    Q_OBJECT

public:
    CDlgSign( QWidget *parent, const QString tmpKeyId );

public slots:
    void processDone();
    void readFromStdout();
    void doSign();

signals:
    void newPublic();

private:
    void readSecretKeys();

    QString keyId;
    QStringList keyIdList;
    QProcess *gpgProc;

};

#endif // __CDLGSIGN_H__

