/*
 * GPG Keys 
 * cdlgkeyserver.h
 * (c) 2001 Peter Mathiasson <peter@mathiasson.nu>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation
 */

#ifndef __CDLGSERVERSEARCH_H__
#define __CDLGSERVERSEARCH_H__

#include <qstring.h>
#include "cdlgserversearchui.h"

class CKeyServer;
class CListViewItem;
class QListViewItem;
class QStatusBar;
class QPopupMenu;
class QProcess;

class CDlgServerSearch : public CDlgServerSearchUI
{
    Q_OBJECT

public:
    CDlgServerSearch( QWidget *parent, const QString searchString = QString::null );

public slots:
    void startSearch();
    void searchDone();
    void statusChange( int newStatus );
    void itemFound( QString type, QString name, QString date, QString keyID );
    void contextMenuRequested( QListViewItem *tmpItem, const QPoint &pos, int );
    void importKey();
    void doImport( QString key );

signals:
    void newPublic();

private:
    CKeyServer *keyServer;
    CListViewItem *itemPub;
    CListViewItem *importItem;
    QStatusBar *statusBar;
    QPopupMenu *popupMenu;
    QProcess *gpgProc;

};

#endif // __CDLGSERVERSEARCH_H__
