/* Copyright (C) 2002,2003 Pascal Haakmat */

#ifndef MARKER_H
#define MARKER_H

#include <audiofile.h>

#define MARKER_IS_DISABLED (1 << 0)

enum marker_type {
    MARKER_SLOPE     = (1 << 0),
    MARKER_SLOPE_AUX = (1 << 1),
    MARKER_TEXT      = (1 << 2)
};

struct marker {
    enum marker_type type;
    AFframecount frame_offset;
    int flags;
    float multiplier;
    char *label;
};

struct marker_list {
    int marker_types_enabled;
    AFframecount left_cache[3];
    AFframecount right_cache[3];
    AFframecount last_request[3];
    double last_return[3];
    double slope[3];
    GList *markers;
};

struct marker_list **
marker_list_array_new();

void
marker_list_array_destroy(struct marker_list **mla);

void
marker_list_save(struct marker_list *ml,
                 const char *path,
                 int channel);

void
marker_list_load(struct marker_list *ml,
                 const char *path,
                 int channel);

void
marker_dump(struct marker *m);

void
marker_list_insert_list(struct marker_list *ml,
                        struct marker_list *ml_source,
                        AFframecount frame_offset,
                        AFframecount frame_count,
                        enum marker_type type);

void
marker_list_insert_time(struct marker_list *ml,
                        AFframecount frame_offset,
                        AFframecount frame_count,
                        enum marker_type type);

struct marker_list *
marker_list_delete_time(struct marker_list *ml,
                        AFframecount frame_offset,
                        AFframecount frame_count,
                        enum marker_type type);

double
marker_list_slope_value(struct marker_list *ml,
                        AFframecount frame_offset,
                        enum marker_type type);

void
marker_list_marker_delete(struct marker_list *ml,
                          struct marker *m);

void
marker_list_marker_position_set(struct marker_list *ml,
                                struct marker *m,
                                AFframecount frame_offset);

void
marker_list_invert(struct marker_list *ml,
                   AFframecount frame_offset,
                   AFframecount frame_count,
                   enum marker_type type);

void
marker_list_dump(struct marker_list *ml);

struct marker_list *
marker_list_delete(struct marker_list *ml,
                   AFframecount frame_offset,
                   AFframecount frame_count,
                   enum marker_type type);

struct marker *
marker_list_previous(struct marker_list *ml,
                     AFframecount frame_offset,
                     enum marker_type type);

struct marker *
marker_list_next(struct marker_list *ml,
                 AFframecount frame_offset,
                 enum marker_type type);

struct marker *
marker_list_insert(struct marker_list *ml,
                   AFframecount frame_offset,
                   enum marker_type type,
                   float multiplier,
                   const char *label);

struct marker_list *
marker_list_new();

struct marker_list *
marker_list_clone(struct marker_list *ml,
                  AFframecount frame_offset_start,
                  AFframecount frame_offset_end,
                  enum marker_type type);

void
marker_list_destroy(struct marker_list *ml);

#endif /* ! MARKER_H */

