#include "DBManagementMO.hh"
#include "../conn_pool/DBPooledConnection.hh"
#include "../conn_pool/DBPoolContainer.hh"
#include "../thread_pool/DBThreadPool.hh"
#include "../DBBalancer.hh"

DBManagementMO::DBManagementMO (DBBalancer *db, unsigned int delay, bool connTest, bool threadTest) {


  ACE_DEBUG((LM_TRACE,"(%t,%T) Constructed DBManagementMO\n"));
  _db = db;
  _delay = delay;
  _connTest = connTest;
  _threadTest = threadTest;
  _run = true;

}

DBManagementMO::~DBManagementMO() {

  ACE_DEBUG((LM_TRACE,"(%t,%T) Destroyed DBManagementMO\n"));

}

int DBManagementMO::call () {
  
  int result;

  // Let's give some time to startup connections.
  ACE_OS::sleep(5);

  // Check "_run" every time, in order to give DBBalancer more opportunities
  // to make the "shutdown" method actually effective, if needed.

  while (_run) {

    if (_run && _threadTest)
      result = checkThreads(_db->getPoolContainer()->getPoolNumber());
 
    if (_run && _connTest)
      checkConnections(result);

    if (_run)
      ACE_OS::sleep(_delay);

  }
  return 0;

}

void DBManagementMO::checkConnections(int threadGain) {


  // If we had changes in thread number (threadGain != 0) we also make changes to the db connection number.
  
  if (threadGain!=0)
    _db->getPoolContainer()->adjustConnections(threadGain);


  // Routine check to one of the connections.
  
  DBPooledConnection *dbpc = _db->getPoolContainer()->getPooledConnection(0,true);
  
  if (dbpc) {    
    //ACE_DEBUG((LM_TRACE,"(%D, %t) Conn test,  connection %s, delay %d\n",dbpc->getId().c_str(),_delay));
    dbpc->checkConnection();
    
  } else {
    ACE_DEBUG((LM_DEBUG,"(%D, %t) Conn test, NO connection to test.\n"));
  }
      


}


int DBManagementMO::checkThreads(unsigned int poolNumber) {

  return _db->getThreadPool()->reviewThreads(poolNumber);

}

void DBManagementMO::shutdown() {

  ACE_DEBUG((LM_TRACE,"(%t,%T) Shutting down DBManagementMO.\n"));
  _run = false;
  ACE_OS::sleep(_delay);

}
