<?php
/**
 * WindowMaker-like theme
 *
 * daCode http://www.dacode.org
 * src/phplib/html.php3
 * $Id: html.php3,v 1.45.2.11 2003/02/07 23:16:41 ruffy Exp $
 *
 *	All HTML design will be put here
 *
 *	header($title)	Return the header with $title as title.
 *	footer()		Return footer.
 *	newsbox($title, $news, $icon, $urls, footer)	Return the box.
 *
 * Depends: Config Redirect Utils User
 */
class Htmlwm extends Html {
	
	/**
	 * Session instance
	 *@var object Session
	 */
	var $session;

	/**
	 * Redirect instance
	 *@var object Redirect
	 */
	var $redirect;

	/**
	 * Hits instance
	 *@var object Hits
	 */
	var $hits;

	/**
	 * Fortune instance
	 *@var object Fortune
	 */
	var $fortune;

	/**
	 * Utils instance
	 *@var object Utils
	 */
	var $utils;

	/**
	 * Class constructor
	 */
	Function Htmlwm() {
		global $config;

		$this->utils = LoadClass('Utils',$config);
		$this->session = LoadClass('Session',$config);
		$this->hits = LoadClass('Hits',$config);
		$this->redirect = LoadClass('Redirect',$config);
		$this->fortune = LoadClass('Fortunes',$config);
	}


	/**
	 * Returns the HTML header 
	 *@param string title of the page
	 *@param boolean true if there shall be no banner on top of page
	 *@return string the HTML for the header (including doctype)
	 *@access public
	 */
	Function header($title,$nobanner=false) {
		global $config;

		$title = (empty($title)) ? $config->titledefault : $title;
		$tmp = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" '.
			'"http://www.w3.org/TR/REC-html40/loose.dtd">'."\n";
		$tmp .= "\n";
		$tmp .= "\n<html>\n<head>\n";
		$tmp .= '<!-- This page has been generated at the following time: '.
			date("d/m/Y H:j:s").' -->'."\n";
		$tmp .= '<title>'.$title.'</title>'."\n";
		$tmp .= '<link rel="stylesheet" type="text/css" href="'.
			$this->session->href_theme('wm.css').'" />'."\n";
		if (isset($config->favicon)) {
			$tmp .= '<link rel="icon" type="image/png" href="'.
			$this->session->imgurl($config->favicon).'" />'."\n";
		}
		$tmp .= '<meta http-equiv="Content-Type" content="text/html; '.
			'charset='.$config->encodingcharset.'" />'."\n";
		$tmp .= '</head>'."\n";
		$tmp .= '<body>'."\n";
		$tmp .= '<a name="top"></a>';
		$tmp .= '<div class="backtext">'."\n";

		if (!$nobanner) {
			$tmp .= '<div class="logoinfo"><div align="center">'.$this->simplebox(
				'<table width="100%" border="0" cellspacing="0" '.
				'cellpadding="0"><tr><td>'.
				$this->gtkbox('<table cellpadding="5"><tr><td><a href="'.
				$config->basehref.'"><img src="'.
				$this->session->imgurl($config->logo).
				'" border="0" alt="'.$config->titledefault.'" /></a></td>'.
				'</tr></table>','c7c7c7').
				'</td></tr></table>'."\n",''
			);
			if (isset($config->aboutlogo) && !empty($config->aboutlogo))
				$tmp .= $config->aboutlogo;
			$tmp .= '</div></div>'."\n";
		}
		return $tmp;
	}



	/**
	 * Returns the footer
	 *@param string text to add at the bottom of the page, if $nobanner is false
	 *@param boolean if true, do nbot print standard footer
	 *@return string the HTML for the footer
	 *@access public
	 */
	Function footer($text="",$nobanner=false) {
		$tmp = '';
		if (!$nobanner) {
			$out = '<table width="100%" border="0"><tr>';
			$out .= '<td class="newstext"><ul>';
			$out .= '<li>'.lecho("This website runs").
				' <a href="http://www.dacode.org/">';
			$out .= 'daCode</a></li>'."\n";
			$out .= '</ul></td>';

			$out .= '<td class="newstext" nowrap="nowrap">';
			$out .= $this->fortune->get_random();
			$out .= '</td></tr>';
			$out .= '</table>';
			$out .= $text;
			$tmp .= $this->simplebox($out);
		}
		$tmp .= "</div></body>\n</html>\n";
		return $tmp;
	}


	/**
	 * Return HTML code for side box with $text
	 *@param string title of the box
	 *@param string content of the box
	 *@param string name of the box (for HTML comment, not displayed)
	 *@return string the HTML for the box
	 *@access public
	 */
	Function sidebox($title,$text, $type="") {
		/* kludge, en attendant mieux */
		$title = preg_replace ("/(<[A-a].*>)(.*)<\/a>/",
			"\\1<font color=\"white\">\\2</font></a>", $title);
		$tmp = '<!-- SIDEBOX '.$type.' -->'."\n".
			$this->titlebar($title,"boxheader",0).
			'		<table width="100%" border="0" cellspacing="0" cellpadding="2" '.
			'bgcolor="#c7c7c7"><tr><td class="boxtext">'.$text.
			'</td></tr></table>'."\n".
			$this->bottombar().
			'		<!-- /SIDEBOX '.$type.' -->'."\n";
		return $tmp;
	}


	/**
	 * Return HTML code for simple box with $text
	 *@param string content of the box
	 *@param string the content of the HTML width attribute
	 *@return string the HTML for the box
	 *@access public
	 */
	Function simplebox($text, $width="100%") {
		$tmp = '<!-- SIMPLEBOX -->'."\n";
		$tmp .= '<table border="0" cellspacing="0" cellpadding="1" width="'.$width.
			'" bgcolor="#000000">'."\n".'<tbody>';
		$tmp .= '  <tr><td>'."\n";
		$tmp .= '   <table border="0" cellspacing="0" cellpadding="2" '.
			'width="100%" bgcolor="#c7c7c7">'."\n".'<tbody>';
		$tmp .= '   <tr><td class="newstext">'."\n";
		$tmp .= '   '.$text."\n";
		$tmp .= '   </td></tr>'."\n";
		$tmp .= '   </tbody></table>'."\n";
		$tmp .= '  </td></tr>'."\n";
		$tmp .= '</tbody></table><br />'."\n";
		$tmp .= '<!-- /SIMPLEBOX -->'."\n";
		return $tmp;
	}


	/**
	 * Return HTML code for news box with $row from news table
	 *@param array row from news table
	 *@param integer if 1, special mode for preview (?!)
	 *@return string the HTML for news box
	 *@access public
	 */
	Function newsbox($row,$preview=0) {
		global $section,$topic;
		global $config;

		// Title is referenced by a <a name>
		$text_of_title = (strlen($row['title'])>40) ? substr($row['title'],0,40).
			'...' : $row['title'];
		if (isset ($row['id'])) {
			$title = '<a name="n'.$row['id'].'"><span title="'.
				htmlentities($row['title']).'">'.
				((empty($row['title'])) ? htmlentities($config->newstitledefault) :
				htmlentities($text_of_title)).'</span></a>';
		} else {
			$title = '<span title="'.htmlentities($row['title']).'">'.
				((empty($row['title']))?htmlentities($config->newstitledefault):
				htmlentities($text_of_title)).'</span>';
		}

		$body = $this->linkto_topic($row['topic']);
		$body .= (empty($row['body'])) ? htmlentities($config->newsbodydefault) :
			(($row['content_type']=="text/plain") ?
			nl2br(htmlentities($row['body'])) : $row['body']);

		$row['section'] = (!isset($row['section'])) ?
			"nosection" : htmlentities($row['section']);
		$row['topic'] = (!isset($row['topic'])) ?
			"notopic" : htmlentities($row['topic']);

		// Let's do HTML code
		$tmp = ' <!-- NEWSBOX '.(isset($row['id'])?$row['id']:'').' -->'."\n";
		$tmp .= $this->titlebar($title, "newstitle", 1);
		$tmp .= '<table border="0" bgcolor="#c7c7c7" cellspacing="0" '.
			'cellpadding="3" width="100%"><tr><td bgcolor="#c7c7c7" '.
			'nowrap="nowrap" class="newsinfo">';

		$tmp .= $this->newsbox_posted_by($row,$preview);

		if (isset ($row['id'])) {
			$tmp .= '<!-- ADMINEDIT:'.$row['id'].' -->';
			if ($this->session->checked && ($this->session->level&pow(2,21))) {
				$tmp .= ' - <b><a href="'.$config->basehref.$config->adminfile.
					'?action=edit_news&amp;news_id='.$row['id'].'">'.
					lecho("Edit!").'</a></b>';
			}
			$tmp .= '<!-- /ADMINEDIT -->';
		}

		if (!empty($departement)) {
			$tmp .= '<br />'."\n".ucfirst(lecho("dept")).': <b>'.$departement.'</b>';
		}
		$tmp .= "\n      </td>\n     </tr>\n".'     <tr bgcolor="#c7c7c7">'."\n";
		$tmp .= '<td class="newstext">';
		$links = $this->newsbox_show_links($row,$preview);
		$tmp .= $this->gtkbox($body.$links, "ffffff");
		$tmp .= '</td></tr>';
		if (isset ($row['id'])) {
			$tmp .= '<tr><td class="newstext">'."\n";
			ereg("^([0-9]{4})([0-9]{2})([0-9]{2})", $row['timestamp'], $regs);
			$count = $this->newsbox_count_comments(
				$row,$row['section'],$row['topic'],$regs[1],$regs[2],$regs[3]).'&nbsp;&nbsp;';
			$tmp .= $this->gtkbox($count.
				$this->newsbox_show_attachments($row), "c7c7c7");
			$tmp .= '</td></tr>';
		}
		$tmp .= '</table>';
		$tmp .= $this->bottombar();
		$tmp .= '<!-- /NEWSBOX -->'."\n";
		return $tmp;
	}


	/**
	 * Function to print comment top banner
	 *@param integer the score threshold
	 *@param integer the type of resource
	 *@return string the HTML code
	 *@access public
	 */
	Function commentbanner ($score, $res_type) {
		global $config,$news;
		global $section,$topic;
		global $HTTP_GET_VARS,$news_id,$HTTP_SERVER_VARS;

		// Get information to get timestamp + news
		$this->comments = LoadClass('Comments');
		$path = ereg_replace('^/'.$config->htmldir, '/',
			$HTTP_SERVER_VARS['PATH_INFO']);
		if (ereg("^(.*)\\.(html|$config->php)", $path, $res)) {
			$path = $res[1];
		}
		if (ereg('^([^,]*)(,.+)$', $path, $res)) {
			$path = $res[1];
		}
		if (ereg("^/([0-9]{4})/([0-9]{2})/([0-9]{2})/([0-9]+)$", $path, $res)) {
			$year = $res[1];
			$month= $res[2];
			$day  = $res[3];
		} else {
			$ts = $this->utils->gettimestampnews($news_id);
			$year = $ts[0];
			$month= $ts[1];
			$day  = $ts[2];
		}

		if (isset($HTTP_GET_VARS['score'])) {
			$score = $HTTP_GET_VARS['score'];
		}
		$out = '<a name="banner" href="'.
			$this->session->newsurls($news_id,'','',$year,$month,$day,$score).
			'"><font color="#ffffff">'."\n";
		if (is_object($news)) {
			$out .= $news->show_title($news_id);
		}
		$out .= '</font></a> | ';
		if (!$this->session->checked) {
			$out .= '<a href="'.$config->basehref.
				'users/?a=na"><font color="#ffffff">'.lecho("New Account").
				'</font></a> | ';
		}
		$out .= '<b>';
		$counttmp = $this->comments->count_comments($news_id, $res_type);
		$out .= $counttmp . '</b> ';
		if ($counttmp <= 1) {
			$out .= lecho("comment")."\n";
		} else {
			$out .= lecho("comments")."\n";
		}

		$out = $this->titlebar($out, "boxheader", 0);
		$out .= '<table width="100%" bgcolor="#c7c7c7" border="0" '.
			'cellpadding="2" cellspacing="0">';
		$out .= '</td></tr>'."\n";
		$out .= '<tr><td class="commentboxmiddle">'."\n";
		$out .= '<form method="post" action="'.$config->basehref.
			$config->commaddfile.'">'."\n";
		$out .= '<input type="hidden" name="news_id" value="'.$news_id.'" />'."\n";
		$out .= '<input type="hidden" name="year" value="'.$year.'" />'."\n";
		$out .= '<input type="hidden" name="month" value="'.$month.'" />'."\n";
		$out .= '<input type="hidden" name="day" value="'.$day.'" />'."\n";
		$out .= '<input type="hidden" name="res_type" value="'.$res_type.'" />'.
			"\n";

		$out .= '<input type="hidden" name="section" value="';
		$out .= !empty($section) ? $section : "0";
		$out .= '" />'."\n";

		$out .= '<input type="hidden" name="topic" value="';
		$out .= !empty($topic) ? $topic : "0";
		$out .= '" />'."\n";

		$out .= lecho("Hide signatures").
			': <input type="checkbox" name="hide_sig"';
		if ($config->hide_sig == "1") {
			$out .= ' checked="checked"';
		}
		$out .= ' />'."\n";

		$out .= lecho("Score").': <select name="score">'."\n";
		$score_comment = (array) $this->comments->count_comments_array($news_id,
			$res_type);

		if ($config->moderation_type == 1) {
			for ($i=-1;$i<6;$i++) {
				$counttmp = $score_comment['n'.$news_id]['s'.$i];
				$out .= '<option value="'.$i.'"';

				if ($i == $score || (!isset($score) && $this->session->score == $i)) {
					$out .= ' selected="selected"';
				}

				$out .= '>'.$i.': '.$counttmp.' ';
				if ($counttmp <= 1) {
					$out .= lecho("comment")."\n";
				} else {
					$out .= lecho("comments")."\n";
				}
				$out .= '</option>';
			}
		} else {
			$ok_tmp = 0;
			for ($i=-1;$i<6;$i++) {
				$counttmp = $score_comment['n'.$news_id]['s'.$i];

				$out .= '<option value="'.$i.'"';
				if ($i == $config->oldscore ||
					(!isset($config->oldscore) && $this->session->score == $i)) {
					$out .= ' selected="selected"';
				}

				switch ($i) {
					case "-1":
						$out .= ">".lecho("all");
						break;
					case 0:
						$out .= ">0";
						break;
					case 1:
						$out .= ">".$config->last_week_score;
						break;
					case 2:
						$out .= ">".(2*$config->last_week_score);
						break;
					case 3:
						$out .= ">".(3*$config->last_week_score);
						break;
					case 4:
						$out .= ">".(4*$config->last_week_score);
						break;
					case 5:
						$out .= ">".(5*$config->last_week_score);
						break;
				}

				$out .= ': '.$counttmp.' ';
				if ($counttmp <= 1) {
					$out .= lecho("comment")."\n";
				} else {
					$out .= lecho("comments")."\n";
				}
				$out .= '</option>';
			}
		}

		$out .= '</select>';
		$out .= '<input type="submit" name="op"'.
			' value="'.lecho("Change").'" />'."\n";
		$out .= '<input type="submit" name="op"'.
			' value="'.lecho("Reply").'" />'."\n</form></td></tr>\n";
		$out .= '<tr><td class="commentbox">'."\n";
		$out .= lecho("<b>The fine print</b>: The following comments are owned by whoever posted them.").' ';
		$out .= lecho("We are not responsible for what they say.")."\n";
		$out .= '</td></tr></table>'."\n";
		$out .= $this->bottombar();

		return $out;
	}

	/**
	 * Creates the HTML for the title
	 *@param string the text of the title
	 *@param string the name of the CSS class used for title
	 *@param boolean TODO
	 *@todo fix  $buttons
	 *@return string the HTML for the title
	 *@access private
	 */
	Function titlebar ($title, $style, $buttons) {
		return '<table width="100%" border="0" cellpadding="0" cellspacing="0">'.
			'<tr><td width="'.($buttons?"10":"2").'"><img border="0" '.
			' src="'.
			($buttons?$this->session->imgurl('tw'):$this->session->imgurl('ttw')).
			'" alt="(( " /></td>'.
			'<td width="100%" bgcolor="#000000" background="'.
			$this->session->imgurl('t').
			'" class="'.$style.'">&nbsp;'.$title.'&nbsp;</td>'.
			'<td width="'.($buttons?"10":"2").'" align="right"><img border="0" '.
			' src="'.
			($buttons?$this->session->imgurl('te'):$this->session->imgurl('tte')).
			'" alt=" ))" /></td></tr></table>'."\n".
			'<table border="0" cellspacing="0" cellpadding="1" width="100%" '.
			'bgcolor="#000000"><tr><td valign="bottom">';
	}


	/**
	 * Creates the bottom bar of a news box
	 *@return string the HTML
	 */
	Function bottombar () {
		return '<table border="0" cellspacing="0" cellpadding="0">'.
			'<tr><td valign="top"><img border="0" '.
			' src="'.$this->session->imgurl('tsw').'" alt="" /></td>'.
			'<td valign="middle" background="'.$this->session->imgurl('ts').
			'" width="100%"> </td><td width="10"'.
			' align="right" valign="top"><img border="0" '.
			' src="'.$this->session->imgurl('tse').'" alt="" /></td></tr>'."\n".
			'</table>'.
			"</td>\n  </tr>\n".
			" </table>\n <br />\n";
	}

	/**
	 * What is it???
	 *@todo description
	 *@param string content of the box
	 *@param string bgcolor of the box
	 *@return string HTML code
	 *@access private
	 */
	Function gtkbox ($content, $color) {
		$tmp = '<table border="0" width="100%" cellspacing="0" cellpadding="0">'.
			"\n".
			'<tr><td width="2" background="'.$this->session->imgurl('n').
			'"><img border="0" src="'.$this->session->imgurl('nw').
			'" height="2" width="2" alt="" /></td>'.
			'<td width="100%" background="'.$this->session->imgurl('n').
			'"><img src="'.$this->session->imgurl('n').
			'" height="2" alt="" /></td>'.
			'<td width="2" background="'.$this->session->imgurl('n').
			'"><img border="0" src="'.$this->session->imgurl('ne').
			'" width="2" height="2" alt="" /></td>'.
			'</tr>'."\n";

		$tmp .= '<tr><td width="2" background="'.
			$this->session->imgurl('w-'.$color).
			'"><img src="'.$this->session->imgurl('w-'.$color).
			'" alt="" /></td>';
		$tmp .= '<td width="100%" class="newstext" bgcolor="#'.$color.'">';
		$tmp .= $content;
		$tmp .= '</td><td width="2" background="'.
			$this->session->imgurl('e-'.$color).
			'"><img src="'.$this->session->imgurl('e-'.$color).
			'" height="2" width="2" alt="" /></td>';
		$tmp .= '</tr><tr>';
		$tmp .= '<td width="2" background="'.$this->session->imgurl('s').
			'"><img border="0" src="'.$this->session->imgurl('sw').
			'" alt="" /></td>';
		$tmp .= '<td width="100%" background="'.$this->session->imgurl('s').
			'"><img src="'.$this->session->imgurl('s').
			'" height="2" alt="" /></td>';
		$tmp .= '<td width="2" background="'.$this->session->imgurl('s').
			'"><img border="0" src="'.$this->session->imgurl('se').
			'" height="2" width="2" alt="" /></td>';
		$tmp .= '</tr></table>'."\n";

		return $tmp;
	}

}
