/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999-2000 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

#include <string.h>
#include "table.h"

void gbchar_big5char(char *gb, char *big5)
{
	int i;

	for(i=0; i<TABLENUM; i++){
		if(gb[0] == hc_g2b[i].gb[0] &&
		   gb[1] == hc_g2b[i].gb[1]) {
			big5[0] = hc_g2b[i].big5[0];
			big5[1] = hc_g2b[i].big5[1];
			return;
		}
	}

	strcpy(big5, "");	//0xA1BC

}

void big5char_gbchar(char *big5, char *gb)
{
        int i;

        for(i=0; i<TABLENUM; i++){
                if(big5[0] == hc_g2b[i].big5[0] &&
                   big5[1] == hc_g2b[i].big5[1]) {
                        gb[0] = hc_g2b[i].gb[0];
                        gb[1] = hc_g2b[i].gb[1];
                        return;
                }
        }

        strcpy(gb, "");
}


void gbstring_big5string(char *gbstr, char *big5str, int n)
{
	int i;
	char b5[3];

	strcpy(big5str, "");

	if(!gbstr) return;

	for(i=0; i<n/2; i++){
		gbchar_big5char(gbstr+i*2, b5);
		strncat(big5str, b5, 2);
	}
}

void gbmixstring_big5mixstring(char *gbmixstr, char *big5mixstr, int n)
{
	int i;
	char b5[3];
	strcpy(big5mixstr, "");
	if(!gbmixstr) return;

	for(i=0; i<n; i++){
		if(gbmixstr[i] & 0x80){
			gbchar_big5char(gbmixstr+i, b5);
			strncat(big5mixstr, b5, 2);
			i++;
		} else {
			big5mixstr[i] = gbmixstr[i];
			big5mixstr[i+1] = '\0';
		}
	}
}

void big5string_gbstring(char *big5str, char *gbstr, int n)
{
        int i;
        char gb[3];

        strcpy(gbstr, "");

        if(!big5str) return;

        for(i=0; i<n/2; i++){
                big5char_gbchar(big5str+i*2, gb);
                strncat(gbstr, gb, 2);
        }
}


void big5mixstring_gbmixstring(char *big5mixstr, char *gbmixstr, int n)
{
	int i;
	char gb[3];
	strcpy(gbmixstr, "");
	if(!big5mixstr) return;

	for(i=0; i<n; i++){
		if(big5mixstr[i] & 0x80){
			big5char_gbchar(big5mixstr+i, gb);
			strncat(gbmixstr, gb, 2);
			i++;
		} else {
			gbmixstr[i] = big5mixstr[i];
			gbmixstr[i+1] = '\0';
		}
	}
}

