-- $Id: quest.lua,v 1.17 2003/01/10 22:22:29 tharibo Exp $
-- Arkhart RPG - An Ark-based roleplaying game.
-- Copyright (C) 2001 The Contributors of the Arkhart Project
-- Please see the file "AUTHORS" for a list of contributors
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

pnj0 = {}

function pnj0.on_create (self)
   ark.log ("Creating pnj0 \n");
   self:add_timer (1, 2.0);
end;

function pnj0.on_timer (self, id)
   self:add_timer (id, 1.0);

   if (self.entitygoal == nil) then
      self:set_no_goal();
   else
      self:set_entity_goal (self.entitygoal);
   end
end;

-- Function called when the player hits the pnj0
function pnj0.on_tell (self, ent, msg)
  ark.log (self:get_name() .. " was told " .. msg);

  if msg == "MOUSEHIT" then	-- First hit
    self.entitygoal = ent;
    self:add_message (ent,
	      "Salut ".. ent:get_name() .. ", je suis Lununullu. "..
		 "Veux-tu que je te suives ?",
	      {"1_OUI|Oui", "1_NON|Non", "2_TEST|Test"});

  elseif msg == "1_NON" then	-- The player said "Non"
    self:add_message (ent, "Vilain petit bachi-bouzouk, moule a gaufre, "..
		      "va voir ailleurs si j'y suis !", {"2_CIAO|Ciao !"});
    self.entitygoal = nil;

  elseif msg == "2_TEST" then	-- The player said "Test"
    self:add_message (ent, "Ok, je vais tester tes trucs, mais  mon " .. 
    		      "avis c'est pas gagn", {"Cool, merci..."});
    self.entitygoal = nil;

    -- Testons dans la joie...
    position = self:get_position();
    visibility_box_start = {	x = position.x - 5,
  				y = position.y - 5,
				z = position.z - 5 };
    visibility_box_end = {	x = position.x + 5,
  				y = position.y + 5,
				z = position.z + 5 };
    visibility_box = {visibility_box_start, visibility_box_end};

    visible_entities = ark.world:test_collision_with_entities( visibility_box );

    -- Display the result
    if visible_entities ~= nil then
      ark.log("Je vois des gens ! ;-)");
    else
      ark.log("Beuheuheuuu... je vois personne... :,(");
    end
    
  end

  return 1;
end

cauldron = {}

function cauldron.on_create (self)
   ark.log ("Creating cauldron '" .. self:get_name() .. "'");
   self:psys_set (0,
		  "(0.0,-.80,.10)(0.0,0.0,1.0)(.2)",
		  "(G,G,G)(R,G,G)",
		  "(150, {particles}/smoke.akp");
end;
