/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common.serialization;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.AbstractApiMessageSerde;

public abstract class BytesApiMessageSerde {
    private final AbstractApiMessageSerde apiMessageSerde = new AbstractApiMessageSerde(){

        @Override
        public ApiMessage apiMessageFor(short apiKey) {
            return BytesApiMessageSerde.this.apiMessageFor(apiKey);
        }
    };

    public byte[] serialize(ApiMessageAndVersion messageAndVersion) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int size = this.apiMessageSerde.recordSize(messageAndVersion, cache);
        ByteBufferAccessor writable = new ByteBufferAccessor(ByteBuffer.allocate(size));
        this.apiMessageSerde.write(messageAndVersion, cache, (Writable)writable);
        return writable.buffer().array();
    }

    public ApiMessageAndVersion deserialize(byte[] data) {
        ByteBufferAccessor readable = new ByteBufferAccessor(ByteBuffer.wrap(data));
        return this.apiMessageSerde.read((Readable)readable, data.length);
    }

    public abstract ApiMessage apiMessageFor(short var1);
}

