/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal.install;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Predicate;
import org.gradle.internal.jvm.inspection.JavaInstallationCapability;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.gradle.jvm.toolchain.internal.DefaultJvmVendorSpec;

public class JvmInstallationMetadataMatcher
implements Predicate<JvmInstallationMetadata> {
    private final JavaLanguageVersion languageVersion;
    private final DefaultJvmVendorSpec vendorSpec;
    private final JvmImplementation jvmImplementation;
    private final Set<JavaInstallationCapability> requiredCapabilities;

    public JvmInstallationMetadataMatcher(JavaLanguageVersion languageVersion, JvmVendorSpec vendorSpec, JvmImplementation jvmImplementation, Set<JavaInstallationCapability> requiredCapabilities) {
        this.languageVersion = languageVersion;
        this.vendorSpec = (DefaultJvmVendorSpec)vendorSpec;
        this.jvmImplementation = jvmImplementation;
        this.requiredCapabilities = ImmutableSet.copyOf(requiredCapabilities);
    }

    public JvmInstallationMetadataMatcher(JavaToolchainSpec spec, Set<JavaInstallationCapability> requiredCapabilities) {
        this((JavaLanguageVersion)spec.getLanguageVersion().get(), (JvmVendorSpec)spec.getVendor().get(), (JvmImplementation)spec.getImplementation().get(), requiredCapabilities);
    }

    @Override
    public boolean test(JvmInstallationMetadata metadata) {
        return this.hasMatchingMajorVersion(metadata) && this.vendorSpec.test(metadata) && this.hasRequiredCapabilities(metadata) && this.hasMatchingImplementation(metadata);
    }

    private boolean hasMatchingMajorVersion(JvmInstallationMetadata metadata) {
        JavaLanguageVersion actualVersion = JavaLanguageVersion.of((int)metadata.getJavaMajorVersion());
        return actualVersion.equals(this.languageVersion);
    }

    private boolean hasRequiredCapabilities(JvmInstallationMetadata metadata) {
        return metadata.getCapabilities().containsAll(this.requiredCapabilities);
    }

    private boolean hasMatchingImplementation(JvmInstallationMetadata metadata) {
        if (this.jvmImplementation == JvmImplementation.VENDOR_SPECIFIC) {
            return true;
        }
        boolean j9Requested = this.isJ9ExplicitlyRequested() || this.isJ9RequestedViaVendor();
        boolean isJ9Vm = metadata.getCapabilities().contains(JavaInstallationCapability.J9_VIRTUAL_MACHINE);
        return j9Requested == isJ9Vm;
    }

    private boolean isJ9ExplicitlyRequested() {
        return this.jvmImplementation == JvmImplementation.J9;
    }

    private boolean isJ9RequestedViaVendor() {
        return this.vendorSpec != DefaultJvmVendorSpec.any() && this.vendorSpec.test(JvmVendor.KnownJvmVendor.IBM.asJvmVendor());
    }
}

