/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Collection;
import java.util.Collections;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.EngineDiscoveryOrchestrator;
import org.junit.platform.launcher.core.EngineExecutionOrchestrator;
import org.junit.platform.launcher.core.InternalTestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.junit.platform.launcher.core.LauncherListenerRegistry;

class DefaultLauncher
implements Launcher {
    private final LauncherListenerRegistry listenerRegistry = new LauncherListenerRegistry();
    private final EngineExecutionOrchestrator executionOrchestrator;
    private final EngineDiscoveryOrchestrator discoveryOrchestrator;

    DefaultLauncher(Iterable<TestEngine> testEngines, Collection<PostDiscoveryFilter> postDiscoveryFilters) {
        this.executionOrchestrator = new EngineExecutionOrchestrator(this.listenerRegistry.testExecutionListeners);
        Preconditions.condition((testEngines != null && testEngines.iterator().hasNext() ? 1 : 0) != 0, () -> "Cannot create Launcher without at least one TestEngine; consider adding an engine implementation JAR to the classpath");
        Preconditions.notNull(postDiscoveryFilters, (String)"PostDiscoveryFilter array must not be null");
        Preconditions.containsNoNullElements(postDiscoveryFilters, (String)"PostDiscoveryFilter array must not contain null elements");
        this.discoveryOrchestrator = new EngineDiscoveryOrchestrator(testEngines, Collections.unmodifiableCollection(postDiscoveryFilters), this.listenerRegistry.launcherDiscoveryListeners);
    }

    @Override
    public void registerLauncherDiscoveryListeners(LauncherDiscoveryListener ... listeners) {
        this.listenerRegistry.launcherDiscoveryListeners.addAll((LauncherDiscoveryListener[])listeners);
    }

    @Override
    public void registerTestExecutionListeners(TestExecutionListener ... listeners) {
        this.listenerRegistry.testExecutionListeners.addAll((TestExecutionListener[])listeners);
    }

    @Override
    public TestPlan discover(LauncherDiscoveryRequest discoveryRequest) {
        Preconditions.notNull((Object)discoveryRequest, (String)"LauncherDiscoveryRequest must not be null");
        return InternalTestPlan.from(this.discover(discoveryRequest, EngineDiscoveryOrchestrator.Phase.DISCOVERY));
    }

    @Override
    public void execute(LauncherDiscoveryRequest discoveryRequest, TestExecutionListener ... listeners) {
        Preconditions.notNull((Object)discoveryRequest, (String)"LauncherDiscoveryRequest must not be null");
        Preconditions.notNull((Object)listeners, (String)"TestExecutionListener array must not be null");
        Preconditions.containsNoNullElements((Object[])listeners, (String)"individual listeners must not be null");
        this.execute(InternalTestPlan.from(this.discover(discoveryRequest, EngineDiscoveryOrchestrator.Phase.EXECUTION)), listeners);
    }

    @Override
    public void execute(TestPlan testPlan, TestExecutionListener ... listeners) {
        Preconditions.notNull((Object)testPlan, (String)"TestPlan must not be null");
        Preconditions.condition((boolean)(testPlan instanceof InternalTestPlan), (String)"TestPlan was not returned by this Launcher");
        Preconditions.notNull((Object)listeners, (String)"TestExecutionListener array must not be null");
        Preconditions.containsNoNullElements((Object[])listeners, (String)"individual listeners must not be null");
        this.execute((InternalTestPlan)testPlan, listeners);
    }

    private LauncherDiscoveryResult discover(LauncherDiscoveryRequest discoveryRequest, EngineDiscoveryOrchestrator.Phase phase) {
        return this.discoveryOrchestrator.discover(discoveryRequest, phase);
    }

    private void execute(InternalTestPlan internalTestPlan, TestExecutionListener[] listeners) {
        this.executionOrchestrator.execute(internalTestPlan, listeners);
    }
}

