/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.io;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class ListHashTable<K, V> {
    private final Map<K, List<V>> table = new Hashtable<K, List<V>>();

    public void add(K tag, V element) {
        List<V> elementsForTag = this.table.get(tag);
        if (elementsForTag == null) {
            elementsForTag = new LinkedList<V>();
            this.table.put(tag, elementsForTag);
        }
        elementsForTag.add(element);
    }

    public boolean isEmpty(K tag) {
        List<V> elementsForTag = this.list(tag);
        if (elementsForTag == null) {
            return true;
        }
        return elementsForTag.isEmpty();
    }

    public Iterator<V> iterator(K tag) {
        List<V> elementsForTag = this.list(tag);
        if (elementsForTag == null) {
            return new EmptyIterator();
        }
        return elementsForTag.listIterator();
    }

    public List<V> list(K tag) {
        return this.table.get(tag);
    }

    public boolean remove(K tag, V element) {
        List<V> elementsForTag = this.list(tag);
        if (elementsForTag == null) {
            return false;
        }
        return elementsForTag.remove(element);
    }

    private static class EmptyIterator<V>
    implements Iterator<V> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public V next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

