/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.UnknownServiceException;
import java.security.Permission;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.NbfsUtil;

final class FileURL
extends URLConnection {
    public static final String PROTOCOL = "nbfs";
    static URLStreamHandler HANDLER = new URLStreamHandler(){

        public URLConnection openConnection(URL uRL) throws IOException {
            return new FileURL(uRL);
        }

        protected synchronized InetAddress getHostAddress(URL uRL) {
            return null;
        }
    };
    InputStream iStream = null;
    OutputStream oStream = null;
    private FileObject fo;

    private FileURL(URL uRL) {
        super(uRL);
    }

    public static URL encodeFileObject(FileObject fileObject) throws FileStateInvalidException {
        return NbfsUtil.getURL(fileObject);
    }

    public static FileObject decodeURL(URL uRL) {
        return NbfsUtil.getFileObject(uRL);
    }

    public void connect() throws IOException {
        if (this.fo != null) {
            return;
        }
        this.fo = FileURL.decodeURL(this.url);
        if (this.fo == null) {
            throw new FileNotFoundException("Cannot find: " + this.url);
        }
    }

    public InputStream getInputStream() throws IOException, UnknownServiceException {
        this.connect();
        if (this.iStream == null) {
            try {
                this.iStream = this.fo.isFolder() ? new FIS(this.fo) : this.fo.getInputStream();
            }
            catch (FileNotFoundException fileNotFoundException) {
                ExternalUtil.exception(fileNotFoundException);
                throw fileNotFoundException;
            }
        }
        return this.iStream;
    }

    public OutputStream getOutputStream() throws IOException, UnknownServiceException {
        this.connect();
        if (this.fo.isFolder()) {
            throw new UnknownServiceException();
        }
        if (this.oStream == null) {
            FileLock fileLock = this.fo.lock();
            this.oStream = new LockOS(this.fo.getOutputStream(fileLock), fileLock);
        }
        return this.oStream;
    }

    public int getContentLength() {
        try {
            this.connect();
            return (int)this.fo.getSize();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public String getHeaderField(String string) {
        if (string.equalsIgnoreCase("content-type")) {
            try {
                this.connect();
                if (this.fo.isFolder()) {
                    return "text/html";
                }
                return this.fo.getMIMEType();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getHeaderField(string);
    }

    public Permission getPermission() throws IOException {
        if (this.fo != null) {
            File file = FileUtil.toFile(this.fo);
            if (file != null) {
                return new FilePermission(file.getAbsolutePath(), "read");
            }
            try {
                FileSystem fileSystem = this.fo.getFileSystem();
                if (fileSystem instanceof JarFileSystem) {
                    return new FilePermission(((JarFileSystem)fileSystem).getJarFile().getAbsolutePath(), "read");
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return new FilePermission("<<ALL FILES>>", "read");
    }

    private static final class FIS
    extends InputStream {
        private StringReader reader;

        public FIS(FileObject fileObject) throws IOException {
            this.reader = new StringReader(this.createDocument(fileObject));
        }

        private String createDocument(FileObject fileObject) throws IOException {
            StringBuffer stringBuffer = new StringBuffer(150);
            StringBuffer stringBuffer2 = new StringBuffer(15);
            FileObject[] fileObjectArray = fileObject.getChildren();
            stringBuffer.append("<HTML>\n");
            stringBuffer.append("<BODY>\n");
            FileObject fileObject2 = fileObject.getParent();
            if (fileObject2 != null) {
                stringBuffer.append("<P>");
                stringBuffer.append("<A HREF=").append("..").append(">").append("..").append("</A>").append("\n");
                stringBuffer.append("</P>");
            }
            for (int i = 0; i < fileObjectArray.length; ++i) {
                stringBuffer2.setLength(0);
                stringBuffer2.append(fileObjectArray[i].getNameExt());
                String string = stringBuffer2.toString();
                if (fileObjectArray[i].isFolder()) {
                    stringBuffer2.append('/');
                }
                stringBuffer.append("<P>");
                stringBuffer.append("<A HREF=").append((Object)stringBuffer2).append(">").append(string).append("</A>").append("\n");
                stringBuffer.append("</P>");
            }
            stringBuffer.append("</BODY>\n");
            stringBuffer.append("</HTML>\n");
            return stringBuffer.toString();
        }

        public int read() throws IOException {
            return this.reader.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            char[] cArray = new char[n2];
            int n3 = this.reader.read(cArray, 0, n2);
            for (int i = 0; i < n3; ++i) {
                byArray[n + i] = (byte)cArray[i];
            }
            return n3;
        }

        public long skip(long l) throws IOException {
            return this.reader.skip(l);
        }

        public void close() throws IOException {
            this.reader.close();
        }

        public void reset() throws IOException {
            this.reader.reset();
        }

        public boolean markSupported() {
            return false;
        }
    }

    private static class LockOS
    extends BufferedOutputStream {
        private FileLock flock;

        public LockOS(OutputStream outputStream, FileLock fileLock) throws IOException {
            super(outputStream);
            this.flock = fileLock;
        }

        public void close() throws IOException {
            this.flock.releaseLock();
            super.close();
        }
    }
}

