/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * clamp(i64vec4(-20l, -20l, -20l, -20l), i64vec4(-15l, -15l, -15l, 0l), i64vec4(-15l, 0l, 15l, 0l)) => i64vec4(-15l, -15l, -15l, 0l)
 * clamp(i64vec4(-20l, -20l, -6l, -6l), i64vec4(0l, 15l, -15l, -15l), i64vec4(15l, 15l, -15l, 0l)) => i64vec4(0l, 15l, -15l, -6l)
 * clamp(i64vec4(-6l, -6l, -6l, -6l), i64vec4(-15l, 0l, 0l, 15l), i64vec4(15l, 0l, 15l, 15l)) => i64vec4(-6l, 0l, 0l, 15l)
 * clamp(i64vec4(6l, 6l, 6l, 6l), i64vec4(-15l, -15l, -15l, 0l), i64vec4(-15l, 0l, 15l, 0l)) => i64vec4(-15l, 0l, 6l, 0l)
 * clamp(i64vec4(6l, 6l, 20l, 20l), i64vec4(0l, 15l, -15l, -15l), i64vec4(15l, 15l, -15l, 0l)) => i64vec4(6l, 15l, -15l, 0l)
 * clamp(i64vec4(20l, 20l, 20l, 20l), i64vec4(-15l, 0l, 0l, 15l), i64vec4(15l, 0l, 15l, 15l)) => i64vec4(15l, 0l, 15l, 15l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal(clamp(i64vec4(-20l, -20l, -20l, -20l), i64vec4(-15l, -15l, -15l, 0l), i64vec4(-15l, 0l, 15l, 0l)), i64vec4(-15l, -15l, -15l, 0l))) ? 1 : -1] array0;
  float[all(equal(clamp(i64vec4(-20l, -20l, -6l, -6l), i64vec4(0l, 15l, -15l, -15l), i64vec4(15l, 15l, -15l, 0l)), i64vec4(0l, 15l, -15l, -6l))) ? 1 : -1] array1;
  float[all(equal(clamp(i64vec4(-6l, -6l, -6l, -6l), i64vec4(-15l, 0l, 0l, 15l), i64vec4(15l, 0l, 15l, 15l)), i64vec4(-6l, 0l, 0l, 15l))) ? 1 : -1] array2;
  float[all(equal(clamp(i64vec4(6l, 6l, 6l, 6l), i64vec4(-15l, -15l, -15l, 0l), i64vec4(-15l, 0l, 15l, 0l)), i64vec4(-15l, 0l, 6l, 0l))) ? 1 : -1] array3;
  float[all(equal(clamp(i64vec4(6l, 6l, 20l, 20l), i64vec4(0l, 15l, -15l, -15l), i64vec4(15l, 15l, -15l, 0l)), i64vec4(6l, 15l, -15l, 0l))) ? 1 : -1] array4;
  float[all(equal(clamp(i64vec4(20l, 20l, 20l, 20l), i64vec4(-15l, 0l, 0l, 15l), i64vec4(15l, 0l, 15l, 15l)), i64vec4(15l, 0l, 15l, 15l))) ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
