/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.openal;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.openal.AL10;
import org.lwjgl.opengl.Display;
import org.lwjgl.test.openal.BasicTest;
import org.lwjgl.util.WaveData;
import org.lwjgl.util.vector.Vector3f;

public class MovingSoundTest
extends BasicTest {
    public static float MOVEMENT = 50.0f;

    protected void execute(String[] args) {
        if (args.length < 1) {
            System.out.println("no argument supplied, assuming Footsteps.wav");
            args = new String[]{"Footsteps.wav"};
        }
        try {
            this.setDisplayMode();
            Display.create();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Vector3f sourcePosition = new Vector3f();
        Vector3f listenerPosition = new Vector3f();
        try {
            Keyboard.create();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exit(-1);
        }
        IntBuffer buffers = BufferUtils.createIntBuffer((int)1);
        IntBuffer sources = BufferUtils.createIntBuffer((int)1);
        buffers.position(0).limit(1);
        AL10.alGenBuffers((IntBuffer)buffers);
        int lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        sources.position(0).limit(1);
        AL10.alGenSources((IntBuffer)sources);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        WaveData wavefile = WaveData.create((String)args[0]);
        AL10.alBufferData((int)buffers.get(0), (int)wavefile.format, (ByteBuffer)wavefile.data, (int)wavefile.samplerate);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        wavefile.dispose();
        AL10.alSourcei((int)sources.get(0), (int)4105, (int)buffers.get(0));
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL10.alSourcef((int)sources.get(0), (int)4128, (float)1024.0f);
        AL10.alSourcef((int)sources.get(0), (int)4129, (float)0.5f);
        AL10.alSourcei((int)sources.get(0), (int)4103, (int)1);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL10.alSourcePlay((int)sources.get(0));
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        System.out.println("Move source with arrow keys\nMove listener with right shift and arrowkeys\nExit with ESC");
        while (!Keyboard.isKeyDown((int)1)) {
            Display.update();
            Keyboard.poll();
            if (Keyboard.isKeyDown((int)203)) {
                if (Keyboard.isKeyDown((int)54)) {
                    listenerPosition.x -= MOVEMENT;
                    AL10.alListener3f((int)4100, (float)listenerPosition.x, (float)listenerPosition.y, (float)listenerPosition.z);
                    System.out.println("listenerx: " + listenerPosition.x);
                } else {
                    sourcePosition.x -= MOVEMENT;
                    AL10.alSource3f((int)sources.get(0), (int)4100, (float)sourcePosition.x, (float)sourcePosition.y, (float)sourcePosition.z);
                    System.out.println("sourcex: " + sourcePosition.x);
                }
            }
            if (Keyboard.isKeyDown((int)205)) {
                if (Keyboard.isKeyDown((int)54)) {
                    listenerPosition.x += MOVEMENT;
                    AL10.alListener3f((int)4100, (float)listenerPosition.x, (float)listenerPosition.y, (float)listenerPosition.z);
                    System.out.println("listenerx: " + listenerPosition.x);
                } else {
                    sourcePosition.x += MOVEMENT;
                    AL10.alSource3f((int)sources.get(0), (int)4100, (float)sourcePosition.x, (float)sourcePosition.y, (float)sourcePosition.z);
                    System.out.println("sourcex: " + sourcePosition.x);
                }
            }
            if (Display.isCloseRequested()) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        AL10.alSourceStop((int)sources.get(0));
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        sources.position(0).limit(1);
        AL10.alDeleteSources((IntBuffer)sources);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        buffers.position(0).limit(1);
        AL10.alDeleteBuffers((IntBuffer)buffers);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        this.alExit();
    }

    public static void main(String[] args) {
        MovingSoundTest movingSoundTest = new MovingSoundTest();
        movingSoundTest.execute(args);
        System.exit(0);
    }
}

