/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.awt.Color;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerPlayer;

public class ChatMessage
extends AttributeMessage {
    public static final String TAG = "chat";
    private static final String COLOR_TAG = "color";
    private static final String MESSAGE_TAG = "message";
    private static final String PRIVATE_TAG = "private";
    private static final String SENDER_TAG = "sender";

    public ChatMessage(Player player, String message, boolean privateChat) {
        super(TAG, COLOR_TAG, String.valueOf(player.getNationColor().getRGB()), MESSAGE_TAG, message, PRIVATE_TAG, String.valueOf(privateChat), SENDER_TAG, player.getName());
    }

    public ChatMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, COLOR_TAG, MESSAGE_TAG, SENDER_TAG, PRIVATE_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Color color = this.getColor();
        String sender = this.getSender();
        String text = this.getMessage();
        boolean isPrivate = this.isPrivate();
        if (sender == null || text == null) {
            return;
        }
        if (freeColClient.isInGame()) {
            this.igc(freeColClient).chatHandler(sender, text, color, isPrivate);
        } else {
            this.pgc(freeColClient).chatHandler(sender, text, color, isPrivate);
        }
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        this.setStringAttribute(SENDER_TAG, serverPlayer.getId());
        return this.igc(freeColServer).chat(serverPlayer, this.getMessage(), this.isPrivate());
    }

    public Color getColor() {
        Color color = null;
        try {
            int rgb = this.getIntegerAttribute(COLOR_TAG, 0);
            color = new Color(rgb);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return color;
    }

    public String getMessage() {
        return this.getStringAttribute(MESSAGE_TAG);
    }

    public boolean isPrivate() {
        return this.getBooleanAttribute(PRIVATE_TAG, Boolean.FALSE);
    }

    public String getSender() {
        return this.getStringAttribute(SENDER_TAG);
    }
}

