/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class JDBCCallSyntaxTranslator {
    private String procedureName = null;
    private boolean hasReturnValueSyntax = false;
    private static final String sqlIdentifierPart = "(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))";
    private static final String sqlIdentifier = "((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))(?:\\.(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))){0,3}?)";
    private static final Pattern jdbcCallSyntax = Pattern.compile("(?s)\\s*?\\{\\s*?(\\?\\s*?=)?\\s*?[cC][aA][lL][lL]\\s+?((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))(?:\\.(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))){0,3}?)(?:\\s*?\\((.*)\\))?\\s*\\}.*+");
    private static final Pattern sqlExecSyntax = Pattern.compile("\\s*?[eE][xX][eE][cC](?:[uU][tT][eE])??\\s+?(((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))(?:\\.(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))){0,3}?)\\s*?=\\s+?)??((?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))(?:\\.(?:(?:\\[(?:[^\\]]|(?:\\]\\]))+?\\])|(?:\"(?:[^\"]|(?:\"\"))+?\")|(?:\\S+?))){0,3}?)(?:$|(?:\\s+?.*+))");

    JDBCCallSyntaxTranslator() {
    }

    String getProcedureName() {
        return this.procedureName;
    }

    boolean hasReturnValueSyntax() {
        return this.hasReturnValueSyntax;
    }

    String translate(String string) {
        Matcher matcher = jdbcCallSyntax.matcher(string);
        if (matcher.matches()) {
            this.hasReturnValueSyntax = null != matcher.group(1);
            this.procedureName = matcher.group(2);
            String string2 = matcher.group(3);
            return "EXEC " + (this.hasReturnValueSyntax ? "? = " : "") + this.procedureName + (null != string2 ? " " + string2 : "");
        }
        matcher = sqlExecSyntax.matcher(string);
        if (matcher.matches()) {
            this.hasReturnValueSyntax = null != matcher.group(1);
            this.procedureName = matcher.group(3);
            return string;
        }
        return string;
    }
}

