/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import ca.sqlpower.util.AbstractCache;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;

public class LeastRecentlyUsedCache
extends AbstractCache
implements Serializable {
    private LinkedList useOrder = new LinkedList();

    public LeastRecentlyUsedCache(int initialMaxMembers) {
        super(initialMaxMembers);
    }

    @Override
    public void itemsInserted(Object[] keys) {
        this.useOrder.addAll(0, Arrays.asList(keys));
        while (this.size() > this.maxMembers) {
            Object evictKey = this.useOrder.getLast();
            this.useOrder.removeLast();
            this.remove(evictKey);
        }
    }

    @Override
    public void itemRequested(Object key, boolean wasPresent) {
        if (wasPresent) {
            int itemIndex = this.useOrder.indexOf(key);
            if (itemIndex == -1) {
                throw new IllegalStateException("LRUCache.itemRequested: key '" + key + "' was not found in useList");
            }
            this.useOrder.remove(itemIndex);
            this.useOrder.addFirst(key);
        }
    }
}

