/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProviderModel {
    private static final String SEARCH_PROVIDERS_FOLDER = "/QuickSearch";
    private static final String COMMAND_PREFIX = "command";
    private static ProviderModel instance;
    private List<Category> categories;
    private HashSet<String> knownCommands;

    private ProviderModel() {
    }

    public static ProviderModel getInstance() {
        if (instance == null) {
            instance = new ProviderModel();
        }
        return instance;
    }

    public List<Category> getCategories() {
        if (this.categories == null) {
            this.categories = ProviderModel.loadCategories();
        }
        return this.categories;
    }

    public boolean isKnownCommand(String string) {
        if (this.knownCommands == null) {
            this.knownCommands = new HashSet();
            for (Category category : this.getCategories()) {
                this.knownCommands.add(category.getCommandPrefix());
            }
        }
        return this.knownCommands.contains(string);
    }

    private static List<Category> loadCategories() {
        FileObject[] fileObjectArray = Repository.getDefault().getDefaultFileSystem().findResource(SEARCH_PROVIDERS_FOLDER).getChildren();
        List list = FileUtil.getOrder(Arrays.asList(fileObjectArray), (boolean)false);
        ArrayList<Category> arrayList = new ArrayList<Category>(list.size());
        for (FileObject fileObject : list) {
            String string = null;
            try {
                string = fileObject.getFileSystem().getStatus().annotateName(fileObject.getNameExt(), Collections.singleton(fileObject));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Logger.getLogger(ProviderModel.class.getName()).log(Level.WARNING, "Obtaining display name for " + fileObject + " failed.", fileStateInvalidException);
            }
            String string2 = null;
            Object object = fileObject.getAttribute(COMMAND_PREFIX);
            if (object instanceof String) {
                string2 = (String)object;
            }
            arrayList.add(new Category(fileObject, string, string2));
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Category {
        private FileObject fo;
        private String displayName;
        private String commandPrefix;
        private List<SearchProvider> providers;

        public Category(FileObject fileObject, String string, String string2) {
            this.fo = fileObject;
            this.displayName = string;
            this.commandPrefix = string2;
        }

        public List<SearchProvider> getProviders() {
            if (this.providers == null) {
                Collection collection = Lookups.forPath((String)this.fo.getPath()).lookupAll(SearchProvider.class);
                this.providers = new ArrayList<SearchProvider>(collection);
            }
            return this.providers;
        }

        public String getName() {
            return this.fo.getNameExt();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getCommandPrefix() {
            return this.commandPrefix;
        }
    }
}

