/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.console.internal.extension;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.auth.ManagedUser;
import org.openhab.core.auth.User;
import org.openhab.core.auth.UserApiToken;
import org.openhab.core.auth.UserRegistry;
import org.openhab.core.io.console.Console;
import org.openhab.core.io.console.extensions.AbstractConsoleCommandExtension;
import org.openhab.core.io.console.extensions.ConsoleCommandExtension;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConsoleCommandExtension.class})
@NonNullByDefault
public class UserConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String SUBCMD_LIST = "list";
    private static final String SUBCMD_ADD = "add";
    private static final String SUBCMD_REMOVE = "remove";
    private static final String SUBCMD_CHANGEPASSWORD = "changePassword";
    private static final String SUBCMD_LISTAPITOKENS = "listApiTokens";
    private static final String SUBCMD_ADDAPITOKEN = "addApiToken";
    private static final String SUBCMD_RMAPITOKEN = "rmApiToken";
    private static final String SUBCMD_CLEARSESSIONS = "clearSessions";
    private final UserRegistry userRegistry;

    @Activate
    public UserConsoleCommandExtension(@Reference UserRegistry userRegistry) {
        super("users", "Access the user registry.");
        this.userRegistry = userRegistry;
    }

    @Override
    public List<String> getUsages() {
        return List.of(this.buildCommandUsage(SUBCMD_LIST, "lists all users"), this.buildCommandUsage("add <userId> <password> <role>", "adds a new user with the specified role"), this.buildCommandUsage("remove <userId>", "removes the given user"), this.buildCommandUsage("changePassword <userId> <newPassword>", "changes the password of a user"), this.buildCommandUsage(SUBCMD_LISTAPITOKENS, "lists the API tokens for all users"), this.buildCommandUsage("addApiToken <userId> <tokenName> <scope>", "adds a new API token on behalf of the specified user for the specified scope"), this.buildCommandUsage("rmApiToken <userId> <tokenName>", "removes (revokes) the specified API token"), this.buildCommandUsage("clearSessions <userId>", "clear the refresh tokens associated with the user (will sign the user out of all sessions)"));
    }

    @Override
    public void execute(String[] args, Console console) {
        block44: {
            block42: {
                String subCommand;
                if (args.length <= 0) break block42;
                switch (subCommand = args[0]) {
                    case "list": {
                        this.userRegistry.getAll().forEach(user -> console.println(user.toString()));
                        break;
                    }
                    case "add": {
                        if (args.length == 4) {
                            User existingUser = (User)this.userRegistry.get((Object)args[1]);
                            if (existingUser == null) {
                                User newUser = this.userRegistry.register(args[1], args[2], Set.of(args[3]));
                                console.println(newUser.toString());
                                console.println("User created.");
                                break;
                            }
                            console.println("The user already exists.");
                            break;
                        }
                        console.printUsage(this.findUsage(SUBCMD_ADD));
                        break;
                    }
                    case "remove": {
                        if (args.length == 2) {
                            User user2 = (User)this.userRegistry.get((Object)args[1]);
                            if (user2 != null) {
                                this.userRegistry.remove((Object)user2.getName());
                                console.println("User removed.");
                                break;
                            }
                            console.println("User not found.");
                            break;
                        }
                        console.printUsage(this.findUsage(SUBCMD_REMOVE));
                        break;
                    }
                    case "changePassword": {
                        if (args.length == 3) {
                            User user3 = (User)this.userRegistry.get((Object)args[1]);
                            if (user3 != null) {
                                this.userRegistry.changePassword(user3, args[2]);
                                console.println("Password changed.");
                                break;
                            }
                            console.println("User not found.");
                            break;
                        }
                        console.printUsage(this.findUsage(SUBCMD_CHANGEPASSWORD));
                        break;
                    }
                    case "listApiTokens": {
                        this.userRegistry.getAll().forEach(user -> {
                            ManagedUser managedUser = (ManagedUser)user;
                            if (!managedUser.getApiTokens().isEmpty()) {
                                managedUser.getApiTokens().forEach(t -> console.println("user=" + user.toString() + ", " + t.toString()));
                            }
                        });
                        break;
                    }
                    case "addApiToken": {
                        if (args.length == 4) {
                            ManagedUser user4 = (ManagedUser)this.userRegistry.get((Object)args[1]);
                            if (user4 != null) {
                                Optional<UserApiToken> userApiToken = user4.getApiTokens().stream().filter(t -> args[2].equals(t.getName())).findAny();
                                if (userApiToken.isEmpty()) {
                                    String tokenString = this.userRegistry.addUserApiToken((User)user4, args[2], args[3]);
                                    console.println(tokenString);
                                    break;
                                }
                                console.println("Cannot create API token: another one with the same name was found.");
                                break;
                            }
                            console.println("User not found.");
                            break;
                        }
                        console.printUsage(this.findUsage(SUBCMD_ADDAPITOKEN));
                        break;
                    }
                    case "rmApiToken": {
                        if (args.length == 3) {
                            ManagedUser user5 = (ManagedUser)this.userRegistry.get((Object)args[1]);
                            if (user5 != null) {
                                Optional<UserApiToken> userApiToken = user5.getApiTokens().stream().filter(t -> args[2].equals(t.getName())).findAny();
                                if (userApiToken.isPresent()) {
                                    this.userRegistry.removeUserApiToken((User)user5, userApiToken.get());
                                    console.println("API token revoked.");
                                    break;
                                }
                                console.println("No matching API token found.");
                                break;
                            }
                            console.println("User not found.");
                            break;
                        }
                        console.printUsage(this.findUsage(SUBCMD_RMAPITOKEN));
                        break;
                    }
                    case "clearSessions": {
                        if (args.length == 2) {
                            User user6 = (User)this.userRegistry.get((Object)args[1]);
                            if (user6 != null) {
                                this.userRegistry.clearSessions(user6);
                                console.println("User sessions cleared.");
                                break;
                            }
                            console.println("User not found.");
                            break;
                        }
                        console.printUsage(this.findUsage(SUBCMD_CLEARSESSIONS));
                        break;
                    }
                    default: {
                        console.println("Unknown command '" + subCommand + "'");
                        this.printUsage(console);
                        break;
                    }
                }
                break block44;
            }
            this.printUsage(console);
        }
    }

    private String findUsage(String cmd) {
        return this.getUsages().stream().filter(u -> u.contains(cmd)).findAny().get();
    }
}

