/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.types;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.GroupFunction;
import org.openhab.core.items.Item;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.StringType;
import org.openhab.core.types.State;
import org.openhab.core.types.UnDefType;
import org.openhab.core.util.Statistics;

@NonNullByDefault
public interface ArithmeticGroupFunction
extends GroupFunction {

    public static class And
    implements GroupFunction {
        protected final State activeState;
        protected final State passiveState;

        public And(@Nullable State activeValue, @Nullable State passiveValue) {
            if (activeValue == null || passiveValue == null) {
                throw new IllegalArgumentException("Parameters must not be null!");
            }
            this.activeState = activeValue;
            this.passiveState = passiveValue;
        }

        @Override
        public State calculate(@Nullable Set<Item> items) {
            if (items == null || items.isEmpty()) {
                return this.passiveState;
            }
            for (Item item : items) {
                if (this.activeState.equals(item.getStateAs(this.activeState.getClass()))) continue;
                return this.passiveState;
            }
            return this.activeState;
        }

        @Override
        public <T extends State> @Nullable T getStateAs(@Nullable Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            if (stateClass == DecimalType.class) {
                if (items != null) {
                    return (T)((State)stateClass.cast(new DecimalType(items.size() - this.count(items, this.activeState))));
                }
                return (T)((State)stateClass.cast(DecimalType.ZERO));
            }
            return null;
        }

        private int count(Set<Item> items, State state) {
            int count = 0;
            for (Item item : items) {
                if (!state.equals(item.getStateAs(state.getClass()))) continue;
                ++count;
            }
            return count;
        }

        @Override
        public State[] getParameters() {
            return new State[]{this.activeState, this.passiveState};
        }
    }

    public static class Avg
    implements GroupFunction {
        @Override
        public State calculate(@Nullable Set<Item> items) {
            BigDecimal sum = BigDecimal.ZERO;
            int count = 0;
            if (items != null) {
                for (Item item : items) {
                    DecimalType itemState = item.getStateAs(DecimalType.class);
                    if (itemState == null) continue;
                    sum = sum.add(itemState.toBigDecimal());
                    ++count;
                }
            }
            if (count > 0) {
                return new DecimalType(sum.divide(BigDecimal.valueOf(count), MathContext.DECIMAL128));
            }
            return UnDefType.UNDEF;
        }

        @Override
        public <T extends State> @Nullable T getStateAs(@Nullable Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }
    }

    public static class Count
    implements GroupFunction {
        protected final Pattern pattern;

        public Count(@Nullable State regExpr) {
            if (regExpr == null) {
                throw new IllegalArgumentException("Parameter must not be null!");
            }
            this.pattern = Pattern.compile(regExpr.toString());
        }

        @Override
        public State calculate(@Nullable Set<Item> items) {
            int count = 0;
            if (items != null) {
                for (Item item : items) {
                    Matcher matcher = this.pattern.matcher(item.getState().toString());
                    if (!matcher.matches()) continue;
                    ++count;
                }
            }
            return new DecimalType(count);
        }

        @Override
        public <T extends State> @Nullable T getStateAs(@Nullable Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[]{new StringType(this.pattern.pattern())};
        }
    }

    public static class Max
    implements GroupFunction {
        @Override
        public State calculate(@Nullable Set<Item> items) {
            if (items != null && !items.isEmpty()) {
                BigDecimal max = null;
                for (Item item : items) {
                    DecimalType itemState = item.getStateAs(DecimalType.class);
                    if (itemState == null || max != null && max.compareTo(itemState.toBigDecimal()) >= 0) continue;
                    max = itemState.toBigDecimal();
                }
                if (max != null) {
                    return new DecimalType(max);
                }
            }
            return UnDefType.UNDEF;
        }

        @Override
        public <T extends State> @Nullable T getStateAs(@Nullable Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }
    }

    public static class Median
    implements GroupFunction {
        @Override
        public State calculate(@Nullable Set<Item> items) {
            List<BigDecimal> states;
            BigDecimal median;
            if (items != null && (median = Statistics.median(states = items.stream().map(item -> item.getStateAs(DecimalType.class)).filter(Objects::nonNull).map(DecimalType::toBigDecimal).toList())) != null) {
                return new DecimalType(median);
            }
            return UnDefType.UNDEF;
        }

        @Override
        public <T extends State> @Nullable T getStateAs(@Nullable Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }
    }

    public static class Min
    implements GroupFunction {
        @Override
        public State calculate(@Nullable Set<Item> items) {
            if (items != null && !items.isEmpty()) {
                BigDecimal min = null;
                for (Item item : items) {
                    DecimalType itemState = item.getStateAs(DecimalType.class);
                    if (itemState == null || min != null && min.compareTo(itemState.toBigDecimal()) <= 0) continue;
                    min = itemState.toBigDecimal();
                }
                if (min != null) {
                    return new DecimalType(min);
                }
            }
            return UnDefType.UNDEF;
        }

        @Override
        public <T extends State> @Nullable T getStateAs(@Nullable Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }
    }

    public static class NAnd
    extends And {
        public NAnd(@Nullable State activeValue, @Nullable State passiveValue) {
            super(activeValue, passiveValue);
        }

        @Override
        public State calculate(@Nullable Set<Item> items) {
            State result = super.calculate(items);
            return this.activeState.equals(result) ? this.passiveState : this.activeState;
        }
    }

    public static class NOr
    extends Or {
        public NOr(@Nullable State activeValue, @Nullable State passiveValue) {
            super(activeValue, passiveValue);
        }

        @Override
        public State calculate(@Nullable Set<Item> items) {
            State result = super.calculate(items);
            return this.activeState.equals(result) ? this.passiveState : this.activeState;
        }
    }

    public static class Or
    implements GroupFunction {
        protected final State activeState;
        protected final State passiveState;

        public Or(@Nullable State activeValue, @Nullable State passiveValue) {
            if (activeValue == null || passiveValue == null) {
                throw new IllegalArgumentException("Parameters must not be null!");
            }
            this.activeState = activeValue;
            this.passiveState = passiveValue;
        }

        @Override
        public State calculate(@Nullable Set<Item> items) {
            if (items != null) {
                for (Item item : items) {
                    if (!this.activeState.equals(item.getStateAs(this.activeState.getClass()))) continue;
                    return this.activeState;
                }
            }
            return this.passiveState;
        }

        @Override
        public <T extends State> @Nullable T getStateAs(@Nullable Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            if (stateClass == DecimalType.class) {
                if (items != null) {
                    return (T)((State)stateClass.cast(new DecimalType(this.count(items, this.activeState))));
                }
                return (T)((State)stateClass.cast(DecimalType.ZERO));
            }
            return null;
        }

        private int count(Set<Item> items, State state) {
            int count = 0;
            for (Item item : items) {
                if (!state.equals(item.getStateAs(state.getClass()))) continue;
                ++count;
            }
            return count;
        }

        @Override
        public State[] getParameters() {
            return new State[]{this.activeState, this.passiveState};
        }
    }

    public static class Sum
    implements GroupFunction {
        @Override
        public State calculate(@Nullable Set<Item> items) {
            BigDecimal sum = BigDecimal.ZERO;
            if (items != null) {
                for (Item item : items) {
                    DecimalType itemState = item.getStateAs(DecimalType.class);
                    if (itemState == null) continue;
                    sum = sum.add(itemState.toBigDecimal());
                }
            }
            return new DecimalType(sum);
        }

        @Override
        public <T extends State> @Nullable T getStateAs(@Nullable Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }
    }

    public static class Xor
    implements GroupFunction {
        protected final State activeState;
        protected final State passiveState;

        public Xor(@Nullable State activeValue, @Nullable State passiveValue) {
            if (activeValue == null || passiveValue == null) {
                throw new IllegalArgumentException("Parameters must not be null!");
            }
            this.activeState = activeValue;
            this.passiveState = passiveValue;
        }

        @Override
        public State calculate(@Nullable Set<Item> items) {
            if (items != null) {
                boolean foundOne = false;
                for (Item item : items) {
                    if (!this.activeState.equals(item.getStateAs(this.activeState.getClass()))) continue;
                    if (foundOne) {
                        return this.passiveState;
                    }
                    foundOne = true;
                }
                if (foundOne) {
                    return this.activeState;
                }
            }
            return this.passiveState;
        }

        @Override
        public <T extends State> @Nullable T getStateAs(@Nullable Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            if (stateClass == DecimalType.class) {
                if (items != null) {
                    return (T)((State)stateClass.cast(new DecimalType(this.count(items, this.activeState))));
                }
                return (T)((State)stateClass.cast(DecimalType.ZERO));
            }
            return null;
        }

        private int count(Set<Item> items, State state) {
            int count = 0;
            for (Item item : items) {
                if (!state.equals(item.getStateAs(state.getClass()))) continue;
                ++count;
            }
            return count;
        }

        @Override
        public State[] getParameters() {
            return new State[]{this.activeState, this.passiveState};
        }
    }
}

