/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.StandardOutputResolver;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.ReconfigurableSerializer;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultDocument
extends Instruction
implements ValidatingInstruction {
    protected Expression href;
    protected Expression formatExpression;
    protected Expression content;
    private boolean async = false;
    protected Properties globalProperties;
    protected Properties localProperties;
    protected String baseURI;
    protected ParseOptions validationOptions;
    protected Map<StructuredQName, Expression> serializationAttributes;
    protected NamespaceResolver nsResolver;
    protected Expression dynamicOutputElement;
    protected boolean resolveAgainstStaticBase = false;
    protected CharacterMapIndex characterMapIndex;

    public ResultDocument(Properties globalProperties, Properties localProperties, Expression href, Expression formatExpression, String baseURI, int validationAction, SchemaType schemaType, Map<StructuredQName, Expression> serializationAttributes, CharacterMapIndex characterMapIndex, NamespaceResolver nsResolver) {
        this.globalProperties = globalProperties;
        this.localProperties = localProperties;
        this.href = href;
        this.formatExpression = formatExpression;
        this.baseURI = baseURI;
        this.setValidationAction(validationAction, schemaType);
        this.serializationAttributes = serializationAttributes;
        this.characterMapIndex = characterMapIndex;
        this.nsResolver = nsResolver;
        this.adoptChildExpression(href);
        for (Expression e : serializationAttributes.values()) {
            this.adoptChildExpression(e);
        }
    }

    public void setContentExpression(Expression content) {
        this.content = content;
        this.adoptChildExpression(content);
    }

    public Expression getContentExpression() {
        return this.content;
    }

    public void setSchemaType(SchemaType type) {
        if (this.validationOptions == null) {
            this.validationOptions = new ParseOptions();
        }
        this.validationOptions.setSchemaValidationMode(8);
        this.validationOptions.setTopLevelType(type);
    }

    @Override
    public SchemaType getSchemaType() {
        return this.validationOptions == null ? null : this.validationOptions.getTopLevelType();
    }

    public Expression getHrefExpression() {
        return this.href;
    }

    public String getStaticBaseURI() {
        return this.baseURI;
    }

    public boolean isResolveAgainstStaticBase() {
        return this.resolveAgainstStaticBase;
    }

    public ParseOptions getValidationOptions() {
        return this.validationOptions;
    }

    public void setValidationAction(int mode, SchemaType schemaType) {
        boolean preservingTypes;
        boolean bl = preservingTypes = mode == 3 && schemaType == null;
        if (!preservingTypes && this.validationOptions == null) {
            this.validationOptions = new ParseOptions();
            this.validationOptions.setSchemaValidationMode(mode);
            this.validationOptions.setTopLevelType(schemaType);
        }
    }

    @Override
    public int getValidationAction() {
        return this.validationOptions == null ? 3 : this.validationOptions.getSchemaValidationMode();
    }

    public Expression getFormatExpression() {
        return this.formatExpression;
    }

    public void setDynamicOutputElement(Expression exp) {
        this.dynamicOutputElement = exp;
    }

    public void setUseStaticBaseUri(boolean staticBase) {
        this.resolveAgainstStaticBase = staticBase;
    }

    public void setAsynchronous(boolean async) {
        this.async = async;
    }

    public boolean isAsynchronous() {
        return this.async;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.content = visitor.simplify(this.content);
        this.href = visitor.simplify(this.href);
        for (Map.Entry<StructuredQName, Expression> entry : this.serializationAttributes.entrySet()) {
            Expression value = entry.getValue();
            if (value instanceof Literal) continue;
            value = visitor.simplify(value);
            this.serializationAttributes.put(entry.getKey(), value);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.content = visitor.typeCheck(this.content, contextInfo);
        this.adoptChildExpression(this.content);
        if (this.href != null) {
            this.href = visitor.typeCheck(this.href, contextInfo);
            this.adoptChildExpression(this.href);
        }
        if (this.formatExpression != null) {
            this.formatExpression = visitor.typeCheck(this.formatExpression, contextInfo);
            this.adoptChildExpression(this.formatExpression);
        }
        for (Map.Entry<StructuredQName, Expression> entry : this.serializationAttributes.entrySet()) {
            Expression value = entry.getValue();
            if (value instanceof Literal) continue;
            value = visitor.typeCheck(value, contextInfo);
            this.adoptChildExpression(value);
            this.serializationAttributes.put(entry.getKey(), value);
        }
        try {
            DocumentInstr.checkContentSequence(visitor.getStaticContext(), this.content, this.validationOptions);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.content = visitor.optimize(this.content, contextItemType);
        this.adoptChildExpression(this.content);
        if (this.href != null) {
            this.href = visitor.optimize(this.href, contextItemType);
            this.adoptChildExpression(this.href);
        }
        if (this.formatExpression != null) {
            this.formatExpression = visitor.optimize(this.formatExpression, contextItemType);
            this.adoptChildExpression(this.formatExpression);
        }
        for (Map.Entry<StructuredQName, Expression> entry : this.serializationAttributes.entrySet()) {
            Expression value = entry.getValue();
            if (value instanceof Literal) continue;
            value = visitor.optimize(value, contextItemType);
            this.adoptChildExpression(value);
            this.serializationAttributes.put(entry.getKey(), value);
        }
        return this;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 0x1000000;
    }

    @Override
    public Expression copy() {
        ResultDocument r = new ResultDocument(this.globalProperties, this.localProperties, this.href == null ? null : this.href.copy(), this.formatExpression == null ? null : this.formatExpression.copy(), this.baseURI, this.getValidationAction(), this.getSchemaType(), this.serializationAttributes, this.characterMapIndex, this.nsResolver);
        r.content = this.content.copy();
        r.dynamicOutputElement = this.dynamicOutputElement == null ? null : this.dynamicOutputElement.copy();
        r.resolveAgainstStaticBase = this.resolveAgainstStaticBase;
        r.async = this.async;
        return r;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.content = this.doPromotion(this.content, offer);
        if (this.href != null) {
            this.href = this.doPromotion(this.href, offer);
        }
        for (Map.Entry<StructuredQName, Expression> entry : this.serializationAttributes.entrySet()) {
            Expression value = entry.getValue();
            if (value instanceof Literal) continue;
            value = this.doPromotion(value, offer);
            this.serializationAttributes.put(entry.getKey(), value);
        }
    }

    @Override
    public int getInstructionNameCode() {
        return 192;
    }

    @Override
    public ItemType getItemType() {
        return ErrorType.getInstance();
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>(6);
        list.add(new Operand(this.content, OperandRole.SINGLE_ATOMIC));
        if (this.href != null) {
            list.add(new Operand(this.href, OperandRole.SINGLE_ATOMIC));
        }
        if (this.formatExpression != null) {
            list.add(new Operand(this.formatExpression, OperandRole.SINGLE_ATOMIC));
        }
        for (Expression e : this.serializationAttributes.values()) {
            list.add(new Operand(e, OperandRole.SINGLE_ATOMIC));
        }
        if (this.dynamicOutputElement != null) {
            list.add(new Operand(this.dynamicOutputElement, OperandRole.SINGLE_ATOMIC));
        }
        return list;
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        if (this.content == original) {
            this.content = replacement;
            found = true;
        }
        if (this.href == original) {
            this.href = replacement;
            found = true;
        }
        for (Map.Entry<StructuredQName, Expression> entry : this.serializationAttributes.entrySet()) {
            if (entry.getValue() != original) continue;
            this.serializationAttributes.put(entry.getKey(), replacement);
            found = true;
        }
        if (this.dynamicOutputElement == original) {
            this.dynamicOutputElement = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet result = super.addToPathMap(pathMap, pathMapNodeSet);
        result.setReturnable(false);
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        this.process(this.content, context);
        return null;
    }

    public void process(Expression content, XPathContext context) throws XPathException {
        if (context.getTemporaryOutputState() != 0) {
            XPathException err = new XPathException("Cannot execute xsl:result-document while evaluating xsl:" + context.getNamePool().getDisplayName(context.getTemporaryOutputState()));
            err.setErrorCode("XTDE1480");
            err.setLocator(this);
            throw err;
        }
        context.getConfiguration().processResultDocument(this, content, context);
    }

    public void processInstruction(Expression content, XPathContext context) throws XPathException {
        Receiver out;
        Controller controller = context.getController();
        assert (controller != null);
        SequenceReceiver saved = context.getReceiver();
        String savedOutputUri = context.getCurrentOutputUri();
        if (context.getTemporaryOutputState() != 0) {
            XPathException err = new XPathException("Cannot execute xsl:result-document while evaluating xsl:" + context.getNamePool().getDisplayName(context.getTemporaryOutputState()));
            err.setErrorCode("XTDE1480");
            err.setLocator(this);
            throw err;
        }
        Properties computedLocalProps = this.gatherOutputProperties(context);
        String nextInChain = computedLocalProps.getProperty("{http://saxon.sf.net/}next-in-chain");
        OutputURIResolver resolver = null;
        Result result = null;
        if (this.href == null) {
            if (!computedLocalProps.propertyNames().hasMoreElements()) {
                out = controller.getPrincipalResult();
            } else if (controller.getPrincipalResult() instanceof ReconfigurableSerializer) {
                ReconfigurableSerializer rs = (ReconfigurableSerializer)controller.getPrincipalResult();
                rs.reconfigure(computedLocalProps, this.characterMapIndex);
                out = rs;
            } else {
                out = controller.getPrincipalResult();
            }
            String resultURI = controller.getBaseOutputURI();
            if (resultURI == null) {
                resultURI = "dummy:/anonymous/principal/result";
            }
            ResultDocument.checkAcceptableUri(context, resultURI);
            context.changeOutputDestination(out, this.getValidationOptions());
            context.setCurrentOutputUri(resultURI);
            out = context.getReceiver();
        } else {
            resolver = controller.getOutputURIResolver().newInstance();
            try {
                result = ResultDocument.getResult(this.href, this.baseURI, context, resolver, this.resolveAgainstStaticBase);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                throw e;
            }
            SerializerFactory sf = context.getConfiguration().getSerializerFactory();
            PipelineConfiguration pipe = controller.makePipelineConfiguration();
            pipe.setHostLanguage(50);
            LocationProvider provider = pipe.getLocationProvider();
            out = sf.getReceiver(result, pipe, computedLocalProps, this.characterMapIndex);
            context.changeOutputDestination(out, this.getValidationOptions());
            context.setCurrentOutputUri(result.getSystemId());
            out = context.getReceiver();
            pipe.setLocationProvider(provider);
        }
        out.open();
        try {
            out.startDocument(0);
            content.process(context);
            out.endDocument();
        }
        catch (XPathException err) {
            err.setXPathContext(context);
            err.maybeSetLocation(this);
            throw err;
        }
        finally {
            out.close();
        }
        context.setReceiver(saved);
        context.setCurrentOutputUri(savedOutputUri);
        if (resolver != null) {
            try {
                resolver.close(result);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
    }

    public static Result getResult(Expression href, String baseURI, XPathContext context, OutputURIResolver resolver, boolean resolveAgainstStaticBase) throws XPathException {
        String resultURI;
        Result result;
        block14: {
            Controller controller = context.getController();
            if (href == null) {
                result = controller.getPrincipalResult();
                resultURI = controller.getBaseOutputURI();
                if (resultURI == null) {
                    resultURI = "dummy:/anonymous/principal/result";
                }
            } else {
                try {
                    String base = resolveAgainstStaticBase ? baseURI : controller.getCookedBaseOutputURI();
                    String hrefValue = EscapeURI.iriToUri(href.evaluateAsString(context)).toString();
                    if (hrefValue.equals("")) {
                        result = controller.getPrincipalResult();
                        resultURI = controller.getBaseOutputURI();
                        if (resultURI == null) {
                            resultURI = "dummy:/anonymous/principal/result";
                        }
                        break block14;
                    }
                    try {
                        result = resolver == null ? null : resolver.resolve(hrefValue, base);
                    }
                    catch (TransformerException err) {
                        throw XPathException.makeXPathException(err);
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                        throw new XPathException("Exception thrown by OutputURIResolver", err);
                    }
                    if (result == null) {
                        resolver = StandardOutputResolver.getInstance();
                        result = resolver.resolve(hrefValue, base);
                    }
                    if ((resultURI = result.getSystemId()) == null) {
                        try {
                            resultURI = new URI(base).resolve(hrefValue).toString();
                            result.setSystemId(resultURI);
                        }
                        catch (Exception err) {}
                    }
                }
                catch (TransformerException e) {
                    throw XPathException.makeXPathException(e);
                }
            }
        }
        ResultDocument.checkAcceptableUri(context, resultURI);
        ResultDocument.traceDestination(context, result);
        return result;
    }

    public static void traceDestination(XPathContext context, Result result) {
        Configuration config = context.getConfiguration();
        boolean timing = config.isTiming();
        if (timing) {
            String dest = result.getSystemId();
            if (dest == null) {
                dest = result instanceof StreamResult ? "anonymous output stream" : (result instanceof SAXResult ? "SAX2 ContentHandler" : (result instanceof DOMResult ? "DOM tree" : result.getClass().getName()));
            }
            config.getStandardErrorOutput().println("Writing to " + dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAcceptableUri(XPathContext context, String uri) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        if (uri != null) {
            if (controller.getDocumentPool().find(uri) != null) {
                XPathException err = new XPathException("Cannot write to a URI that has already been read: " + (uri.equals("dummy:/anonymous/principal/result") ? "(implicit output URI)" : uri));
                err.setXPathContext(context);
                err.setErrorCode("XTRE1500");
                throw err;
            }
            DocumentURI documentKey = new DocumentURI(uri);
            Controller controller2 = controller;
            synchronized (controller2) {
                if (!controller.checkUniqueOutputDestination(documentKey)) {
                    XPathException err = new XPathException("Cannot write more than one result document to the same URI: " + (uri.equals("dummy:/anonymous/principal/result") ? "(implicit output URI)" : uri));
                    err.setXPathContext(context);
                    err.setErrorCode("XTDE1490");
                    throw err;
                }
                controller.addUnavailableOutputDestination(documentKey);
            }
        }
        controller.setThereHasBeenAnExplicitResultDocument();
    }

    public Properties gatherOutputProperties(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        Configuration config = context.getConfiguration();
        Properties computedGlobalProps = this.globalProperties;
        if (this.formatExpression != null) {
            String[] parts;
            CharSequence format = this.formatExpression.evaluateAsString(context);
            try {
                parts = NameChecker.getQNameParts(format);
            }
            catch (QNameException qNameException) {
                XPathException err = new XPathException("The requested output format " + Err.wrap(format) + " is not a valid QName");
                err.setErrorCode("XTDE1460");
                err.setXPathContext(context);
                throw err;
            }
            String string = this.nsResolver.getURIForPrefix(parts[0], false);
            if (string == null) {
                XPathException err = new XPathException("The namespace prefix in the format name " + format + " is undeclared");
                err.setErrorCode("XTDE1460");
                err.setXPathContext(context);
                throw err;
            }
            StructuredQName qName = new StructuredQName(parts[0], string, parts[1]);
        }
        Properties computedLocalProps = new Properties(computedGlobalProps);
        for (Object object : this.localProperties.keySet()) {
            String key = (String)object;
            String[] parts = NamePool.parseClarkName(key);
            try {
                ResultDocument.setSerializationProperty(computedLocalProps, parts[0], parts[1], this.localProperties.getProperty(key), this.nsResolver, true, config);
            }
            catch (XPathException e) {
                e.setErrorCode("XTDE0030");
                e.maybeSetLocation(this);
                throw e;
            }
        }
        if (this.serializationAttributes.size() > 0) {
            for (Map.Entry entry : this.serializationAttributes.entrySet()) {
                String value = ((Expression)entry.getValue()).evaluateAsString(context).toString();
                String lname = ((StructuredQName)entry.getKey()).getLocalPart();
                String uri = ((StructuredQName)entry.getKey()).getURI();
                try {
                    ResultDocument.setSerializationProperty(computedLocalProps, uri, lname, value, this.nsResolver, false, config);
                }
                catch (XPathException e) {
                    e.setErrorCode("XTDE0030");
                    e.maybeSetLocation(this);
                    e.maybeSetContext(context);
                    if ("http://saxon.sf.net/".equals(e.getErrorCodeNamespace()) && "SXWN".equals(e.getErrorCodeLocalPart().substring(0, 4))) {
                        controller.getErrorListener().warning(e);
                        continue;
                    }
                    throw e;
                }
            }
        }
        if (this.dynamicOutputElement != null) {
            Item outputArg = this.dynamicOutputElement.evaluateItem(context);
            if (!(outputArg instanceof NodeInfo) || ((NodeInfo)outputArg).getNodeKind() != 1 || ((NodeInfo)outputArg).getFingerprint() != 183) {
                XPathException xPathException = new XPathException("The third argument of saxon:result-document must be an <xsl:output> element");
                xPathException.setLocator(this);
                xPathException.setXPathContext(context);
                throw xPathException;
            }
            Properties properties = new Properties();
            ResultDocument.processXslOutputElement((NodeInfo)outputArg, properties, context);
            for (Object o : properties.keySet()) {
                String key = (String)o;
                StructuredQName name = StructuredQName.fromClarkName(key);
                String value = properties.getProperty(key);
                try {
                    ResultDocument.setSerializationProperty(computedLocalProps, name.getURI(), name.getLocalPart(), value, this.nsResolver, false, config);
                }
                catch (XPathException e) {
                    e.setErrorCode("XTDE0030");
                    e.maybeSetLocation(this);
                    e.maybeSetContext(context);
                    throw e;
                }
            }
        }
        return computedLocalProps;
    }

    public static void setSerializationProperty(Properties details, String uri, String lname, String value, NamespaceResolver nsResolver, boolean prevalidated, Configuration config) throws XPathException {
        if (uri.length() == 0 || "http://saxon.sf.net/".equals(uri)) {
            if (lname.equals("method")) {
                if (value.equals("xml") || value.equals("html") || value.equals("text") || value.equals("xhtml") || prevalidated || value.startsWith("{")) {
                    details.setProperty("method", value);
                } else {
                    try {
                        String[] parts = NameChecker.getQNameParts(value);
                        String prefix = parts[0];
                        if (prefix.length() == 0) {
                            XPathException err = new XPathException("method must be xml, html, xhtml, or text, or a prefixed name");
                            err.setErrorCode("SEPM0016");
                            err.setIsStaticError(true);
                            throw err;
                        }
                        if (nsResolver != null) {
                            String muri = nsResolver.getURIForPrefix(prefix, false);
                            if (muri == null) {
                                XPathException err = new XPathException("Namespace prefix '" + prefix + "' has not been declared");
                                err.setErrorCode("SEPM0016");
                                err.setIsStaticError(true);
                                throw err;
                            }
                            details.setProperty("method", '{' + muri + '}' + parts[1]);
                        }
                        details.setProperty("method", value);
                    }
                    catch (QNameException e) {
                        XPathException err = new XPathException("Invalid method name. " + e.getMessage());
                        err.setErrorCode("SEPM0016");
                        err.setIsStaticError(true);
                        throw err;
                    }
                }
            } else if (lname.equals("use-character-maps")) {
                String existing = details.getProperty("use-character-maps");
                if (existing == null) {
                    existing = "";
                }
                details.setProperty("use-character-maps", existing + value);
            } else if (lname.equals("cdata-section-elements")) {
                ResultDocument.processListOfNodeNames(details, "cdata-section-elements", value, nsResolver, true, prevalidated);
            } else if (lname.equals("suppress-indentation")) {
                ResultDocument.processListOfNodeNames(details, "suppress-indentation", value, nsResolver, true, prevalidated);
            } else if (lname.equals("double-space")) {
                ResultDocument.processListOfNodeNames(details, "{http://saxon.sf.net/}double-space", value, nsResolver, true, prevalidated);
            } else if (lname.equals("attribute-order")) {
                ResultDocument.processListOfNodeNames(details, "{http://saxon.sf.net/}attribute-order", value, nsResolver, false, prevalidated);
            } else {
                if (lname.equals("next-in-chain")) {
                    XPathException e = new XPathException("saxon:next-in-chain property is available only on xsl:output");
                    e.setErrorCodeQName(new StructuredQName("saxon", "http://saxon.sf.net/", "SXWN9004"));
                    throw e;
                }
                if (lname.equals("output-version")) {
                    lname = "version";
                }
                String clarkName = lname;
                if (uri.length() != 0) {
                    clarkName = '{' + uri + '}' + lname;
                }
                if (!prevalidated) {
                    try {
                        value = SaxonOutputKeys.checkOutputProperty(clarkName, Whitespace.trim(value), config, true);
                    }
                    catch (XPathException err) {
                        err.maybeSetErrorCode("SEPM0016");
                        throw err;
                    }
                }
                details.setProperty(clarkName, value);
            }
        } else {
            details.setProperty('{' + uri + '}' + lname, value);
        }
    }

    private static void processListOfNodeNames(Properties details, String key, String value, NamespaceResolver nsResolver, boolean useDefaultNS, boolean prevalidated) throws XPathException {
        String existing = details.getProperty(key);
        if (existing == null) {
            existing = "";
        }
        String s = SaxonOutputKeys.parseListOfNodeNames(value, nsResolver, useDefaultNS, prevalidated, "SEPM0016");
        details.setProperty(key, existing + s);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("resultDocument");
        if (this.href != null) {
            out.startSubsidiaryElement("href");
            this.href.explain(out);
            out.endSubsidiaryElement();
        }
        out.startSubsidiaryElement("content");
        this.content.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }

    public static void processXslOutputElement(NodeInfo element, Properties props, XPathContext c) throws XPathException {
        NodeInfo att;
        AxisIterator iter = element.iterateAxis((byte)2);
        InscopeNamespaceResolver resolver = new InscopeNamespaceResolver(element);
        while ((att = (NodeInfo)iter.next()) != null) {
            String uri = att.getURI();
            String local = att.getLocalPart();
            String val = Whitespace.trim(att.getStringValueCS());
            ResultDocument.setSerializationProperty(props, uri, local, val, resolver, false, c.getConfiguration());
        }
    }
}

