/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import com.google.common.annotations.VisibleForTesting;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.ISimpleCompiler;
import org.codehaus.janino.SimpleCompiler;
import org.logstash.config.ir.compiler.ClassFields;
import org.logstash.config.ir.compiler.Closure;
import org.logstash.config.ir.compiler.Dataset;
import org.logstash.config.ir.compiler.FieldDeclarationGroup;
import org.logstash.config.ir.compiler.FieldDefinition;
import org.logstash.config.ir.compiler.MethodSyntaxElement;
import org.logstash.config.ir.compiler.SyntaxElement;
import org.logstash.config.ir.compiler.SyntaxFactory;
import org.logstash.config.ir.compiler.VariableDefinition;

public final class ComputeStepSyntaxElement<T extends Dataset> {
    public static final VariableDefinition CTOR_ARGUMENT = new VariableDefinition(Map.class, "arguments");
    private static final Path SOURCE_DIR = ComputeStepSyntaxElement.debugDir();
    private static final ThreadLocal<ISimpleCompiler> COMPILER = ThreadLocal.withInitial(SimpleCompiler::new);
    private static final ConcurrentHashMap<ComputeStepSyntaxElement<?>, Class<? extends Dataset>> CLASS_CACHE = new ConcurrentHashMap(100);
    private static final AtomicLong DATASET_CLASS_INDEX = new AtomicLong(0L);
    private static final Pattern REDUNDANT_SEMICOLON = Pattern.compile("\n[ ]*;\n");
    private static final String CLASS_NAME_PLACEHOLDER = "CLASS_NAME_PLACEHOLDER";
    private static final Pattern CLASS_NAME_PLACEHOLDER_REGEX = Pattern.compile("CLASS_NAME_PLACEHOLDER");
    private final Iterable<MethodSyntaxElement> methods;
    private final ClassFields fields;
    private final Class<T> type;
    private final String normalizedSource;

    public static <T extends Dataset> ComputeStepSyntaxElement<T> create(Iterable<MethodSyntaxElement> methods, ClassFields fields, Class<T> interfce) {
        return new ComputeStepSyntaxElement<T>(methods, fields, interfce);
    }

    @VisibleForTesting
    public static int classCacheSize() {
        return CLASS_CACHE.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void cleanClassCache() {
        ThreadLocal<ISimpleCompiler> threadLocal = COMPILER;
        synchronized (threadLocal) {
            CLASS_CACHE.clear();
        }
    }

    private ComputeStepSyntaxElement(Iterable<MethodSyntaxElement> methods, ClassFields fields, Class<T> interfce) {
        this.methods = methods;
        this.fields = fields;
        this.type = interfce;
        this.normalizedSource = this.generateCode(CLASS_NAME_PLACEHOLDER);
    }

    public T instantiate() {
        try {
            Class<Dataset> clazz = this.compile();
            return (T)clazz.getConstructor(Map.class).newInstance(this.ctorArguments());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Class<? extends Dataset> compile() {
        return CLASS_CACHE.computeIfAbsent(this, __ -> {
            try {
                ISimpleCompiler compiler = COMPILER.get();
                String name = String.format("CompiledDataset%d", DATASET_CLASS_INDEX.incrementAndGet());
                String code = CLASS_NAME_PLACEHOLDER_REGEX.matcher(this.normalizedSource).replaceAll(name);
                if (SOURCE_DIR != null) {
                    Path sourceFile = SOURCE_DIR.resolve(String.format("%s.java", name));
                    Files.write(sourceFile, code.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    compiler.cookFile(sourceFile.toFile());
                } else {
                    compiler.cook(code);
                }
                return compiler.getClassLoader().loadClass(String.format("org.logstash.generated.%s", name));
            }
            catch (IOException | ClassNotFoundException | CompileException ex) {
                throw new IllegalStateException(ex);
            }
        });
    }

    public int hashCode() {
        return this.normalizedSource.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ComputeStepSyntaxElement && this.normalizedSource.equals(((ComputeStepSyntaxElement)other).normalizedSource);
    }

    private String generateCode(String name) {
        try {
            return REDUNDANT_SEMICOLON.matcher(new Formatter().formatSource(String.format("package org.logstash.generated;\npublic final class %s extends org.logstash.config.ir.compiler.BaseDataset implements %s { %s }", name, this.type.getName(), SyntaxFactory.join(this.fields.inlineAssigned().generateCode(), this.fieldsAndCtor(name), ComputeStepSyntaxElement.combine((SyntaxElement[])StreamSupport.stream(this.methods.spliterator(), false).toArray(SyntaxElement[]::new)))))).replaceAll("\n");
        }
        catch (FormatterException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Path debugDir() {
        Path sourceDir = null;
        try {
            String dir = System.getProperty("org.codehaus.janino.source_debugging.dir");
            if (dir != null) {
                Path parentDir = Paths.get(dir, new String[0]);
                sourceDir = parentDir.resolve("org").resolve("logstash").resolve("generated");
                Files.createDirectories(sourceDir, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return sourceDir;
    }

    private Map<String, Object> ctorArguments() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.fields.ctorAssigned().getFields().forEach(fieldDefinition -> result.put(fieldDefinition.getName(), fieldDefinition.getCtorArgument()));
        return result;
    }

    private String fieldsAndCtor(String name) {
        Closure constructor = new Closure();
        FieldDeclarationGroup ctorFields = this.fields.ctorAssigned();
        for (FieldDefinition field : ctorFields.getFields()) {
            if (field.getCtorArgument() == null) continue;
            VariableDefinition fieldVar = field.asVariable();
            constructor.add(SyntaxFactory.assignment(fieldVar.access(), SyntaxFactory.cast(fieldVar.type, CTOR_ARGUMENT.access().call("get", SyntaxFactory.value(SyntaxFactory.join("\"", field.getName(), "\""))))));
        }
        return ComputeStepSyntaxElement.combine(ctorFields, MethodSyntaxElement.constructor(name, constructor.add(this.fields.afterInit())));
    }

    private static String combine(SyntaxElement ... parts) {
        return Arrays.stream(parts).map(SyntaxElement::generateCode).collect(Collectors.joining("\n"));
    }
}

