/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.Collection;
import java.util.function.DoubleUnaryOperator;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IRelationMember;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.spi.preferences.Config;

public class BoundingXYVisitor
implements OsmPrimitiveVisitor,
PrimitiveVisitor {
    private static final double ENLARGE_DEFAULT = 2.0E-4;
    private ProjectionBounds bounds;

    @Override
    public void visit(Node n) {
        this.visit((ILatLon)n);
    }

    @Override
    public void visit(Way w) {
        this.visit((IWay<?>)w);
    }

    @Override
    public void visit(Relation r) {
        this.visit((IRelation<?>)r);
    }

    @Override
    public void visit(INode n) {
        this.visit((ILatLon)n);
    }

    @Override
    public void visit(IWay<?> w) {
        if (w.isIncomplete()) {
            return;
        }
        for (INode n : w.getNodes()) {
            this.visit(n);
        }
    }

    @Override
    public void visit(IRelation<?> r) {
        for (IRelationMember m : r.getMembers()) {
            if (m.isRelation()) continue;
            m.getMember().accept(this);
        }
    }

    public void visit(Bounds b) {
        if (b != null) {
            ProjectionRegistry.getProjection().visitOutline(b, this::visit);
        }
    }

    public void visit(ProjectionBounds b) {
        if (b != null) {
            this.visit(b.getMin());
            this.visit(b.getMax());
        }
    }

    public void visit(ILatLon latlon) {
        if (latlon != null) {
            this.visit(latlon.getEastNorth(ProjectionRegistry.getProjection()));
        }
    }

    public void visit(LatLon latlon) {
        this.visit((ILatLon)latlon);
    }

    public void visit(EastNorth eastNorth) {
        if (eastNorth != null) {
            if (this.bounds == null) {
                this.bounds = new ProjectionBounds(eastNorth);
            } else {
                this.bounds.extend(eastNorth);
            }
        }
    }

    public boolean hasExtend() {
        return this.bounds != null && this.bounds.hasExtend();
    }

    public ProjectionBounds getBounds() {
        return this.bounds;
    }

    public void enlargeBoundingBox() {
        double enlarge = Config.getPref().getDouble("edit.zoom-enlarge-bbox", 2.0E-4);
        this.enlargeBoundingBox(enlarge, enlarge);
    }

    public void enlargeBoundingBox(double enlargeDegreeX, double enlargeDegreeY) {
        if (this.bounds == null) {
            return;
        }
        LatLon minLatlon = ProjectionRegistry.getProjection().eastNorth2latlon(this.bounds.getMin());
        LatLon maxLatlon = ProjectionRegistry.getProjection().eastNorth2latlon(this.bounds.getMax());
        this.bounds = new ProjectionBounds(new LatLon(Math.max(-90.0, minLatlon.lat() - enlargeDegreeY), Math.max(-180.0, minLatlon.lon() - enlargeDegreeX)).getEastNorth(ProjectionRegistry.getProjection()), new LatLon(Math.min(90.0, maxLatlon.lat() + enlargeDegreeY), Math.min(180.0, maxLatlon.lon() + enlargeDegreeX)).getEastNorth(ProjectionRegistry.getProjection()));
    }

    public void enlargeBoundingBoxLogarithmically() {
        if (this.bounds == null) {
            return;
        }
        LatLon min = ProjectionRegistry.getProjection().eastNorth2latlon(this.bounds.getMin());
        LatLon max = ProjectionRegistry.getProjection().eastNorth2latlon(this.bounds.getMax());
        double deltaLat = max.lat() - min.lat();
        double deltaLon = max.lon() - min.lon();
        double enlarge = Config.getPref().getDouble("edit.zoom-enlarge-bbox", 2.0E-4);
        DoubleUnaryOperator enlargement = deltaDegress -> {
            if (deltaDegress < enlarge) {
                return enlarge;
            }
            if (deltaDegress < 0.1) {
                return enlarge - deltaDegress / 100.0;
            }
            return 0.0;
        };
        this.enlargeBoundingBox(enlargement.applyAsDouble(deltaLon), enlargement.applyAsDouble(deltaLat));
    }

    public String toString() {
        return "BoundingXYVisitor[" + this.bounds + ']';
    }

    public void computeBoundingBox(Collection<? extends IPrimitive> primitives) {
        if (primitives == null) {
            return;
        }
        for (IPrimitive iPrimitive : primitives) {
            if (iPrimitive == null) continue;
            iPrimitive.accept(this);
        }
    }
}

