/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractValueGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ValueGraph;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
abstract class ForwardingValueGraph<N, V>
extends AbstractValueGraph<N, V> {
    ForwardingValueGraph() {
    }

    abstract ValueGraph<N, V> delegate();

    @Override
    public Set<N> nodes() {
        return this.delegate().nodes();
    }

    @Override
    protected long edgeCount() {
        return this.delegate().edges().size();
    }

    @Override
    public boolean isDirected() {
        return this.delegate().isDirected();
    }

    @Override
    public boolean allowsSelfLoops() {
        return this.delegate().allowsSelfLoops();
    }

    @Override
    public ElementOrder<N> nodeOrder() {
        return this.delegate().nodeOrder();
    }

    @Override
    public ElementOrder<N> incidentEdgeOrder() {
        return this.delegate().incidentEdgeOrder();
    }

    @Override
    public Set<N> adjacentNodes(N node2) {
        return this.delegate().adjacentNodes(node2);
    }

    @Override
    public Set<N> predecessors(N node2) {
        return this.delegate().predecessors((Object)node2);
    }

    @Override
    public Set<N> successors(N node2) {
        return this.delegate().successors((Object)node2);
    }

    @Override
    public int degree(N node2) {
        return this.delegate().degree(node2);
    }

    @Override
    public int inDegree(N node2) {
        return this.delegate().inDegree(node2);
    }

    @Override
    public int outDegree(N node2) {
        return this.delegate().outDegree(node2);
    }

    @Override
    public boolean hasEdgeConnecting(N nodeU, N nodeV) {
        return this.delegate().hasEdgeConnecting(nodeU, nodeV);
    }

    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
        return this.delegate().hasEdgeConnecting(endpoints);
    }

    @Override
    public Optional<V> edgeValue(N nodeU, N nodeV) {
        return this.delegate().edgeValue(nodeU, nodeV);
    }

    @Override
    public Optional<V> edgeValue(EndpointPair<N> endpoints) {
        return this.delegate().edgeValue(endpoints);
    }

    @Override
    @CheckForNull
    public V edgeValueOrDefault(N nodeU, N nodeV, @CheckForNull V defaultValue) {
        return this.delegate().edgeValueOrDefault(nodeU, nodeV, defaultValue);
    }

    @Override
    @CheckForNull
    public V edgeValueOrDefault(EndpointPair<N> endpoints, @CheckForNull V defaultValue) {
        return this.delegate().edgeValueOrDefault(endpoints, defaultValue);
    }
}

