/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.i2ptunnel.HTTPResponseOutputStream;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.TunnelControllerGroup;
import net.i2p.util.I2PAppThread;

public class I2PTunnelHTTPClientRunner
extends I2PTunnelRunner {
    private HTTPResponseOutputStream _hout;
    private final boolean _isHead;

    @Deprecated
    public I2PTunnelHTTPClientRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, List<I2PSocket> sockList, I2PTunnelRunner.FailCallback onFail) {
        super(s, i2ps, slock, initialI2PData, null, sockList, onFail);
        this._isHead = false;
    }

    public I2PTunnelHTTPClientRunner(Socket s, I2PSocket i2ps, Object slock, byte[] initialI2PData, List<I2PSocket> sockList, I2PTunnelRunner.FailCallback onFail, boolean allowKeepAliveI2P, boolean allowKeepAliveSocket, boolean isHead) {
        super(s, i2ps, slock, initialI2PData, null, sockList, onFail, allowKeepAliveI2P, allowKeepAliveSocket);
        if (allowKeepAliveI2P && !allowKeepAliveSocket) {
            throw new IllegalArgumentException();
        }
        this._isHead = isHead;
    }

    @Override
    protected OutputStream getSocketOut() throws IOException {
        if (this._hout != null) {
            throw new IllegalStateException("already called");
        }
        OutputStream raw = super.getSocketOut();
        this._hout = new HTTPResponseOutputStream(raw, super.getKeepAliveI2P(), super.getKeepAliveSocket(), this._isHead, this);
        return this._hout;
    }

    @Override
    boolean getKeepAliveSocket() {
        return this._hout != null && this._hout.getKeepAliveOut() && super.getKeepAliveSocket();
    }

    @Override
    boolean getKeepAliveI2P() {
        return this._hout != null && this._hout.getKeepAliveIn() && super.getKeepAliveI2P();
    }

    @Override
    protected void close(OutputStream out, InputStream in, OutputStream i2pout, InputStream i2pin, Socket s, I2PSocket i2ps, Thread t1, Thread t2) throws InterruptedException {
        boolean threadI2PClose;
        boolean keepaliveSocket = this.getKeepAliveSocket();
        boolean keepaliveI2P = this.getKeepAliveI2P();
        boolean bl = threadI2PClose = keepaliveSocket && !keepaliveI2P && i2pout != null && !i2ps.isClosed();
        if (this._log.shouldInfo()) {
            this._log.info("Closing HTTPClientRunner keepaliveI2P? " + keepaliveI2P + " keepaliveSocket? " + keepaliveSocket + " threadedClose? " + threadI2PClose, new Exception("I did it"));
        }
        if (threadI2PClose) {
            I2PSocketCloser t = new I2PSocketCloser(i2pin, i2pout, i2ps);
            TunnelControllerGroup tcg = TunnelControllerGroup.getInstance();
            if (tcg != null) {
                try {
                    tcg.getClientExecutor().execute(t);
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            } else {
                ((Thread)t).start();
            }
        } else {
            if (!keepaliveI2P && i2pin != null) {
                try {
                    i2pin.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (i2pout != null) {
                try {
                    if (keepaliveI2P) {
                        i2pout.flush();
                    } else {
                        i2pout.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (!keepaliveSocket && in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (out != null) {
            try {
                if (keepaliveSocket) {
                    out.flush();
                } else {
                    out.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!threadI2PClose && !keepaliveI2P) {
            try {
                i2ps.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!keepaliveSocket) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (t1 != null) {
            t1.join(30000L);
        }
    }

    private class I2PSocketCloser
    extends I2PAppThread {
        private final InputStream in;
        private final OutputStream out;
        private final I2PSocket s;

        public I2PSocketCloser(InputStream i2pin, OutputStream i2pout, I2PSocket i2ps) {
            this.in = i2pin;
            this.out = i2pout;
            this.s = i2ps;
        }

        @Override
        public void run() {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

