/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.jfluid.ProfilerClient;
import org.graalvm.visualvm.lib.jfluid.ProfilerEngineSettings;
import org.graalvm.visualvm.lib.jfluid.ProfilerLogger;
import org.graalvm.visualvm.lib.jfluid.TargetAppRunner;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.global.ProfilingSessionStatus;
import org.graalvm.visualvm.lib.profiler.actions.Bundle;
import org.graalvm.visualvm.lib.profiler.actions.ProfilingAwareAction;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;

public final class GetCmdLineArgumentsAction
extends ProfilingAwareAction {
    private static final int[] enabledStates = new int[]{4};

    public GetCmdLineArgumentsAction() {
        this.putValue("Name", Bundle.LBL_GetCmdLineArgumentsAction());
        this.putValue("ShortDescription", Bundle.HINT_GetCmdLineArgumentsAction());
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void performAction() {
        try {
            String javaCommand;
            String jvmArgs;
            TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
            ProfilerClient profilerClient = runner.getProfilerClient();
            ProfilingSessionStatus status = runner.getProfilingSessionStatus();
            ProfilerEngineSettings settings = runner.getProfilerEngineSettings();
            if (!profilerClient.targetJVMIsAlive()) {
                throw new ClientUtils.TargetAppOrVMTerminated(1, Bundle.GetCmdLineArgumentsAction_TargetJvmInactiveMsg());
            }
            if (status.runningInAttachedMode) {
                jvmArgs = status.jvmArguments;
                javaCommand = status.javaCommand;
            } else {
                jvmArgs = settings.getJVMArgsAsSingleString();
                javaCommand = settings.getMainClassName() + " " + settings.getMainArgsAsSingleString();
            }
            StringBuffer s = new StringBuffer();
            s.append("<b>");
            s.append(Bundle.GetCmdLineArgumentsAction_JvmArgumentsString());
            s.append("</b><br>");
            s.append(jvmArgs);
            s.append("<br><br>");
            s.append("<b>");
            s.append(Bundle.GetCmdLineArgumentsAction_MainClassAndArgsString());
            s.append("</b><br>");
            s.append(javaCommand);
            HTMLTextArea textArea = new HTMLTextArea(s.toString());
            textArea.getAccessibleContext().setAccessibleName(Bundle.CAPTION_JVMandMainClassCommandLineArguments());
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            p.add((Component)new JScrollPane((Component)textArea), "Center");
            p.setPreferredSize(new Dimension(600, 200));
            DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)p, Bundle.CAPTION_JVMandMainClassCommandLineArguments(), true, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null)).setVisible(true);
        }
        catch (ClientUtils.TargetAppOrVMTerminated e) {
            ProfilerDialogs.displayWarning((String)Bundle.MSG_NotAvailableNow(e.getMessage()));
            ProfilerLogger.log((String)e.getMessage());
        }
    }

    @Override
    protected int[] enabledStates() {
        return enabledStates;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public String getName() {
        return Bundle.LBL_GetCmdLineArgumentsAction();
    }
}

