/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.formula;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jxls.area.Area;
import org.jxls.common.AreaRef;
import org.jxls.common.CellData;
import org.jxls.common.CellRef;
import org.jxls.formula.AbstractFormulaProcessor;
import org.jxls.transform.Transformer;
import org.jxls.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardFormulaProcessor
extends AbstractFormulaProcessor {
    private static Logger logger = LoggerFactory.getLogger(StandardFormulaProcessor.class);
    private static final int MAX_NUM_ARGS_FOR_SUM = 255;

    @Override
    public void processAreaFormulas(Transformer transformer, Area area) {
        Set<CellData> formulaCells = transformer.getFormulaCells();
        for (CellData formulaCellData : formulaCells) {
            if (formulaCellData.getArea() == null || !area.getAreaRef().getSheetName().equals(formulaCellData.getSheetName())) continue;
            logger.debug("Processing formula cell {}", (Object)formulaCellData);
            List<CellRef> targetFormulaCells = formulaCellData.getTargetPos();
            Map<CellRef, List<CellRef>> targetCellRefMap = this.buildTargetCellRefMap(transformer, area, formulaCellData);
            Map<String, List<CellRef>> jointedCellRefMap = this.buildJointedCellRefMap(transformer, formulaCellData);
            ArrayList<CellRef> usedCellRefs = new ArrayList<CellRef>();
            for (int i = 0; i < targetFormulaCells.size(); ++i) {
                Map.Entry<CellRef, List<CellRef>> cellRefEntry2;
                CellRef targetFormulaCellRef = targetFormulaCells.get(i);
                String targetFormulaString = formulaCellData.getFormula();
                if (formulaCellData.isParameterizedFormulaCell() && i < formulaCellData.getEvaluatedFormulas().size()) {
                    targetFormulaString = formulaCellData.getEvaluatedFormulas().get(i);
                }
                AreaRef formulaSourceAreaRef = formulaCellData.getArea().getAreaRef();
                AreaRef formulaTargetAreaRef = formulaCellData.getTargetParentAreaRef().get(i);
                boolean isFormulaCellRefsEmpty = true;
                for (Map.Entry<CellRef, List<CellRef>> cellRefEntry2 : targetCellRefMap.entrySet()) {
                    List<CellRef> targetCells = cellRefEntry2.getValue();
                    if (targetCells.isEmpty()) continue;
                    isFormulaCellRefsEmpty = false;
                    List<CellRef> replacementCells = this.findFormulaCellRefReplacements(transformer, targetFormulaCellRef, formulaSourceAreaRef, formulaTargetAreaRef, cellRefEntry2);
                    if (formulaCellData.getFormulaStrategy() == CellData.FormulaStrategy.BY_COLUMN) {
                        replacementCells = Util.createTargetCellRefListByColumn(targetFormulaCellRef, replacementCells, usedCellRefs);
                        usedCellRefs.addAll(replacementCells);
                    }
                    String replacementString = Util.createTargetCellRef(replacementCells);
                    if (targetFormulaString.startsWith("SUM") && Util.countOccurences(replacementString, ',') >= 255) {
                        targetFormulaString = replacementString.replaceAll(",", "+");
                        continue;
                    }
                    String from = "(?<!U_\\([^)]{0,100})" + Util.sheetNameRegex(cellRefEntry2) + "(?<!\\w)" + Pattern.quote(((CellRef)cellRefEntry2.getKey()).getCellName());
                    String to = Matcher.quoteReplacement(replacementString);
                    targetFormulaString = targetFormulaString.replaceAll(from, to);
                }
                boolean isFormulaJointedCellRefsEmpty = true;
                cellRefEntry2 = jointedCellRefMap.entrySet().iterator();
                while (cellRefEntry2.hasNext()) {
                    Map.Entry jointedCellRefEntry = (Map.Entry)cellRefEntry2.next();
                    List targetCellRefList = (List)jointedCellRefEntry.getValue();
                    if (targetCellRefList.isEmpty()) continue;
                    Collections.sort(targetCellRefList);
                    isFormulaJointedCellRefsEmpty = false;
                    AbstractMap.SimpleImmutableEntry<Object, List> cellRefMapEntryParam = new AbstractMap.SimpleImmutableEntry<Object, List>(null, targetCellRefList);
                    List<CellRef> replacementCells = this.findFormulaCellRefReplacements(transformer, targetFormulaCellRef, formulaSourceAreaRef, formulaTargetAreaRef, cellRefMapEntryParam);
                    String replacementString = Util.createTargetCellRef(replacementCells);
                    targetFormulaString = targetFormulaString.replaceAll(Pattern.quote((String)jointedCellRefEntry.getKey()), replacementString);
                }
                String sheetNameReplacementRegex = Pattern.quote(targetFormulaCellRef.getFormattedSheetName() + '!');
                targetFormulaString = targetFormulaString.replaceAll(sheetNameReplacementRegex, "");
                if (isFormulaCellRefsEmpty && isFormulaJointedCellRefsEmpty && (!formulaCellData.isParameterizedFormulaCell() || formulaCellData.isJointedFormulaCell())) {
                    String string = targetFormulaString = formulaCellData.getDefaultValue() != null ? formulaCellData.getDefaultValue() : "0";
                }
                if (targetFormulaString.isEmpty()) continue;
                transformer.setFormula(new CellRef(targetFormulaCellRef.getSheetName(), targetFormulaCellRef.getRow(), targetFormulaCellRef.getCol()), targetFormulaString);
            }
        }
    }

    private List<CellRef> findFormulaCellRefReplacements(Transformer transformer, CellRef targetFormulaCellRef, AreaRef formulaSourceAreaRef, AreaRef formulaTargetAreaRef, Map.Entry<CellRef, List<CellRef>> cellReferenceEntry) {
        CellRef cellReference = cellReferenceEntry.getKey();
        List<CellRef> cellReferenceTargets = cellReferenceEntry.getValue();
        if (cellReference != null && !formulaSourceAreaRef.contains(cellReference)) {
            CellData cellRefData = transformer.getCellData(cellReference);
            if (cellRefData != null && !cellRefData.getTargetParentAreaRef().isEmpty()) {
                ArrayList<CellRef> targetReferences = new ArrayList<CellRef>();
                for (AreaRef targetAreaRef : cellRefData.getTargetParentAreaRef()) {
                    if (!targetAreaRef.contains(targetFormulaCellRef)) continue;
                    for (CellRef targetRef : cellReferenceTargets) {
                        if (!targetAreaRef.contains(targetRef)) continue;
                        targetReferences.add(targetRef);
                    }
                    return targetReferences;
                }
            }
            return cellReferenceTargets;
        }
        return this.findRelevantCellReferences(cellReferenceTargets, formulaTargetAreaRef);
    }

    private List<CellRef> findRelevantCellReferences(List<CellRef> cellReferenceTargets, AreaRef targetFormulaArea) {
        ArrayList<CellRef> relevantCellRefs = new ArrayList<CellRef>(cellReferenceTargets.size());
        for (CellRef targetCellRef : cellReferenceTargets) {
            if (!targetFormulaArea.contains(targetCellRef)) continue;
            relevantCellRefs.add(targetCellRef);
        }
        return relevantCellRefs;
    }
}

