/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jupnp.QueueingThreadPoolExecutor;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.binding.xml.DeviceDescriptorBinder;
import org.jupnp.binding.xml.RecoveringUDA10DeviceDescriptorBinderImpl;
import org.jupnp.binding.xml.RecoveringUDA10ServiceDescriptorBinderSAXImpl;
import org.jupnp.binding.xml.ServiceDescriptorBinder;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.Namespace;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.types.ServiceType;
import org.jupnp.transport.TransportConfiguration;
import org.jupnp.transport.TransportConfigurationProvider;
import org.jupnp.transport.impl.DatagramIOConfigurationImpl;
import org.jupnp.transport.impl.DatagramIOImpl;
import org.jupnp.transport.impl.DatagramProcessorImpl;
import org.jupnp.transport.impl.GENAEventProcessorImpl;
import org.jupnp.transport.impl.MulticastReceiverConfigurationImpl;
import org.jupnp.transport.impl.MulticastReceiverImpl;
import org.jupnp.transport.impl.NetworkAddressFactoryImpl;
import org.jupnp.transport.impl.SOAPActionProcessorImpl;
import org.jupnp.transport.impl.ServletStreamServerConfigurationImpl;
import org.jupnp.transport.impl.ServletStreamServerImpl;
import org.jupnp.transport.impl.jetty.StreamClientConfigurationImpl;
import org.jupnp.transport.impl.osgi.HttpServiceServletContainerAdapter;
import org.jupnp.transport.spi.DatagramIO;
import org.jupnp.transport.spi.DatagramProcessor;
import org.jupnp.transport.spi.GENAEventProcessor;
import org.jupnp.transport.spi.MulticastReceiver;
import org.jupnp.transport.spi.NetworkAddressFactory;
import org.jupnp.transport.spi.SOAPActionProcessor;
import org.jupnp.transport.spi.StreamClient;
import org.jupnp.transport.spi.StreamClientConfiguration;
import org.jupnp.transport.spi.StreamServer;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.jupnp"}, configurationPolicy=ConfigurationPolicy.REQUIRE, enabled=false)
public class OSGiUpnpServiceConfiguration
implements UpnpServiceConfiguration {
    protected static final String OSGI_SERVICE_HTTP_PORT = "org.osgi.service.http.port";
    private final Logger logger = LoggerFactory.getLogger(OSGiUpnpServiceConfiguration.class);
    protected int threadPoolSize = 20;
    protected int asyncThreadPoolSize = 20;
    protected int remoteThreadPoolSize = 40;
    protected String interfaces;
    protected int multicastResponsePort;
    protected int httpProxyPort = -1;
    protected int streamListenPort = 8080;
    protected boolean asyncThreadPool = true;
    protected boolean mainThreadPool = true;
    protected boolean remoteThreadPool = true;
    protected Namespace callbackURI = new Namespace("http://localhost/upnpcallback");
    protected ExecutorService mainExecutorService;
    protected ExecutorService asyncExecutorService;
    protected ExecutorService remoteExecutorService;
    protected DatagramProcessor datagramProcessor;
    protected SOAPActionProcessor soapActionProcessor;
    protected GENAEventProcessor genaEventProcessor;
    protected DeviceDescriptorBinder deviceDescriptorBinderUDA10;
    protected ServiceDescriptorBinder serviceDescriptorBinderUDA10;
    protected Namespace namespace;
    protected BundleContext context;
    protected TransportConfiguration transportConfiguration;
    protected Integer timeoutSeconds = 10;
    protected Integer retryIterations = 5;
    protected Integer retryAfterSeconds = (int)TimeUnit.MINUTES.toSeconds(10L);
    protected HttpService httpService;

    public OSGiUpnpServiceConfiguration() {
        this(0);
    }

    public OSGiUpnpServiceConfiguration(int streamListenPort) {
        this(streamListenPort, 0, true);
    }

    public OSGiUpnpServiceConfiguration(int streamListenPort, int multicastResponsePort) {
        this(streamListenPort, multicastResponsePort, true);
    }

    protected OSGiUpnpServiceConfiguration(boolean checkRuntime) {
        this(0, 0, checkRuntime);
    }

    protected OSGiUpnpServiceConfiguration(int streamListenPort, int multicastResponsePort, boolean checkRuntime) {
        if (checkRuntime && ModelUtil.ANDROID_RUNTIME) {
            throw new Error("Unsupported runtime environment, use org.jupnp.android.AndroidUpnpServiceConfiguration");
        }
        this.streamListenPort = streamListenPort;
        this.multicastResponsePort = multicastResponsePort;
        this.transportConfiguration = TransportConfigurationProvider.getDefaultTransportConfiguration();
    }

    @Activate
    protected void activate(BundleContext context, Map<String, Object> configProps) {
        this.context = context;
        this.setConfigValues(configProps);
        this.createExecutorServices();
        this.datagramProcessor = this.createDatagramProcessor();
        this.soapActionProcessor = this.createSOAPActionProcessor();
        this.genaEventProcessor = this.createGENAEventProcessor();
        this.deviceDescriptorBinderUDA10 = this.createDeviceDescriptorBinderUDA10();
        this.serviceDescriptorBinderUDA10 = this.createServiceDescriptorBinderUDA10();
        this.namespace = this.createNamespace();
        this.logger.debug("{} activated", (Object)this);
    }

    @Deactivate
    protected void deactivate() {
        this.shutdown();
        this.logger.debug("{} deactivated", (Object)this);
    }

    @Reference
    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    @Override
    public DatagramProcessor getDatagramProcessor() {
        return this.datagramProcessor;
    }

    @Override
    public SOAPActionProcessor getSoapActionProcessor() {
        return this.soapActionProcessor;
    }

    @Override
    public GENAEventProcessor getGenaEventProcessor() {
        return this.genaEventProcessor;
    }

    @Override
    public StreamClient createStreamClient() {
        return this.transportConfiguration.createStreamClient(this.getSyncProtocolExecutorService(), this.createStreamClientConfiguration());
    }

    private StreamClientConfiguration createStreamClientConfiguration() {
        return new StreamClientConfigurationImpl(this.asyncExecutorService, this.timeoutSeconds, 5, this.retryAfterSeconds, this.retryIterations);
    }

    @Override
    public MulticastReceiver createMulticastReceiver(NetworkAddressFactory networkAddressFactory) {
        return new MulticastReceiverImpl(new MulticastReceiverConfigurationImpl(networkAddressFactory.getMulticastGroup(), networkAddressFactory.getMulticastPort()));
    }

    @Override
    public DatagramIO createDatagramIO(NetworkAddressFactory networkAddressFactory) {
        return new DatagramIOImpl(new DatagramIOConfigurationImpl());
    }

    @Override
    public StreamServer createStreamServer(NetworkAddressFactory networkAddressFactory) {
        if (this.httpService != null) {
            this.logger.debug("createStreamServer using OSGi HttpService");
            return new ServletStreamServerImpl(new ServletStreamServerConfigurationImpl(HttpServiceServletContainerAdapter.getInstance(this.httpService, this.context), this.httpProxyPort != -1 ? this.httpProxyPort : this.callbackURI.getBasePath().getPort()));
        }
        this.logger.debug("createStreamServer without OSGi HttpService");
        return this.transportConfiguration.createStreamServer(networkAddressFactory.getStreamListenPort());
    }

    @Override
    public ExecutorService getMulticastReceiverExecutor() {
        return this.getMainExecutorService();
    }

    @Override
    public ExecutorService getDatagramIOExecutor() {
        return this.getMainExecutorService();
    }

    @Override
    public ExecutorService getStreamServerExecutorService() {
        return this.getMainExecutorService();
    }

    @Override
    public DeviceDescriptorBinder getDeviceDescriptorBinderUDA10() {
        return this.deviceDescriptorBinderUDA10;
    }

    @Override
    public ServiceDescriptorBinder getServiceDescriptorBinderUDA10() {
        return this.serviceDescriptorBinderUDA10;
    }

    @Override
    public ServiceType[] getExclusiveServiceTypes() {
        return new ServiceType[0];
    }

    @Override
    public boolean isReceivedSubscriptionTimeoutIgnored() {
        return false;
    }

    @Override
    public UpnpHeaders getDescriptorRetrievalHeaders(RemoteDeviceIdentity identity) {
        return null;
    }

    @Override
    public UpnpHeaders getEventSubscriptionHeaders(RemoteService service) {
        return null;
    }

    @Override
    public int getRegistryMaintenanceIntervalMillis() {
        return 1000;
    }

    @Override
    public int getAliveIntervalMillis() {
        return 0;
    }

    @Override
    public Integer getRemoteDeviceMaxAgeSeconds() {
        return null;
    }

    @Override
    public ExecutorService getAsyncProtocolExecutor() {
        if (this.asyncThreadPool) {
            return this.asyncExecutorService;
        }
        return Executors.newCachedThreadPool();
    }

    @Override
    public ExecutorService getSyncProtocolExecutorService() {
        return this.getMainExecutorService();
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Executor getRegistryMaintainerExecutor() {
        return this.getMainExecutorService();
    }

    @Override
    public Executor getRegistryListenerExecutor() {
        return this.getMainExecutorService();
    }

    @Override
    public Executor getRemoteListenerExecutor() {
        return this.getRemoteExecutorService();
    }

    @Override
    public NetworkAddressFactory createNetworkAddressFactory() {
        return this.createNetworkAddressFactory(this.streamListenPort, this.multicastResponsePort);
    }

    @Override
    public void shutdown() {
        this.logger.debug("Shutting down executor services");
        this.shutdownExecutorServices();
        this.createExecutorServices();
    }

    protected void shutdownExecutorServices() {
        if (this.mainExecutorService != null) {
            this.mainExecutorService.shutdownNow();
        }
        if (this.asyncExecutorService != null) {
            this.asyncExecutorService.shutdownNow();
        }
        if (this.remoteExecutorService != null) {
            this.remoteExecutorService.shutdownNow();
        }
    }

    protected NetworkAddressFactory createNetworkAddressFactory(int streamListenPort, int multicastResponsePort) {
        return new NetworkAddressFactoryImpl(streamListenPort, multicastResponsePort, this.interfaces);
    }

    protected DatagramProcessor createDatagramProcessor() {
        return new DatagramProcessorImpl();
    }

    protected SOAPActionProcessor createSOAPActionProcessor() {
        return new SOAPActionProcessorImpl();
    }

    protected GENAEventProcessor createGENAEventProcessor() {
        return new GENAEventProcessorImpl();
    }

    protected DeviceDescriptorBinder createDeviceDescriptorBinderUDA10() {
        return new RecoveringUDA10DeviceDescriptorBinderImpl();
    }

    protected ServiceDescriptorBinder createServiceDescriptorBinderUDA10() {
        return new RecoveringUDA10ServiceDescriptorBinderSAXImpl();
    }

    protected Namespace createNamespace() {
        return this.callbackURI;
    }

    protected ExecutorService getRemoteExecutorService() {
        if (this.remoteThreadPool) {
            return this.remoteExecutorService;
        }
        return Executors.newCachedThreadPool();
    }

    protected ExecutorService getMainExecutorService() {
        if (this.mainThreadPool) {
            return this.mainExecutorService;
        }
        return Executors.newCachedThreadPool();
    }

    protected void createExecutorServices() {
        if (this.mainThreadPool) {
            this.logger.debug("Creating mainThreadPool");
            this.mainExecutorService = this.createMainExecutorService();
        } else {
            this.logger.debug("Skipping mainThreadPool creation.");
        }
        if (this.asyncThreadPool) {
            this.logger.debug("Creating asyncThreadPool");
            this.asyncExecutorService = this.createAsyncProtocolExecutorService();
        } else {
            this.logger.debug("Skipping asyncThreadPool creation.");
        }
        if (this.remoteThreadPool) {
            this.logger.debug("Creating remoteThreadPool");
            this.remoteExecutorService = this.createRemoteProtocolExecutorService();
        } else {
            this.logger.debug("Skipping remoteThreadPool creation.");
        }
    }

    protected ExecutorService createMainExecutorService() {
        return QueueingThreadPoolExecutor.createInstance("upnp-main", this.threadPoolSize);
    }

    protected ExecutorService createAsyncProtocolExecutorService() {
        return QueueingThreadPoolExecutor.createInstance("upnp-async", this.asyncThreadPoolSize);
    }

    protected ExecutorService createRemoteProtocolExecutorService() {
        return QueueingThreadPoolExecutor.createInstance("upnp-remote", this.remoteThreadPoolSize);
    }

    protected void setConfigValues(Map<String, Object> properties) {
        if (properties == null) {
            return;
        }
        Object prop = properties.get("threadPoolSize");
        if (prop instanceof String) {
            try {
                this.threadPoolSize = Integer.parseInt((String)prop);
                this.mainThreadPool = this.threadPoolSize != -1;
            }
            catch (NumberFormatException e) {
                this.logger.error("Invalid value '{}' for threadPoolSize - using default value '{}'", prop, (Object)this.threadPoolSize);
            }
        }
        this.logger.info("OSGiUpnpServiceConfiguration createConfiguration threadPoolSize = {} {}", (Object)this.threadPoolSize, (Object)this.mainThreadPool);
        prop = properties.get("asyncThreadPoolSize");
        if (prop instanceof String) {
            try {
                this.asyncThreadPoolSize = Integer.parseInt((String)prop);
                this.asyncThreadPool = this.asyncThreadPoolSize != -1;
            }
            catch (NumberFormatException e) {
                this.logger.error("Invalid value '{}' for asyncThreadPoolSize - using default value '{}'", prop, (Object)this.asyncThreadPoolSize);
            }
        }
        this.logger.info("OSGiUpnpServiceConfiguration createConfiguration asyncThreadPoolSize = {} {}", (Object)this.asyncThreadPoolSize, (Object)this.asyncThreadPool);
        prop = properties.get("multicastResponsePort");
        if (prop instanceof String) {
            try {
                this.multicastResponsePort = Integer.parseInt((String)prop);
            }
            catch (NumberFormatException e) {
                this.logger.error("Invalid value '{}' for multicastResponsePort - using default value '{}'", prop, (Object)this.multicastResponsePort);
            }
        } else if (prop instanceof Integer) {
            this.multicastResponsePort = (Integer)prop;
        }
        if ((prop = properties.get("streamListenPort")) instanceof String) {
            try {
                this.streamListenPort = Integer.parseInt((String)prop);
            }
            catch (NumberFormatException e) {
                this.logger.error("Invalid value '{}' for streamListenPort - using default value '{}'", prop, (Object)this.streamListenPort);
            }
        } else if (prop instanceof Integer) {
            this.streamListenPort = (Integer)prop;
        } else if (System.getProperty(OSGI_SERVICE_HTTP_PORT) != null) {
            try {
                this.streamListenPort = Integer.parseInt(System.getProperty(OSGI_SERVICE_HTTP_PORT));
            }
            catch (NumberFormatException e) {
                this.logger.debug("Invalid value '{}' for osgi.http.port - using default value '{}'", prop, (Object)this.streamListenPort);
            }
        }
        prop = properties.get("interfaces");
        if (prop instanceof String) {
            this.interfaces = (String)prop;
        }
        this.logger.info("OSGiUpnpServiceConfiguration interfaces = {}", (Object)this.interfaces);
        prop = properties.get("callbackURI");
        if (prop instanceof String) {
            try {
                this.callbackURI = new Namespace((String)prop);
            }
            catch (Exception e) {
                this.logger.error("Invalid value '{}' for callbackURI - using default value '{}'", prop, (Object)this.callbackURI);
            }
        }
        if ((prop = properties.get("httpProxyPort")) instanceof String) {
            try {
                this.httpProxyPort = Integer.parseInt((String)prop);
            }
            catch (NumberFormatException e) {
                this.logger.error("Invalid value '{}' for httpProxyPort - using default value '{}'", prop, (Object)this.httpProxyPort);
            }
        } else if (prop instanceof Integer) {
            this.httpProxyPort = (Integer)prop;
        }
        if ((prop = properties.get("retryAfterSeconds")) instanceof String) {
            try {
                this.retryAfterSeconds = Integer.valueOf((String)prop);
            }
            catch (NumberFormatException e) {
                this.logger.error("Invalid value '{}' for retryAfterSeconds - using default value", prop);
            }
        } else if (prop instanceof Integer) {
            this.retryAfterSeconds = (Integer)prop;
        }
        this.logger.info("OSGiUpnpServiceConfiguration retryAfterSeconds = {}", (Object)this.retryAfterSeconds);
        prop = properties.get("retryIterations");
        if (prop instanceof String) {
            try {
                this.retryIterations = Integer.valueOf((String)prop);
            }
            catch (NumberFormatException e) {
                this.logger.error("Invalid value '{}' for retryIterations - using default value", prop);
            }
        } else if (prop instanceof Integer) {
            this.retryIterations = (Integer)prop;
        }
        this.logger.info("OSGiUpnpServiceConfiguration retryIterations = {}", (Object)this.retryIterations);
        prop = properties.get("timeoutSeconds");
        if (prop instanceof String) {
            try {
                this.timeoutSeconds = Integer.valueOf((String)prop);
            }
            catch (NumberFormatException e) {
                this.logger.error("Invalid value '{}' for timeoutSeconds - using default value", prop);
            }
        } else if (prop instanceof Integer) {
            this.timeoutSeconds = (Integer)prop;
        }
        this.logger.info("OSGiUpnpServiceConfiguration timeoutSeconds = {}", (Object)this.timeoutSeconds);
        if (!this.mainThreadPool || !this.asyncThreadPool) {
            this.remoteThreadPool = false;
            this.remoteThreadPoolSize = -1;
        } else {
            this.remoteThreadPool = true;
            this.remoteThreadPoolSize = this.threadPoolSize + this.asyncThreadPoolSize;
        }
    }
}

