/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.db;

import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.Olap4jDataSource;
import ca.sqlpower.sql.SpecificDataSourceCollection;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.swingui.JDBCDataSourcePanel;
import ca.sqlpower.swingui.db.DataSourceDialogFactory;
import ca.sqlpower.swingui.db.Olap4jConnectionPanel;
import java.awt.Window;
import java.util.concurrent.Callable;
import javax.swing.JDialog;

public class DefaultDataSourceDialogFactory
implements DataSourceDialogFactory {
    @Override
    public JDialog showDialog(Window parentWindow, JDBCDataSource ds, Runnable onAccept) {
        JDBCDataSourcePanel dataSourcePanel = new JDBCDataSourcePanel(ds);
        return this.createDataSourceDialog(parentWindow, onAccept, dataSourcePanel);
    }

    private JDialog createDataSourceDialog(Window parentWindow, final Runnable onAccept, final DataEntryPanel dataSourcePanel) {
        Callable<Boolean> okCall = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                if (dataSourcePanel.applyChanges()) {
                    if (onAccept != null) {
                        onAccept.run();
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        Callable<Boolean> cancelCall = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                dataSourcePanel.discardChanges();
                return Boolean.TRUE;
            }
        };
        JDialog d = DataEntryPanelBuilder.createDataEntryPanelDialog(dataSourcePanel, parentWindow, "Data Source Properties", "OK", okCall, cancelCall);
        d.pack();
        d.setLocationRelativeTo(parentWindow);
        d.setVisible(true);
        return d;
    }

    @Override
    public JDialog showDialog(Window parentWindow, Olap4jDataSource dataSource, DataSourceCollection<? super JDBCDataSource> dsCollection, Runnable onAccept) {
        Olap4jConnectionPanel dataSourcePanel = new Olap4jConnectionPanel(dataSource, new SpecificDataSourceCollection<JDBCDataSource>(dsCollection, JDBCDataSource.class));
        return this.createDataSourceDialog(parentWindow, onAccept, dataSourcePanel);
    }
}

