atf_test_case noflags
noflags_head() {
    atf_set "descr" "Tests fsu_rm with no flags"
}
noflags_body() {
    if [ -z "$FSU_DIR" -o -z "$FSU_IMG" ]; then
	atf_fail "variables: \$FSU_DIR and \$FSU_IMG should be set";
    fi
    ${FSU_DIR}/src/fsu_touch/fsu_touch ${FSU_IMG} file || \
	atf_fail "Could not create file"

    atf_check '${FSU_DIR}/src/fsu_rm/fsu_rm ${FSU_IMG} file' 0 null ignore
    atf_check '${FSU_DIR}/src/fsu_ls/fsu_ls ${FSU_IMG} file' 1 null ignore
}

atf_test_case Rflag
Rflag_head() {
    atf_set "descr" "Tests fsu_rm with R flag"
}
Rflag_body() {
    if [ -z "$FSU_DIR" -o -z "$FSU_IMG" ]; then
	atf_fail "variables: \$FSU_DIR and \$FSU_IMG should be set";
    fi
    ${FSU_DIR}/src/fsu_mkdir/fsu_mkdir ${FSU_IMG} dir || \
	atf_fail "Could not create dir"
    ${FSU_DIR}/src/fsu_touch/fsu_touch ${FSU_IMG} dir/a || \
	atf_fail "Could not create file"
    ${FSU_DIR}/src/fsu_touch/fsu_touch ${FSU_IMG} dir/b || \
	atf_fail "Could not create file"

    atf_check '${FSU_DIR}/src/fsu_rm/fsu_rm ${FSU_IMG} -R dir' 0 null ignore
    atf_check '${FSU_DIR}/src/fsu_ls/fsu_ls ${FSU_IMG} dir' 1 null ignore
}

atf_init_test_cases() {
    atf_add_test_case noflags
    atf_add_test_case Rflag
}
