atf_test_case noflags
noflags_head() {
    atf_set "descr" "Tests fsu_mkdir with no flags"
}
noflags_body() {
    if [ -z "$FSU_DIR" -o -z "$FSU_IMG" ]; then
	atf_fail "variables: \$FSU_DIR and \$FSU_IMG should be set";
    fi
    ${FSU_DIR}/src/fsu_mkdir/fsu_mkdir ${FSU_IMG} dir

    atf_check '${FSU_DIR}/src/fsu_ls/fsu_ls ${FSU_IMG} dir' 0 ignore ignore
}
noflags_cleanup() {
    ${FSU_DIR}/src/fsu_rm/fsu_rm ${FSU_IMG} -r dir
}

atf_test_case pflag
pflag_head() {
    atf_set "descr" "Tests fsu_mkdir with p flag"
}
pflag_body() {
    if [ -z "$FSU_DIR" -o -z "$FSU_IMG" ]; then
	atf_fail "variables: \$FSU_DIR and \$FSU_IMG should be set";
    fi
    ${FSU_DIR}/src/fsu_mkdir/fsu_mkdir ${FSU_IMG} -p dir/a/b/c

    atf_check '${FSU_DIR}/src/fsu_ls/fsu_ls ${FSU_IMG} dir/a/b/c' \
	0 ignore ignore
}
pflag_cleanup() {
    ${FSU_DIR}/src/fsu_rm/fsu_rm ${FSU_IMG} -r dir
}

atf_init_test_cases() {
    atf_add_test_case noflags
    atf_add_test_case pflag
}
