/* $Id: main.c,v 1.7 2008/09/23 16:20:42 stacktic Exp $ */

/*
 * Copyright (c) 2008 Arnaud Ysmal.  All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <err.h>
#include <errno.h>

#include <rump/ukfs.h>

#include <fsu_mount.h>

#include "fsu_mv.h"

static void usage(void);

int
main(int argc, char *argv[])
{
	struct ukfs *fs = NULL;
	int cur_arg, flags, rv;

	if (argc < 2)
		usage();

	fs = fsu_mount(&argc, &argv, NULL, NULL);
	if (fs == NULL) {
		warn("fsu_mount");
		usage();
		/* NOTREACHED */
	}

	flags = fsu_mv_parse_arg(&argc, &argv);
	if (flags == -1 || argc < 2)
		usage();

	for (rv = 0, cur_arg = 2; cur_arg < argc-1; cur_arg++)
		rv |= fsu_mv(fs, argv[cur_arg], argv[argc-1], flags);

	ukfs_release(fs, 0);
	return rv;
}

static void
usage(void)
{

	fprintf(stderr,
   "usage: \t%s [MNT_OPTIONS] [fstype] fsdevice [-iv] source target\n"
	  "\t%s [MNT_OPTIONS] [fstype] fsdevice [-iv] source ... directory\n",
		getprogname(), getprogname());
	exit(EXIT_FAILURE);
}
