/*	$Id: fsu_mkfifo.c,v 1.7 2008/10/31 20:30:58 stacktic Exp $	*/
/* from src/usr.bin/mkfifo/mkfifo.c */
/*	$NetBSD: mkfifo.c,v 1.12 2008/07/21 14:19:24 lukem Exp $	*/

/*
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>
#ifndef lint
__COPYRIGHT("@(#) Copyright (c) 1990, 1993\
 The Regents of the University of California.  All rights reserved.");
#endif /* not lint */

#ifndef lint
#if 0
static char sccsid[] = "@(#)mkfifo.c	8.2 (Berkeley) 1/5/94";
#endif
__RCSID("$NetBSD: mkfifo.c,v 1.12 2008/07/21 14:19:24 lukem Exp $");
#endif /* not lint */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <err.h>

#if defined(FSU_CONSOLE) && !defined(USE_UKFS)
#define USE_UKFS
#endif

#ifdef USE_UKFS
#include <rump/ukfs.h>

#include <fsu_mount.h>

#define mkfifo(a, b) ukfs_mkfifo(ukfs, a, b)
#ifndef FSU_CONSOLE
static struct ukfs *ukfs;

static void	unmount_ukfs(void);
int		main __P((int, char **));

#else /* !FSU_CONSOLE */

#define main(a, b) fsu_mkfifo_main(struct ukfs *ukfs, a, b)

int fsu_mkfifo_main(struct ukfs *, int, char *[]);

static char *progname;
#endif /* !FSU_CONSOLE */

#endif /* USE_UKFS */

static void usage __P((void));

int
main(int argc, char *argv[])
{
	int ch, exitval;
	void *set;
	mode_t mode;

#ifdef FSU_CONSOLE
	progname = argv[0];
#endif
	setprogname(argv[0]);
	setlocale (LC_ALL, "");

#if defined(USE_UKFS) && !defined(FSU_CONSOLE)
	if (argc < 2)
		usage();

	ukfs = fsu_mount(&argc, &argv, NULL, NULL);
	if (ukfs == NULL) {
		warn("fsu_mount");
		usage();
		/* NOTREACHED */
	}
	atexit(unmount_ukfs);
#endif

	/* The default mode is the value of the bitwise inclusive or of
	   S_IRUSR, S_IWUSR, S_IRGRP, S_IWGRP, S_IROTH, and S_IWOTH
	   modified by the file creation mask */
	umask((mode = umask(0)));
	mode = 0666 & ~mode;

	while ((ch = getopt(argc, argv, "m:")) != -1)
		switch(ch) {
		case 'm':
			if (!(set = setmode(optarg))) {
#ifdef FSU_CONSOLE
				warn("Cannot set file mode `%s'", optarg);
				return 1;
#else
				err(1, "Cannot set file mode `%s'", optarg);
				/* NOTREACHED */
#endif
			}
			/* In symbolic mode strings, the + and - operators are
			   interpreted relative to an assumed initial mode of
			   a=rw. */
			mode = getmode(set, 0666);
			free(set);
			break;
		case '?':
		default:
			usage();
			return EXIT_FAILURE;
		}
	argc -= optind;
	argv += optind;
	if (argv[0] == NULL) {
		usage();
		return EXIT_FAILURE;
	}

	for (exitval = 0; *argv; ++argv) {
		if (mkfifo(*argv, mode) < 0) {
			warn("%s", *argv);
			exitval = 1;
		}
	}
#ifdef FSU_CONSOLE
	return exitval;
#else
	exit(exitval);
#endif
}

void
usage()
{

#if defined(USE_UKFS) && !defined(FSU_CONSOLE)
	(void)fprintf(stderr, "usage: %s %s [-m mode] fifoname ...\n",
		      getprogname(), fsu_mount_usage());
#else
	(void)fprintf(stderr, "usage: %s [-m mode] fifoname ...\n",
#ifdef FSU_CONSOLE
		      progname);
#else
	              getprogname());
#endif /* FSU_CONSOLE */
#endif /* USE_UKFS && !FSU_CONSOLE */

#ifndef FSU_CONSOLE
	exit(1);
#endif
}

#if defined(USE_UKFS) && !defined(FSU_CONSOLE)
void
unmount_ukfs(void)
{
	
	ukfs_release(ukfs, 0);
}
#endif
