/* $NetBSD: rump_syscalls.c,v 1.87 2013/05/10 16:36:25 christos Exp $ */

/*
 * System call vector and marshalling for rump.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.262 2013/03/29 01:08:17 christos Exp
 */

#ifdef RUMP_CLIENT
#include "rumpuser_port.h"
#endif /* RUMP_CLIENT */

#include <sys/param.h>

#ifdef __NetBSD__
#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: rump_syscalls.c,v 1.87 2013/05/10 16:36:25 christos Exp $");

#include <sys/fstypes.h>
#include <sys/proc.h>
#endif /* __NetBSD__ */

#ifdef RUMP_CLIENT
#include <errno.h>
#include <stdint.h>
#include <stdlib.h>

#include <srcsys/syscall.h>
#include <srcsys/syscallargs.h>

#include <rump/rumpclient.h>

#define rsys_syscall(num, data, dlen, retval)	\
    rumpclient_syscall(num, data, dlen, retval)
#define rsys_seterrno(error) errno = error
#define rsys_alias(a,b)
#else
#include <sys/syscall.h>
#include <sys/syscallargs.h>

#include <sys/syscallvar.h>

#include <rump/rumpuser.h>
#include "rump_private.h"

static int
rsys_syscall(int num, void *data, size_t dlen, register_t *retval)
{
	struct proc *p;
	struct emul *e;
	struct sysent *callp;
	int rv;

	rump_schedule();
	p = curproc;
	e = p->p_emul;
#ifndef __HAVE_MINIMAL_EMUL
	KASSERT(num > 0 && num < e->e_nsysent);
#endif
	callp = e->e_sysent + num;

	rv = sy_call(callp, curlwp, data, retval);
	rump_unschedule();

	return rv;
}

#define rsys_seterrno(error) rumpuser_seterrno(error)
#define rsys_alias(a,b) __weak_alias(a,b);
#endif

#if	BYTE_ORDER == BIG_ENDIAN
#define SPARG(p,k)	((p)->k.be.datum)
#else /* LITTLE_ENDIAN, I hope dearly */
#define SPARG(p,k)	((p)->k.le.datum)
#endif

#ifndef RUMP_CLIENT
int rump_enosys(void);
int
rump_enosys()
{

	return ENOSYS;
}
#endif

ssize_t rump___sysimpl_read(int, void *, size_t);
ssize_t
rump___sysimpl_read(int fd, void * buf, size_t nbyte)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_read_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, nbyte) = nbyte;

	error = rsys_syscall(SYS_read, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_read,rump_enosys)

ssize_t rump___sysimpl_write(int, const void *, size_t);
ssize_t
rump___sysimpl_write(int fd, const void * buf, size_t nbyte)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_write_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, nbyte) = nbyte;

	error = rsys_syscall(SYS_write, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_write,rump_enosys)

int rump___sysimpl_open(const char *, int, mode_t);
int
rump___sysimpl_open(const char * path, int flags, mode_t mode)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_open_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_open, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_open,rump_enosys)

int rump___sysimpl_close(int);
int
rump___sysimpl_close(int fd)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_close_args callarg;

	SPARG(&callarg, fd) = fd;

	error = rsys_syscall(SYS_close, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_close,rump_enosys)

int rump___sysimpl_link(const char *, const char *);
int
rump___sysimpl_link(const char * path, const char * link)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_link_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, link) = link;

	error = rsys_syscall(SYS_link, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_link,rump_enosys)

int rump___sysimpl_unlink(const char *);
int
rump___sysimpl_unlink(const char * path)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_unlink_args callarg;

	SPARG(&callarg, path) = path;

	error = rsys_syscall(SYS_unlink, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_unlink,rump_enosys)

int rump___sysimpl_chdir(const char *);
int
rump___sysimpl_chdir(const char * path)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_chdir_args callarg;

	SPARG(&callarg, path) = path;

	error = rsys_syscall(SYS_chdir, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_chdir,rump_enosys)

int rump___sysimpl_fchdir(int);
int
rump___sysimpl_fchdir(int fd)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fchdir_args callarg;

	SPARG(&callarg, fd) = fd;

	error = rsys_syscall(SYS_fchdir, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fchdir,rump_enosys)

int rump___sysimpl_mknod(const char *, mode_t, uint32_t);
int
rump___sysimpl_mknod(const char * path, mode_t mode, uint32_t dev)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct compat_50_sys_mknod_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;
	SPARG(&callarg, dev) = dev;

	error = rsys_syscall(SYS_compat_50_mknod, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(compat_50_sys_mknod,rump_enosys)

int rump___sysimpl_chmod(const char *, mode_t);
int
rump___sysimpl_chmod(const char * path, mode_t mode)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_chmod_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_chmod, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_chmod,rump_enosys)

int rump___sysimpl_chown(const char *, uid_t, gid_t);
int
rump___sysimpl_chown(const char * path, uid_t uid, gid_t gid)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_chown_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, uid) = uid;
	SPARG(&callarg, gid) = gid;

	error = rsys_syscall(SYS_chown, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_chown,rump_enosys)

pid_t rump___sysimpl_getpid(void);
pid_t
rump___sysimpl_getpid(void )
{
	register_t retval[2] = {0, 0};
	pid_t rv = -1;

	rsys_syscall(SYS_getpid, NULL, 0, retval);
	if (sizeof(pid_t) > sizeof(register_t))
		rv = *(pid_t *)retval;
	else
		rv = *retval;
	return rv;
}
rsys_alias(sys_getpid_with_ppid,rump_enosys)

int rump___sysimpl_unmount(const char *, int);
int
rump___sysimpl_unmount(const char * path, int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_unmount_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_unmount, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_unmount,rump_enosys)

int rump___sysimpl_setuid(uid_t);
int
rump___sysimpl_setuid(uid_t uid)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_setuid_args callarg;

	SPARG(&callarg, uid) = uid;

	error = rsys_syscall(SYS_setuid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_setuid,rump_enosys)

uid_t rump___sysimpl_getuid(void);
uid_t
rump___sysimpl_getuid(void )
{
	register_t retval[2] = {0, 0};
	uid_t rv = -1;

	rsys_syscall(SYS_getuid, NULL, 0, retval);
	if (sizeof(uid_t) > sizeof(register_t))
		rv = *(uid_t *)retval;
	else
		rv = *retval;
	return rv;
}
rsys_alias(sys_getuid_with_euid,rump_enosys)

uid_t rump___sysimpl_geteuid(void);
uid_t
rump___sysimpl_geteuid(void )
{
	register_t retval[2] = {0, 0};
	uid_t rv = -1;

	rsys_syscall(SYS_geteuid, NULL, 0, retval);
	if (sizeof(uid_t) > sizeof(register_t))
		rv = *(uid_t *)retval;
	else
		rv = *retval;
	return rv;
}
rsys_alias(sys_geteuid,rump_enosys)

ssize_t rump___sysimpl_recvmsg(int, struct msghdr *, int);
ssize_t
rump___sysimpl_recvmsg(int s, struct msghdr * msg, int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_recvmsg_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, msg) = msg;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_recvmsg, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_recvmsg,rump_enosys)

ssize_t rump___sysimpl_sendmsg(int, const struct msghdr *, int);
ssize_t
rump___sysimpl_sendmsg(int s, const struct msghdr * msg, int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_sendmsg_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, msg) = msg;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_sendmsg, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_sendmsg,rump_enosys)

ssize_t rump___sysimpl_recvfrom(int, void *, size_t, int, struct sockaddr *, socklen_t *);
ssize_t
rump___sysimpl_recvfrom(int s, void * buf, size_t len, int flags, struct sockaddr * from, socklen_t * fromlenaddr)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_recvfrom_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, len) = len;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, from) = from;
	SPARG(&callarg, fromlenaddr) = fromlenaddr;

	error = rsys_syscall(SYS_recvfrom, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_recvfrom,rump_enosys)

int rump___sysimpl_accept(int, struct sockaddr *, socklen_t *);
int
rump___sysimpl_accept(int s, struct sockaddr * name, socklen_t * anamelen)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_accept_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, anamelen) = anamelen;

	error = rsys_syscall(SYS_accept, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_accept,rump_enosys)

int rump___sysimpl_getpeername(int, struct sockaddr *, socklen_t *);
int
rump___sysimpl_getpeername(int fdes, struct sockaddr * asa, socklen_t * alen)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_getpeername_args callarg;

	SPARG(&callarg, fdes) = fdes;
	SPARG(&callarg, asa) = asa;
	SPARG(&callarg, alen) = alen;

	error = rsys_syscall(SYS_getpeername, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_getpeername,rump_enosys)

int rump___sysimpl_getsockname(int, struct sockaddr *, socklen_t *);
int
rump___sysimpl_getsockname(int fdes, struct sockaddr * asa, socklen_t * alen)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_getsockname_args callarg;

	SPARG(&callarg, fdes) = fdes;
	SPARG(&callarg, asa) = asa;
	SPARG(&callarg, alen) = alen;

	error = rsys_syscall(SYS_getsockname, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_getsockname,rump_enosys)

int rump___sysimpl_access(const char *, int);
int
rump___sysimpl_access(const char * path, int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_access_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_access, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_access,rump_enosys)

int rump___sysimpl_chflags(const char *, u_long);
int
rump___sysimpl_chflags(const char * path, u_long flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_chflags_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_chflags, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_chflags,rump_enosys)

int rump___sysimpl_fchflags(int, u_long);
int
rump___sysimpl_fchflags(int fd, u_long flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fchflags_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_fchflags, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fchflags,rump_enosys)

void rump___sysimpl_sync(void);
void
rump___sysimpl_sync(void )
{
	register_t retval[2] = {0, 0};

	rsys_syscall(SYS_sync, NULL, 0, retval);
}
rsys_alias(sys_sync,rump_enosys)

pid_t rump___sysimpl_getppid(void);
pid_t
rump___sysimpl_getppid(void )
{
	register_t retval[2] = {0, 0};
	pid_t rv = -1;

	rsys_syscall(SYS_getppid, NULL, 0, retval);
	if (sizeof(pid_t) > sizeof(register_t))
		rv = *(pid_t *)retval;
	else
		rv = *retval;
	return rv;
}
rsys_alias(sys_getppid,rump_enosys)

int rump___sysimpl_dup(int);
int
rump___sysimpl_dup(int fd)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_dup_args callarg;

	SPARG(&callarg, fd) = fd;

	error = rsys_syscall(SYS_dup, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_dup,rump_enosys)

gid_t rump___sysimpl_getegid(void);
gid_t
rump___sysimpl_getegid(void )
{
	register_t retval[2] = {0, 0};
	gid_t rv = -1;

	rsys_syscall(SYS_getegid, NULL, 0, retval);
	if (sizeof(gid_t) > sizeof(register_t))
		rv = *(gid_t *)retval;
	else
		rv = *retval;
	return rv;
}
rsys_alias(sys_getegid,rump_enosys)

gid_t rump___sysimpl_getgid(void);
gid_t
rump___sysimpl_getgid(void )
{
	register_t retval[2] = {0, 0};
	gid_t rv = -1;

	rsys_syscall(SYS_getgid, NULL, 0, retval);
	if (sizeof(gid_t) > sizeof(register_t))
		rv = *(gid_t *)retval;
	else
		rv = *retval;
	return rv;
}
rsys_alias(sys_getgid_with_egid,rump_enosys)

int rump___sysimpl___getlogin(char *, size_t);
int
rump___sysimpl___getlogin(char * namebuf, size_t namelen)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___getlogin_args callarg;

	SPARG(&callarg, namebuf) = namebuf;
	SPARG(&callarg, namelen) = namelen;

	error = rsys_syscall(SYS___getlogin, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___getlogin,rump_enosys)

int rump___sysimpl___setlogin(const char *);
int
rump___sysimpl___setlogin(const char * namebuf)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___setlogin_args callarg;

	SPARG(&callarg, namebuf) = namebuf;

	error = rsys_syscall(SYS___setlogin, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___setlogin,rump_enosys)

int rump___sysimpl_ioctl(int, u_long, void *);
int
rump___sysimpl_ioctl(int fd, u_long com, void * data)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_ioctl_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, com) = com;
	SPARG(&callarg, data) = data;

	error = rsys_syscall(SYS_ioctl, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_ioctl,rump_enosys)

int rump___sysimpl_revoke(const char *);
int
rump___sysimpl_revoke(const char * path)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_revoke_args callarg;

	SPARG(&callarg, path) = path;

	error = rsys_syscall(SYS_revoke, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_revoke,rump_enosys)

int rump___sysimpl_symlink(const char *, const char *);
int
rump___sysimpl_symlink(const char * path, const char * link)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_symlink_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, link) = link;

	error = rsys_syscall(SYS_symlink, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_symlink,rump_enosys)

ssize_t rump___sysimpl_readlink(const char *, char *, size_t);
ssize_t
rump___sysimpl_readlink(const char * path, char * buf, size_t count)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_readlink_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, count) = count;

	error = rsys_syscall(SYS_readlink, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_readlink,rump_enosys)

mode_t rump___sysimpl_umask(mode_t);
mode_t
rump___sysimpl_umask(mode_t newmask)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	mode_t rv = -1;
	struct sys_umask_args callarg;

	SPARG(&callarg, newmask) = newmask;

	error = rsys_syscall(SYS_umask, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(mode_t) > sizeof(register_t))
			rv = *(mode_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_umask,rump_enosys)

int rump___sysimpl_chroot(const char *);
int
rump___sysimpl_chroot(const char * path)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_chroot_args callarg;

	SPARG(&callarg, path) = path;

	error = rsys_syscall(SYS_chroot, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_chroot,rump_enosys)

int rump___sysimpl_getgroups(int, gid_t *);
int
rump___sysimpl_getgroups(int gidsetsize, gid_t * gidset)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_getgroups_args callarg;

	SPARG(&callarg, gidsetsize) = gidsetsize;
	SPARG(&callarg, gidset) = gidset;

	error = rsys_syscall(SYS_getgroups, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_getgroups,rump_enosys)

int rump___sysimpl_setgroups(int, const gid_t *);
int
rump___sysimpl_setgroups(int gidsetsize, const gid_t * gidset)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_setgroups_args callarg;

	SPARG(&callarg, gidsetsize) = gidsetsize;
	SPARG(&callarg, gidset) = gidset;

	error = rsys_syscall(SYS_setgroups, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_setgroups,rump_enosys)

int rump___sysimpl_getpgrp(void);
int
rump___sysimpl_getpgrp(void )
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;

	error = rsys_syscall(SYS_getpgrp, NULL, 0, retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_getpgrp,rump_enosys)

int rump___sysimpl_setpgid(pid_t, pid_t);
int
rump___sysimpl_setpgid(pid_t pid, pid_t pgid)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_setpgid_args callarg;

	SPARG(&callarg, pid) = pid;
	SPARG(&callarg, pgid) = pgid;

	error = rsys_syscall(SYS_setpgid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_setpgid,rump_enosys)

int rump___sysimpl_dup2(int, int);
int
rump___sysimpl_dup2(int from, int to)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_dup2_args callarg;

	SPARG(&callarg, from) = from;
	SPARG(&callarg, to) = to;

	error = rsys_syscall(SYS_dup2, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_dup2,rump_enosys)

int rump___sysimpl_fcntl(int, int, void *);
int
rump___sysimpl_fcntl(int fd, int cmd, void * arg)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fcntl_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, cmd) = cmd;
	SPARG(&callarg, arg) = arg;

	error = rsys_syscall(SYS_fcntl, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fcntl,rump_enosys)

int rump___sysimpl_select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
int
rump___sysimpl_select(int nd, fd_set * in, fd_set * ou, fd_set * ex, struct timeval * tv)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct compat_50_sys_select_args callarg;

	SPARG(&callarg, nd) = nd;
	SPARG(&callarg, in) = in;
	SPARG(&callarg, ou) = ou;
	SPARG(&callarg, ex) = ex;
	SPARG(&callarg, tv) = (struct timeval50 *)tv;

	error = rsys_syscall(SYS_compat_50_select, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(compat_50_sys_select,rump_enosys)

int rump___sysimpl_fsync(int);
int
rump___sysimpl_fsync(int fd)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fsync_args callarg;

	SPARG(&callarg, fd) = fd;

	error = rsys_syscall(SYS_fsync, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fsync,rump_enosys)

int rump___sysimpl_connect(int, const struct sockaddr *, socklen_t);
int
rump___sysimpl_connect(int s, const struct sockaddr * name, socklen_t namelen)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_connect_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, namelen) = namelen;

	error = rsys_syscall(SYS_connect, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_connect,rump_enosys)

int rump___sysimpl_bind(int, const struct sockaddr *, socklen_t);
int
rump___sysimpl_bind(int s, const struct sockaddr * name, socklen_t namelen)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_bind_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, namelen) = namelen;

	error = rsys_syscall(SYS_bind, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_bind,rump_enosys)

int rump___sysimpl_setsockopt(int, int, int, const void *, socklen_t);
int
rump___sysimpl_setsockopt(int s, int level, int name, const void * val, socklen_t valsize)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_setsockopt_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, level) = level;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, val) = val;
	SPARG(&callarg, valsize) = valsize;

	error = rsys_syscall(SYS_setsockopt, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_setsockopt,rump_enosys)

int rump___sysimpl_listen(int, int);
int
rump___sysimpl_listen(int s, int backlog)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_listen_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, backlog) = backlog;

	error = rsys_syscall(SYS_listen, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_listen,rump_enosys)

int rump___sysimpl_getsockopt(int, int, int, void *, socklen_t *);
int
rump___sysimpl_getsockopt(int s, int level, int name, void * val, socklen_t * avalsize)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_getsockopt_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, level) = level;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, val) = val;
	SPARG(&callarg, avalsize) = avalsize;

	error = rsys_syscall(SYS_getsockopt, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_getsockopt,rump_enosys)

ssize_t rump___sysimpl_readv(int, const struct iovec *, int);
ssize_t
rump___sysimpl_readv(int fd, const struct iovec * iovp, int iovcnt)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_readv_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, iovp) = iovp;
	SPARG(&callarg, iovcnt) = iovcnt;

	error = rsys_syscall(SYS_readv, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_readv,rump_enosys)

ssize_t rump___sysimpl_writev(int, const struct iovec *, int);
ssize_t
rump___sysimpl_writev(int fd, const struct iovec * iovp, int iovcnt)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_writev_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, iovp) = iovp;
	SPARG(&callarg, iovcnt) = iovcnt;

	error = rsys_syscall(SYS_writev, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_writev,rump_enosys)

int rump___sysimpl_fchown(int, uid_t, gid_t);
int
rump___sysimpl_fchown(int fd, uid_t uid, gid_t gid)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fchown_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, uid) = uid;
	SPARG(&callarg, gid) = gid;

	error = rsys_syscall(SYS_fchown, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fchown,rump_enosys)

int rump___sysimpl_fchmod(int, mode_t);
int
rump___sysimpl_fchmod(int fd, mode_t mode)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fchmod_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_fchmod, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fchmod,rump_enosys)

int rump___sysimpl_setreuid(uid_t, uid_t);
int
rump___sysimpl_setreuid(uid_t ruid, uid_t euid)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_setreuid_args callarg;

	SPARG(&callarg, ruid) = ruid;
	SPARG(&callarg, euid) = euid;

	error = rsys_syscall(SYS_setreuid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_setreuid,rump_enosys)

int rump___sysimpl_setregid(gid_t, gid_t);
int
rump___sysimpl_setregid(gid_t rgid, gid_t egid)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_setregid_args callarg;

	SPARG(&callarg, rgid) = rgid;
	SPARG(&callarg, egid) = egid;

	error = rsys_syscall(SYS_setregid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_setregid,rump_enosys)

int rump___sysimpl_rename(const char *, const char *);
int
rump___sysimpl_rename(const char * from, const char * to)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_rename_args callarg;

	SPARG(&callarg, from) = from;
	SPARG(&callarg, to) = to;

	error = rsys_syscall(SYS_rename, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_rename,rump_enosys)

int rump___sysimpl_flock(int, int);
int
rump___sysimpl_flock(int fd, int how)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_flock_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, how) = how;

	error = rsys_syscall(SYS_flock, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_flock,rump_enosys)

int rump___sysimpl_mkfifo(const char *, mode_t);
int
rump___sysimpl_mkfifo(const char * path, mode_t mode)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_mkfifo_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_mkfifo, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_mkfifo,rump_enosys)

ssize_t rump___sysimpl_sendto(int, const void *, size_t, int, const struct sockaddr *, socklen_t);
ssize_t
rump___sysimpl_sendto(int s, const void * buf, size_t len, int flags, const struct sockaddr * to, socklen_t tolen)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_sendto_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, len) = len;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, to) = to;
	SPARG(&callarg, tolen) = tolen;

	error = rsys_syscall(SYS_sendto, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_sendto,rump_enosys)

int rump___sysimpl_shutdown(int, int);
int
rump___sysimpl_shutdown(int s, int how)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_shutdown_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, how) = how;

	error = rsys_syscall(SYS_shutdown, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_shutdown,rump_enosys)

int rump___sysimpl_socketpair(int, int, int, int *);
int
rump___sysimpl_socketpair(int domain, int type, int protocol, int * rsv)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_socketpair_args callarg;

	SPARG(&callarg, domain) = domain;
	SPARG(&callarg, type) = type;
	SPARG(&callarg, protocol) = protocol;
	SPARG(&callarg, rsv) = rsv;

	error = rsys_syscall(SYS_socketpair, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_socketpair,rump_enosys)

int rump___sysimpl_mkdir(const char *, mode_t);
int
rump___sysimpl_mkdir(const char * path, mode_t mode)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_mkdir_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_mkdir, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_mkdir,rump_enosys)

int rump___sysimpl_rmdir(const char *);
int
rump___sysimpl_rmdir(const char * path)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_rmdir_args callarg;

	SPARG(&callarg, path) = path;

	error = rsys_syscall(SYS_rmdir, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_rmdir,rump_enosys)

int rump___sysimpl_utimes(const char *, const struct timeval *);
int
rump___sysimpl_utimes(const char * path, const struct timeval * tptr)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct compat_50_sys_utimes_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, tptr) = (const struct timeval50 *)tptr;

	error = rsys_syscall(SYS_compat_50_utimes, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(compat_50_sys_utimes,rump_enosys)

int rump___sysimpl_setsid(void);
int
rump___sysimpl_setsid(void )
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;

	error = rsys_syscall(SYS_setsid, NULL, 0, retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_setsid,rump_enosys)

int rump___sysimpl_nfssvc(int, void *);
int
rump___sysimpl_nfssvc(int flag, void * argp)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_nfssvc_args callarg;

	SPARG(&callarg, flag) = flag;
	SPARG(&callarg, argp) = argp;

	error = rsys_syscall(SYS_nfssvc, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_nfssvc,rump_enosys)

ssize_t rump___sysimpl_pread(int, void *, size_t, off_t);
ssize_t
rump___sysimpl_pread(int fd, void * buf, size_t nbyte, off_t offset)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_pread_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, nbyte) = nbyte;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, offset) = offset;

	error = rsys_syscall(SYS_pread, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_pread,rump_enosys)

ssize_t rump___sysimpl_pwrite(int, const void *, size_t, off_t);
ssize_t
rump___sysimpl_pwrite(int fd, const void * buf, size_t nbyte, off_t offset)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_pwrite_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, nbyte) = nbyte;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, offset) = offset;

	error = rsys_syscall(SYS_pwrite, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_pwrite,rump_enosys)

int rump___sysimpl_setgid(gid_t);
int
rump___sysimpl_setgid(gid_t gid)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_setgid_args callarg;

	SPARG(&callarg, gid) = gid;

	error = rsys_syscall(SYS_setgid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_setgid,rump_enosys)

int rump___sysimpl_setegid(gid_t);
int
rump___sysimpl_setegid(gid_t egid)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_setegid_args callarg;

	SPARG(&callarg, egid) = egid;

	error = rsys_syscall(SYS_setegid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_setegid,rump_enosys)

int rump___sysimpl_seteuid(uid_t);
int
rump___sysimpl_seteuid(uid_t euid)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_seteuid_args callarg;

	SPARG(&callarg, euid) = euid;

	error = rsys_syscall(SYS_seteuid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_seteuid,rump_enosys)

long rump___sysimpl_pathconf(const char *, int);
long
rump___sysimpl_pathconf(const char * path, int name)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	long rv = -1;
	struct sys_pathconf_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;

	error = rsys_syscall(SYS_pathconf, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(long) > sizeof(register_t))
			rv = *(long *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_pathconf,rump_enosys)

long rump___sysimpl_fpathconf(int, int);
long
rump___sysimpl_fpathconf(int fd, int name)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	long rv = -1;
	struct sys_fpathconf_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, name) = name;

	error = rsys_syscall(SYS_fpathconf, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(long) > sizeof(register_t))
			rv = *(long *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fpathconf,rump_enosys)

int rump___sysimpl_getrlimit(int, struct rlimit *);
int
rump___sysimpl_getrlimit(int which, struct rlimit * rlp)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_getrlimit_args callarg;

	SPARG(&callarg, which) = which;
	SPARG(&callarg, rlp) = rlp;

	error = rsys_syscall(SYS_getrlimit, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_getrlimit,rump_enosys)

int rump___sysimpl_setrlimit(int, const struct rlimit *);
int
rump___sysimpl_setrlimit(int which, const struct rlimit * rlp)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_setrlimit_args callarg;

	SPARG(&callarg, which) = which;
	SPARG(&callarg, rlp) = rlp;

	error = rsys_syscall(SYS_setrlimit, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_setrlimit,rump_enosys)

off_t rump___sysimpl_lseek(int, off_t, int);
off_t
rump___sysimpl_lseek(int fd, off_t offset, int whence)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	off_t rv = -1;
	struct sys_lseek_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, offset) = offset;
	SPARG(&callarg, whence) = whence;

	error = rsys_syscall(SYS_lseek, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(off_t) > sizeof(register_t))
			rv = *(off_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_lseek,rump_enosys)

int rump___sysimpl_truncate(const char *, off_t);
int
rump___sysimpl_truncate(const char * path, off_t length)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_truncate_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, length) = length;

	error = rsys_syscall(SYS_truncate, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_truncate,rump_enosys)

int rump___sysimpl_ftruncate(int, off_t);
int
rump___sysimpl_ftruncate(int fd, off_t length)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_ftruncate_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, length) = length;

	error = rsys_syscall(SYS_ftruncate, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_ftruncate,rump_enosys)

int rump___sysimpl___sysctl(const int *, u_int, void *, size_t *, const void *, size_t);
int
rump___sysimpl___sysctl(const int * name, u_int namelen, void * old, size_t * oldlenp, const void * new, size_t newlen)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___sysctl_args callarg;

	SPARG(&callarg, name) = name;
	SPARG(&callarg, namelen) = namelen;
	SPARG(&callarg, old) = old;
	SPARG(&callarg, oldlenp) = oldlenp;
	SPARG(&callarg, new) = new;
	SPARG(&callarg, newlen) = newlen;

	error = rsys_syscall(SYS___sysctl, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___sysctl,rump_enosys)

int rump___sysimpl_futimes(int, const struct timeval *);
int
rump___sysimpl_futimes(int fd, const struct timeval * tptr)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct compat_50_sys_futimes_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, tptr) = (const struct timeval50 *)tptr;

	error = rsys_syscall(SYS_compat_50_futimes, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(compat_50_sys_futimes,rump_enosys)

pid_t rump___sysimpl_getpgid(pid_t);
pid_t
rump___sysimpl_getpgid(pid_t pid)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	pid_t rv = -1;
	struct sys_getpgid_args callarg;

	SPARG(&callarg, pid) = pid;

	error = rsys_syscall(SYS_getpgid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(pid_t) > sizeof(register_t))
			rv = *(pid_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_getpgid,rump_enosys)

int rump___sysimpl_reboot(int, char *);
int
rump___sysimpl_reboot(int opt, char * bootstr)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_reboot_args callarg;

	SPARG(&callarg, opt) = opt;
	SPARG(&callarg, bootstr) = bootstr;

	error = rsys_syscall(SYS_reboot, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_reboot,rump_enosys)

int rump___sysimpl_poll(struct pollfd *, u_int, int);
int
rump___sysimpl_poll(struct pollfd * fds, u_int nfds, int timeout)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_poll_args callarg;

	SPARG(&callarg, fds) = fds;
	SPARG(&callarg, nfds) = nfds;
	SPARG(&callarg, timeout) = timeout;

	error = rsys_syscall(SYS_poll, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_poll,rump_enosys)

int rump___sysimpl_fdatasync(int);
int
rump___sysimpl_fdatasync(int fd)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fdatasync_args callarg;

	SPARG(&callarg, fd) = fd;

	error = rsys_syscall(SYS_fdatasync, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fdatasync,rump_enosys)

int rump___sysimpl_modctl(int, void *);
int
rump___sysimpl_modctl(int cmd, void * arg)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_modctl_args callarg;

	SPARG(&callarg, cmd) = cmd;
	SPARG(&callarg, arg) = arg;

	error = rsys_syscall(SYS_modctl, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_modctl,rump_enosys)

int rump___sysimpl__ksem_init(unsigned int, intptr_t *);
int
rump___sysimpl__ksem_init(unsigned int value, intptr_t * idp)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys__ksem_init_args callarg;

	SPARG(&callarg, value) = value;
	SPARG(&callarg, idp) = idp;

	error = rsys_syscall(SYS__ksem_init, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys__ksem_init,rump_enosys)

int rump___sysimpl__ksem_open(const char *, int, mode_t, unsigned int, intptr_t *);
int
rump___sysimpl__ksem_open(const char * name, int oflag, mode_t mode, unsigned int value, intptr_t * idp)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys__ksem_open_args callarg;

	SPARG(&callarg, name) = name;
	SPARG(&callarg, oflag) = oflag;
	SPARG(&callarg, mode) = mode;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, idp) = idp;

	error = rsys_syscall(SYS__ksem_open, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys__ksem_open,rump_enosys)

int rump___sysimpl__ksem_unlink(const char *);
int
rump___sysimpl__ksem_unlink(const char * name)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys__ksem_unlink_args callarg;

	SPARG(&callarg, name) = name;

	error = rsys_syscall(SYS__ksem_unlink, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys__ksem_unlink,rump_enosys)

int rump___sysimpl__ksem_close(intptr_t);
int
rump___sysimpl__ksem_close(intptr_t id)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys__ksem_close_args callarg;

	SPARG(&callarg, id) = id;

	error = rsys_syscall(SYS__ksem_close, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys__ksem_close,rump_enosys)

int rump___sysimpl__ksem_post(intptr_t);
int
rump___sysimpl__ksem_post(intptr_t id)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys__ksem_post_args callarg;

	SPARG(&callarg, id) = id;

	error = rsys_syscall(SYS__ksem_post, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys__ksem_post,rump_enosys)

int rump___sysimpl__ksem_wait(intptr_t);
int
rump___sysimpl__ksem_wait(intptr_t id)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys__ksem_wait_args callarg;

	SPARG(&callarg, id) = id;

	error = rsys_syscall(SYS__ksem_wait, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys__ksem_wait,rump_enosys)

int rump___sysimpl__ksem_trywait(intptr_t);
int
rump___sysimpl__ksem_trywait(intptr_t id)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys__ksem_trywait_args callarg;

	SPARG(&callarg, id) = id;

	error = rsys_syscall(SYS__ksem_trywait, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys__ksem_trywait,rump_enosys)

int rump___sysimpl__ksem_getvalue(intptr_t, unsigned int *);
int
rump___sysimpl__ksem_getvalue(intptr_t id, unsigned int * value)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys__ksem_getvalue_args callarg;

	SPARG(&callarg, id) = id;
	SPARG(&callarg, value) = value;

	error = rsys_syscall(SYS__ksem_getvalue, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys__ksem_getvalue,rump_enosys)

int rump___sysimpl__ksem_destroy(intptr_t);
int
rump___sysimpl__ksem_destroy(intptr_t id)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys__ksem_destroy_args callarg;

	SPARG(&callarg, id) = id;

	error = rsys_syscall(SYS__ksem_destroy, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys__ksem_destroy,rump_enosys)

int rump___sysimpl__ksem_timedwait(intptr_t, const struct timespec *);
int
rump___sysimpl__ksem_timedwait(intptr_t id, const struct timespec * abstime)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys__ksem_timedwait_args callarg;

	SPARG(&callarg, id) = id;
	SPARG(&callarg, abstime) = abstime;

	error = rsys_syscall(SYS__ksem_timedwait, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys__ksem_timedwait,rump_enosys)

int rump___sysimpl_lchmod(const char *, mode_t);
int
rump___sysimpl_lchmod(const char * path, mode_t mode)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_lchmod_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_lchmod, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_lchmod,rump_enosys)

int rump___sysimpl_lchown(const char *, uid_t, gid_t);
int
rump___sysimpl_lchown(const char * path, uid_t uid, gid_t gid)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_lchown_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, uid) = uid;
	SPARG(&callarg, gid) = gid;

	error = rsys_syscall(SYS_lchown, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_lchown,rump_enosys)

int rump___sysimpl_lutimes(const char *, const struct timeval *);
int
rump___sysimpl_lutimes(const char * path, const struct timeval * tptr)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct compat_50_sys_lutimes_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, tptr) = (const struct timeval50 *)tptr;

	error = rsys_syscall(SYS_compat_50_lutimes, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(compat_50_sys_lutimes,rump_enosys)

pid_t rump___sysimpl_getsid(pid_t);
pid_t
rump___sysimpl_getsid(pid_t pid)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	pid_t rv = -1;
	struct sys_getsid_args callarg;

	SPARG(&callarg, pid) = pid;

	error = rsys_syscall(SYS_getsid, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(pid_t) > sizeof(register_t))
			rv = *(pid_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_getsid,rump_enosys)

ssize_t rump___sysimpl_preadv(int, const struct iovec *, int, off_t);
ssize_t
rump___sysimpl_preadv(int fd, const struct iovec * iovp, int iovcnt, off_t offset)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_preadv_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, iovp) = iovp;
	SPARG(&callarg, iovcnt) = iovcnt;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, offset) = offset;

	error = rsys_syscall(SYS_preadv, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_preadv,rump_enosys)

ssize_t rump___sysimpl_pwritev(int, const struct iovec *, int, off_t);
ssize_t
rump___sysimpl_pwritev(int fd, const struct iovec * iovp, int iovcnt, off_t offset)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_pwritev_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, iovp) = iovp;
	SPARG(&callarg, iovcnt) = iovcnt;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, offset) = offset;

	error = rsys_syscall(SYS_pwritev, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_pwritev,rump_enosys)

int rump___sysimpl___getcwd(char *, size_t);
int
rump___sysimpl___getcwd(char * bufp, size_t length)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___getcwd_args callarg;

	SPARG(&callarg, bufp) = bufp;
	SPARG(&callarg, length) = length;

	error = rsys_syscall(SYS___getcwd, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___getcwd,rump_enosys)

int rump___sysimpl_fchroot(int);
int
rump___sysimpl_fchroot(int fd)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fchroot_args callarg;

	SPARG(&callarg, fd) = fd;

	error = rsys_syscall(SYS_fchroot, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fchroot,rump_enosys)

int rump___sysimpl_lchflags(const char *, u_long);
int
rump___sysimpl_lchflags(const char * path, u_long flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_lchflags_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_lchflags, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_lchflags,rump_enosys)

int rump___sysimpl_issetugid(void);
int
rump___sysimpl_issetugid(void )
{
	register_t retval[2] = {0, 0};
	int rv = -1;

	rsys_syscall(SYS_issetugid, NULL, 0, retval);
	if (sizeof(int) > sizeof(register_t))
		rv = *(int *)retval;
	else
		rv = *retval;
	return rv;
}
rsys_alias(sys_issetugid,rump_enosys)

int rump___sysimpl_kqueue(void);
int
rump___sysimpl_kqueue(void )
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;

	error = rsys_syscall(SYS_kqueue, NULL, 0, retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_kqueue,rump_enosys)

int rump___sysimpl_kevent(int, const struct kevent *, size_t, struct kevent *, size_t, const struct timespec *);
int
rump___sysimpl_kevent(int fd, const struct kevent * changelist, size_t nchanges, struct kevent * eventlist, size_t nevents, const struct timespec * timeout)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct compat_50_sys_kevent_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, changelist) = changelist;
	SPARG(&callarg, nchanges) = nchanges;
	SPARG(&callarg, eventlist) = eventlist;
	SPARG(&callarg, nevents) = nevents;
	SPARG(&callarg, timeout) = (const struct timespec50 *)timeout;

	error = rsys_syscall(SYS_compat_50_kevent, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(compat_50_sys_kevent,rump_enosys)

int rump___sysimpl_fsync_range(int, int, off_t, off_t);
int
rump___sysimpl_fsync_range(int fd, int flags, off_t start, off_t length)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fsync_range_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, start) = start;
	SPARG(&callarg, length) = length;

	error = rsys_syscall(SYS_fsync_range, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fsync_range,rump_enosys)

int rump___sysimpl_getvfsstat(struct statvfs *, size_t, int);
int
rump___sysimpl_getvfsstat(struct statvfs * buf, size_t bufsize, int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_getvfsstat_args callarg;

	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, bufsize) = bufsize;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_getvfsstat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_getvfsstat,rump_enosys)

int rump___sysimpl_statvfs1(const char *, struct statvfs *, int);
int
rump___sysimpl_statvfs1(const char * path, struct statvfs * buf, int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_statvfs1_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_statvfs1, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_statvfs1,rump_enosys)

int rump___sysimpl_fstatvfs1(int, struct statvfs *, int);
int
rump___sysimpl_fstatvfs1(int fd, struct statvfs * buf, int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fstatvfs1_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_fstatvfs1, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fstatvfs1,rump_enosys)

int rump___sysimpl_extattrctl(const char *, int, const char *, int, const char *);
int
rump___sysimpl_extattrctl(const char * path, int cmd, const char * filename, int attrnamespace, const char * attrname)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_extattrctl_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, cmd) = cmd;
	SPARG(&callarg, filename) = filename;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;

	error = rsys_syscall(SYS_extattrctl, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_extattrctl,rump_enosys)

int rump___sysimpl_extattr_set_file(const char *, int, const char *, const void *, size_t);
int
rump___sysimpl_extattr_set_file(const char * path, int attrnamespace, const char * attrname, const void * data, size_t nbytes)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_extattr_set_file_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_set_file, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_extattr_set_file,rump_enosys)

ssize_t rump___sysimpl_extattr_get_file(const char *, int, const char *, void *, size_t);
ssize_t
rump___sysimpl_extattr_get_file(const char * path, int attrnamespace, const char * attrname, void * data, size_t nbytes)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_extattr_get_file_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_get_file, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_extattr_get_file,rump_enosys)

int rump___sysimpl_extattr_delete_file(const char *, int, const char *);
int
rump___sysimpl_extattr_delete_file(const char * path, int attrnamespace, const char * attrname)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_extattr_delete_file_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;

	error = rsys_syscall(SYS_extattr_delete_file, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_extattr_delete_file,rump_enosys)

int rump___sysimpl_extattr_set_fd(int, int, const char *, const void *, size_t);
int
rump___sysimpl_extattr_set_fd(int fd, int attrnamespace, const char * attrname, const void * data, size_t nbytes)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_extattr_set_fd_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_set_fd, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_extattr_set_fd,rump_enosys)

ssize_t rump___sysimpl_extattr_get_fd(int, int, const char *, void *, size_t);
ssize_t
rump___sysimpl_extattr_get_fd(int fd, int attrnamespace, const char * attrname, void * data, size_t nbytes)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_extattr_get_fd_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_get_fd, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_extattr_get_fd,rump_enosys)

int rump___sysimpl_extattr_delete_fd(int, int, const char *);
int
rump___sysimpl_extattr_delete_fd(int fd, int attrnamespace, const char * attrname)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_extattr_delete_fd_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;

	error = rsys_syscall(SYS_extattr_delete_fd, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_extattr_delete_fd,rump_enosys)

int rump___sysimpl_extattr_set_link(const char *, int, const char *, const void *, size_t);
int
rump___sysimpl_extattr_set_link(const char * path, int attrnamespace, const char * attrname, const void * data, size_t nbytes)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_extattr_set_link_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_set_link, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_extattr_set_link,rump_enosys)

ssize_t rump___sysimpl_extattr_get_link(const char *, int, const char *, void *, size_t);
ssize_t
rump___sysimpl_extattr_get_link(const char * path, int attrnamespace, const char * attrname, void * data, size_t nbytes)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_extattr_get_link_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_get_link, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_extattr_get_link,rump_enosys)

int rump___sysimpl_extattr_delete_link(const char *, int, const char *);
int
rump___sysimpl_extattr_delete_link(const char * path, int attrnamespace, const char * attrname)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_extattr_delete_link_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, attrname) = attrname;

	error = rsys_syscall(SYS_extattr_delete_link, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_extattr_delete_link,rump_enosys)

ssize_t rump___sysimpl_extattr_list_fd(int, int, void *, size_t);
ssize_t
rump___sysimpl_extattr_list_fd(int fd, int attrnamespace, void * data, size_t nbytes)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_extattr_list_fd_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_list_fd, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_extattr_list_fd,rump_enosys)

ssize_t rump___sysimpl_extattr_list_file(const char *, int, void *, size_t);
ssize_t
rump___sysimpl_extattr_list_file(const char * path, int attrnamespace, void * data, size_t nbytes)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_extattr_list_file_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_list_file, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_extattr_list_file,rump_enosys)

ssize_t rump___sysimpl_extattr_list_link(const char *, int, void *, size_t);
ssize_t
rump___sysimpl_extattr_list_link(const char * path, int attrnamespace, void * data, size_t nbytes)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	ssize_t rv = -1;
	struct sys_extattr_list_link_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, attrnamespace) = attrnamespace;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, nbytes) = nbytes;

	error = rsys_syscall(SYS_extattr_list_link, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(ssize_t) > sizeof(register_t))
			rv = *(ssize_t *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_extattr_list_link,rump_enosys)

int rump___sysimpl_pselect(int, fd_set *, fd_set *, fd_set *, const struct timespec *, const sigset_t *);
int
rump___sysimpl_pselect(int nd, fd_set * in, fd_set * ou, fd_set * ex, const struct timespec * ts, const sigset_t * mask)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct compat_50_sys_pselect_args callarg;

	SPARG(&callarg, nd) = nd;
	SPARG(&callarg, in) = in;
	SPARG(&callarg, ou) = ou;
	SPARG(&callarg, ex) = ex;
	SPARG(&callarg, ts) = (const struct timespec50 *)ts;
	SPARG(&callarg, mask) = mask;

	error = rsys_syscall(SYS_compat_50_pselect, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(compat_50_sys_pselect,rump_enosys)

int rump___sysimpl_pollts(struct pollfd *, u_int, const struct timespec *, const sigset_t *);
int
rump___sysimpl_pollts(struct pollfd * fds, u_int nfds, const struct timespec * ts, const sigset_t * mask)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct compat_50_sys_pollts_args callarg;

	SPARG(&callarg, fds) = fds;
	SPARG(&callarg, nfds) = nfds;
	SPARG(&callarg, ts) = (const struct timespec50 *)ts;
	SPARG(&callarg, mask) = mask;

	error = rsys_syscall(SYS_compat_50_pollts, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(compat_50_sys_pollts,rump_enosys)

int rump___sysimpl_setxattr(const char *, const char *, const void *, size_t, int);
int
rump___sysimpl_setxattr(const char * path, const char * name, const void * value, size_t size, int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_setxattr_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_setxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_setxattr,rump_enosys)

int rump___sysimpl_lsetxattr(const char *, const char *, const void *, size_t, int);
int
rump___sysimpl_lsetxattr(const char * path, const char * name, const void * value, size_t size, int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_lsetxattr_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_lsetxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_lsetxattr,rump_enosys)

int rump___sysimpl_fsetxattr(int, const char *, const void *, size_t, int);
int
rump___sysimpl_fsetxattr(int fd, const char * name, const void * value, size_t size, int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fsetxattr_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_fsetxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fsetxattr,rump_enosys)

int rump___sysimpl_getxattr(const char *, const char *, void *, size_t);
int
rump___sysimpl_getxattr(const char * path, const char * name, void * value, size_t size)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_getxattr_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;

	error = rsys_syscall(SYS_getxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_getxattr,rump_enosys)

int rump___sysimpl_lgetxattr(const char *, const char *, void *, size_t);
int
rump___sysimpl_lgetxattr(const char * path, const char * name, void * value, size_t size)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_lgetxattr_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;

	error = rsys_syscall(SYS_lgetxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_lgetxattr,rump_enosys)

int rump___sysimpl_fgetxattr(int, const char *, void *, size_t);
int
rump___sysimpl_fgetxattr(int fd, const char * name, void * value, size_t size)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fgetxattr_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, value) = value;
	SPARG(&callarg, size) = size;

	error = rsys_syscall(SYS_fgetxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fgetxattr,rump_enosys)

int rump___sysimpl_listxattr(const char *, char *, size_t);
int
rump___sysimpl_listxattr(const char * path, char * list, size_t size)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_listxattr_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, list) = list;
	SPARG(&callarg, size) = size;

	error = rsys_syscall(SYS_listxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_listxattr,rump_enosys)

int rump___sysimpl_llistxattr(const char *, char *, size_t);
int
rump___sysimpl_llistxattr(const char * path, char * list, size_t size)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_llistxattr_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, list) = list;
	SPARG(&callarg, size) = size;

	error = rsys_syscall(SYS_llistxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_llistxattr,rump_enosys)

int rump___sysimpl_flistxattr(int, char *, size_t);
int
rump___sysimpl_flistxattr(int fd, char * list, size_t size)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_flistxattr_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, list) = list;
	SPARG(&callarg, size) = size;

	error = rsys_syscall(SYS_flistxattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_flistxattr,rump_enosys)

int rump___sysimpl_removexattr(const char *, const char *);
int
rump___sysimpl_removexattr(const char * path, const char * name)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_removexattr_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;

	error = rsys_syscall(SYS_removexattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_removexattr,rump_enosys)

int rump___sysimpl_lremovexattr(const char *, const char *);
int
rump___sysimpl_lremovexattr(const char * path, const char * name)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_lremovexattr_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, name) = name;

	error = rsys_syscall(SYS_lremovexattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_lremovexattr,rump_enosys)

int rump___sysimpl_fremovexattr(int, const char *);
int
rump___sysimpl_fremovexattr(int fd, const char * name)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fremovexattr_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, name) = name;

	error = rsys_syscall(SYS_fremovexattr, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fremovexattr,rump_enosys)

int rump___sysimpl_stat30(const char *, struct stat *);
int
rump___sysimpl_stat30(const char * path, struct stat * ub)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct compat_50_sys___stat30_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, ub) = (struct stat30 *)ub;

	error = rsys_syscall(SYS_compat_50___stat30, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(compat_50_sys___stat30,rump_enosys)

int rump___sysimpl_fstat30(int, struct stat *);
int
rump___sysimpl_fstat30(int fd, struct stat * sb)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct compat_50_sys___fstat30_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, sb) = (struct stat30 *)sb;

	error = rsys_syscall(SYS_compat_50___fstat30, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(compat_50_sys___fstat30,rump_enosys)

int rump___sysimpl_lstat30(const char *, struct stat *);
int
rump___sysimpl_lstat30(const char * path, struct stat * ub)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct compat_50_sys___lstat30_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, ub) = (struct stat30 *)ub;

	error = rsys_syscall(SYS_compat_50___lstat30, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(compat_50_sys___lstat30,rump_enosys)

int rump___sysimpl_getdents30(int, char *, size_t);
int
rump___sysimpl_getdents30(int fd, char * buf, size_t count)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___getdents30_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, count) = count;

	error = rsys_syscall(SYS___getdents30, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___getdents30,rump_enosys)

int rump___sysimpl_socket30(int, int, int);
int
rump___sysimpl_socket30(int domain, int type, int protocol)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___socket30_args callarg;

	SPARG(&callarg, domain) = domain;
	SPARG(&callarg, type) = type;
	SPARG(&callarg, protocol) = protocol;

	error = rsys_syscall(SYS___socket30, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___socket30,rump_enosys)

int rump___sysimpl_getfh30(const char *, void *, size_t *);
int
rump___sysimpl_getfh30(const char * fname, void * fhp, size_t * fh_size)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___getfh30_args callarg;

	SPARG(&callarg, fname) = fname;
	SPARG(&callarg, fhp) = fhp;
	SPARG(&callarg, fh_size) = fh_size;

	error = rsys_syscall(SYS___getfh30, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___getfh30,rump_enosys)

int rump___sysimpl_fhopen40(const void *, size_t, int);
int
rump___sysimpl_fhopen40(const void * fhp, size_t fh_size, int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___fhopen40_args callarg;

	SPARG(&callarg, fhp) = fhp;
	SPARG(&callarg, fh_size) = fh_size;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS___fhopen40, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___fhopen40,rump_enosys)

int rump___sysimpl_fhstatvfs140(const void *, size_t, struct statvfs *, int);
int
rump___sysimpl_fhstatvfs140(const void * fhp, size_t fh_size, struct statvfs * buf, int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___fhstatvfs140_args callarg;

	SPARG(&callarg, fhp) = fhp;
	SPARG(&callarg, fh_size) = fh_size;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS___fhstatvfs140, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___fhstatvfs140,rump_enosys)

int rump___sysimpl_fhstat40(const void *, size_t, struct stat *);
int
rump___sysimpl_fhstat40(const void * fhp, size_t fh_size, struct stat * sb)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct compat_50_sys___fhstat40_args callarg;

	SPARG(&callarg, fhp) = fhp;
	SPARG(&callarg, fh_size) = fh_size;
	SPARG(&callarg, sb) = (struct stat30 *)sb;

	error = rsys_syscall(SYS_compat_50___fhstat40, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(compat_50_sys___fhstat40,rump_enosys)

int rump___sysimpl_mount50(const char *, const char *, int, void *, size_t);
int
rump___sysimpl_mount50(const char * type, const char * path, int flags, void * data, size_t data_len)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___mount50_args callarg;

	SPARG(&callarg, type) = type;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, flags) = flags;
	SPARG(&callarg, data) = data;
	SPARG(&callarg, data_len) = data_len;

	error = rsys_syscall(SYS___mount50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___mount50,rump_enosys)

int rump___sysimpl_posix_fadvise50(int, off_t, off_t, int);
int
rump___sysimpl_posix_fadvise50(int fd, off_t offset, off_t len, int advice)
{
	register_t retval[2] = {0, 0};
	int rv = -1;
	struct sys___posix_fadvise50_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, PAD) = 0;
	SPARG(&callarg, offset) = offset;
	SPARG(&callarg, len) = len;
	SPARG(&callarg, advice) = advice;

	rsys_syscall(SYS___posix_fadvise50, &callarg, sizeof(callarg), retval);
	if (sizeof(int) > sizeof(register_t))
		rv = *(int *)retval;
	else
		rv = *retval;
	return rv;
}
rsys_alias(sys___posix_fadvise50,rump_enosys)

int rump___sysimpl_select50(int, fd_set *, fd_set *, fd_set *, struct timeval *);
int
rump___sysimpl_select50(int nd, fd_set * in, fd_set * ou, fd_set * ex, struct timeval * tv)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___select50_args callarg;

	SPARG(&callarg, nd) = nd;
	SPARG(&callarg, in) = in;
	SPARG(&callarg, ou) = ou;
	SPARG(&callarg, ex) = ex;
	SPARG(&callarg, tv) = tv;

	error = rsys_syscall(SYS___select50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___select50,rump_enosys)

int rump___sysimpl_utimes50(const char *, const struct timeval *);
int
rump___sysimpl_utimes50(const char * path, const struct timeval * tptr)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___utimes50_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, tptr) = tptr;

	error = rsys_syscall(SYS___utimes50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___utimes50,rump_enosys)

int rump___sysimpl_futimes50(int, const struct timeval *);
int
rump___sysimpl_futimes50(int fd, const struct timeval * tptr)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___futimes50_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, tptr) = tptr;

	error = rsys_syscall(SYS___futimes50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___futimes50,rump_enosys)

int rump___sysimpl_lutimes50(const char *, const struct timeval *);
int
rump___sysimpl_lutimes50(const char * path, const struct timeval * tptr)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___lutimes50_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, tptr) = tptr;

	error = rsys_syscall(SYS___lutimes50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___lutimes50,rump_enosys)

int rump___sysimpl_kevent50(int, const struct kevent *, size_t, struct kevent *, size_t, const struct timespec *);
int
rump___sysimpl_kevent50(int fd, const struct kevent * changelist, size_t nchanges, struct kevent * eventlist, size_t nevents, const struct timespec * timeout)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___kevent50_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, changelist) = changelist;
	SPARG(&callarg, nchanges) = nchanges;
	SPARG(&callarg, eventlist) = eventlist;
	SPARG(&callarg, nevents) = nevents;
	SPARG(&callarg, timeout) = timeout;

	error = rsys_syscall(SYS___kevent50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___kevent50,rump_enosys)

int rump___sysimpl_pselect50(int, fd_set *, fd_set *, fd_set *, const struct timespec *, const sigset_t *);
int
rump___sysimpl_pselect50(int nd, fd_set * in, fd_set * ou, fd_set * ex, const struct timespec * ts, const sigset_t * mask)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___pselect50_args callarg;

	SPARG(&callarg, nd) = nd;
	SPARG(&callarg, in) = in;
	SPARG(&callarg, ou) = ou;
	SPARG(&callarg, ex) = ex;
	SPARG(&callarg, ts) = ts;
	SPARG(&callarg, mask) = mask;

	error = rsys_syscall(SYS___pselect50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___pselect50,rump_enosys)

int rump___sysimpl_pollts50(struct pollfd *, u_int, const struct timespec *, const sigset_t *);
int
rump___sysimpl_pollts50(struct pollfd * fds, u_int nfds, const struct timespec * ts, const sigset_t * mask)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___pollts50_args callarg;

	SPARG(&callarg, fds) = fds;
	SPARG(&callarg, nfds) = nfds;
	SPARG(&callarg, ts) = ts;
	SPARG(&callarg, mask) = mask;

	error = rsys_syscall(SYS___pollts50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___pollts50,rump_enosys)

int rump___sysimpl_stat50(const char *, struct stat *);
int
rump___sysimpl_stat50(const char * path, struct stat * ub)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___stat50_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, ub) = ub;

	error = rsys_syscall(SYS___stat50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___stat50,rump_enosys)

int rump___sysimpl_fstat50(int, struct stat *);
int
rump___sysimpl_fstat50(int fd, struct stat * sb)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___fstat50_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, sb) = sb;

	error = rsys_syscall(SYS___fstat50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___fstat50,rump_enosys)

int rump___sysimpl_lstat50(const char *, struct stat *);
int
rump___sysimpl_lstat50(const char * path, struct stat * ub)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___lstat50_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, ub) = ub;

	error = rsys_syscall(SYS___lstat50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___lstat50,rump_enosys)

int rump___sysimpl_mknod50(const char *, mode_t, dev_t);
int
rump___sysimpl_mknod50(const char * path, mode_t mode, dev_t dev)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___mknod50_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;
	SPARG(&callarg, dev) = dev;

	error = rsys_syscall(SYS___mknod50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___mknod50,rump_enosys)

int rump___sysimpl_fhstat50(const void *, size_t, struct stat *);
int
rump___sysimpl_fhstat50(const void * fhp, size_t fh_size, struct stat * sb)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___fhstat50_args callarg;

	SPARG(&callarg, fhp) = fhp;
	SPARG(&callarg, fh_size) = fh_size;
	SPARG(&callarg, sb) = sb;

	error = rsys_syscall(SYS___fhstat50, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___fhstat50,rump_enosys)

int rump___sysimpl_pipe2(int *, int);
int
rump___sysimpl_pipe2(int * fildes, int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_pipe2_args callarg;

	SPARG(&callarg, fildes) = fildes;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_pipe2, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_pipe2,rump_enosys)

int rump___sysimpl_dup3(int, int, int);
int
rump___sysimpl_dup3(int from, int to, int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_dup3_args callarg;

	SPARG(&callarg, from) = from;
	SPARG(&callarg, to) = to;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_dup3, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_dup3,rump_enosys)

int rump___sysimpl_kqueue1(int);
int
rump___sysimpl_kqueue1(int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_kqueue1_args callarg;

	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_kqueue1, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_kqueue1,rump_enosys)

int rump___sysimpl_paccept(int, struct sockaddr *, socklen_t *, const sigset_t *, int);
int
rump___sysimpl_paccept(int s, struct sockaddr * name, socklen_t * anamelen, const sigset_t * mask, int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_paccept_args callarg;

	SPARG(&callarg, s) = s;
	SPARG(&callarg, name) = name;
	SPARG(&callarg, anamelen) = anamelen;
	SPARG(&callarg, mask) = mask;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_paccept, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_paccept,rump_enosys)

int rump___sysimpl_linkat(int, const char *, int, const char *, int);
int
rump___sysimpl_linkat(int fd1, const char * name1, int fd2, const char * name2, int flags)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_linkat_args callarg;

	SPARG(&callarg, fd1) = fd1;
	SPARG(&callarg, name1) = name1;
	SPARG(&callarg, fd2) = fd2;
	SPARG(&callarg, name2) = name2;
	SPARG(&callarg, flags) = flags;

	error = rsys_syscall(SYS_linkat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_linkat,rump_enosys)

int rump___sysimpl_renameat(int, const char *, int, const char *);
int
rump___sysimpl_renameat(int fromfd, const char * from, int tofd, const char * to)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_renameat_args callarg;

	SPARG(&callarg, fromfd) = fromfd;
	SPARG(&callarg, from) = from;
	SPARG(&callarg, tofd) = tofd;
	SPARG(&callarg, to) = to;

	error = rsys_syscall(SYS_renameat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_renameat,rump_enosys)

int rump___sysimpl_mkfifoat(int, const char *, mode_t);
int
rump___sysimpl_mkfifoat(int fd, const char * path, mode_t mode)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_mkfifoat_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_mkfifoat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_mkfifoat,rump_enosys)

int rump___sysimpl_mknodat(int, const char *, mode_t, uint32_t);
int
rump___sysimpl_mknodat(int fd, const char * path, mode_t mode, uint32_t dev)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_mknodat_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;
	SPARG(&callarg, dev) = dev;

	error = rsys_syscall(SYS_mknodat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_mknodat,rump_enosys)

int rump___sysimpl_mkdirat(int, const char *, mode_t);
int
rump___sysimpl_mkdirat(int fd, const char * path, mode_t mode)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_mkdirat_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_mkdirat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_mkdirat,rump_enosys)

int rump___sysimpl_faccessat(int, const char *, int, int);
int
rump___sysimpl_faccessat(int fd, const char * path, int amode, int flag)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_faccessat_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, amode) = amode;
	SPARG(&callarg, flag) = flag;

	error = rsys_syscall(SYS_faccessat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_faccessat,rump_enosys)

int rump___sysimpl_fchmodat(int, const char *, mode_t, int);
int
rump___sysimpl_fchmodat(int fd, const char * path, mode_t mode, int flag)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fchmodat_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, mode) = mode;
	SPARG(&callarg, flag) = flag;

	error = rsys_syscall(SYS_fchmodat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fchmodat,rump_enosys)

int rump___sysimpl_fchownat(int, const char *, uid_t, gid_t, int);
int
rump___sysimpl_fchownat(int fd, const char * path, uid_t owner, gid_t group, int flag)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fchownat_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, owner) = owner;
	SPARG(&callarg, group) = group;
	SPARG(&callarg, flag) = flag;

	error = rsys_syscall(SYS_fchownat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fchownat,rump_enosys)

int rump___sysimpl_fexecve(int, char *const *, char *const *);
int
rump___sysimpl_fexecve(int fd, char *const * argp, char *const * envp)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fexecve_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, argp) = argp;
	SPARG(&callarg, envp) = envp;

	error = rsys_syscall(SYS_fexecve, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fexecve,rump_enosys)

int rump___sysimpl_fstatat(int, const char *, struct stat *, int);
int
rump___sysimpl_fstatat(int fd, const char * path, struct stat * buf, int flag)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_fstatat_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, flag) = flag;

	error = rsys_syscall(SYS_fstatat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_fstatat,rump_enosys)

int rump___sysimpl_utimensat(int, const char *, const struct timespec *, int);
int
rump___sysimpl_utimensat(int fd, const char * path, const struct timespec * tptr, int flag)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_utimensat_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, tptr) = tptr;
	SPARG(&callarg, flag) = flag;

	error = rsys_syscall(SYS_utimensat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_utimensat,rump_enosys)

int rump___sysimpl_openat(int, const char *, int, mode_t);
int
rump___sysimpl_openat(int fd, const char * path, int oflags, mode_t mode)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_openat_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, oflags) = oflags;
	SPARG(&callarg, mode) = mode;

	error = rsys_syscall(SYS_openat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_openat,rump_enosys)

int rump___sysimpl_readlinkat(int, const char *, char *, size_t);
int
rump___sysimpl_readlinkat(int fd, const char * path, char * buf, size_t bufsize)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_readlinkat_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, buf) = buf;
	SPARG(&callarg, bufsize) = bufsize;

	error = rsys_syscall(SYS_readlinkat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_readlinkat,rump_enosys)

int rump___sysimpl_symlinkat(const char *, int, const char *);
int
rump___sysimpl_symlinkat(const char * path1, int fd, const char * path2)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_symlinkat_args callarg;

	SPARG(&callarg, path1) = path1;
	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path2) = path2;

	error = rsys_syscall(SYS_symlinkat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_symlinkat,rump_enosys)

int rump___sysimpl_unlinkat(int, const char *, int);
int
rump___sysimpl_unlinkat(int fd, const char * path, int flag)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_unlinkat_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, path) = path;
	SPARG(&callarg, flag) = flag;

	error = rsys_syscall(SYS_unlinkat, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_unlinkat,rump_enosys)

int rump___sysimpl_futimens(int, const struct timespec *);
int
rump___sysimpl_futimens(int fd, const struct timespec * tptr)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys_futimens_args callarg;

	SPARG(&callarg, fd) = fd;
	SPARG(&callarg, tptr) = tptr;

	error = rsys_syscall(SYS_futimens, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys_futimens,rump_enosys)

int rump___sysimpl___quotactl(const char *, struct quotactl_args *);
int
rump___sysimpl___quotactl(const char * path, struct quotactl_args * args)
{
	register_t retval[2] = {0, 0};
	int error = 0;
	int rv = -1;
	struct sys___quotactl_args callarg;

	SPARG(&callarg, path) = path;
	SPARG(&callarg, args) = args;

	error = rsys_syscall(SYS___quotactl, &callarg, sizeof(callarg), retval);
	rsys_seterrno(error);
	if (error == 0) {
		if (sizeof(int) > sizeof(register_t))
			rv = *(int *)retval;
		else
			rv = *retval;
	}
	return rv;
}
rsys_alias(sys___quotactl,rump_enosys)

int rump_sys_pipe(int *);
int
rump_sys_pipe(int *fd)
{
	register_t retval[2] = {0, 0};
	int error = 0;

	error = rsys_syscall(SYS_pipe, NULL, 0, retval);
	if (error) {
		rsys_seterrno(error);
	} else {
		fd[0] = retval[0];
		fd[1] = retval[1];
	}
	return error ? -1 : 0;
}

#ifndef RUMP_CLIENT
#define	s(type)	sizeof(type)
#define	n(type)	(sizeof(type)/sizeof (register_t))
#define	ns(type)	n(type), s(type)

struct sysent rump_sysent[] = {
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 0 = syscall */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 1 = exit */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 2 = fork */
	{ ns(struct sys_read_args), 0,
	    (sy_call_t *)sys_read },		/* 3 = read */
	{ ns(struct sys_write_args), 0,
	    (sy_call_t *)sys_write },		/* 4 = write */
	{ ns(struct sys_open_args), 0,
	    (sy_call_t *)sys_open },		/* 5 = open */
	{ ns(struct sys_close_args), 0,
	    (sy_call_t *)sys_close },		/* 6 = close */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 7 = wait4 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 8 = ocreat */
	{ ns(struct sys_link_args), 0,
	    (sy_call_t *)sys_link },		/* 9 = link */
	{ ns(struct sys_unlink_args), 0,
	    (sy_call_t *)sys_unlink },		/* 10 = unlink */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 11 = obsolete execv */
	{ ns(struct sys_chdir_args), 0,
	    (sy_call_t *)sys_chdir },		/* 12 = chdir */
	{ ns(struct sys_fchdir_args), 0,
	    (sy_call_t *)sys_fchdir },		/* 13 = fchdir */
	{ ns(struct compat_50_sys_mknod_args), 0,
	    (sy_call_t *)compat_50_sys_mknod },	/* 14 = compat_50_mknod */
	{ ns(struct sys_chmod_args), 0,
	    (sy_call_t *)sys_chmod },		/* 15 = chmod */
	{ ns(struct sys_chown_args), 0,
	    (sy_call_t *)sys_chown },		/* 16 = chown */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 17 = break */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 18 = getfsstat */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 19 = olseek */
	{ 0, 0, 0,
	    (sy_call_t *)sys_getpid_with_ppid },/* 20 = getpid */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 21 = mount */
	{ ns(struct sys_unmount_args), 0,
	    (sy_call_t *)sys_unmount },		/* 22 = unmount */
	{ ns(struct sys_setuid_args), 0,
	    (sy_call_t *)sys_setuid },		/* 23 = setuid */
	{ 0, 0, 0,
	    (sy_call_t *)sys_getuid_with_euid },/* 24 = getuid */
	{ 0, 0, 0,
	    (sy_call_t *)sys_geteuid },		/* 25 = geteuid */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 26 = ptrace */
	{ ns(struct sys_recvmsg_args), 0,
	    (sy_call_t *)sys_recvmsg },		/* 27 = recvmsg */
	{ ns(struct sys_sendmsg_args), 0,
	    (sy_call_t *)sys_sendmsg },		/* 28 = sendmsg */
	{ ns(struct sys_recvfrom_args), 0,
	    (sy_call_t *)sys_recvfrom },	/* 29 = recvfrom */
	{ ns(struct sys_accept_args), 0,
	    (sy_call_t *)sys_accept },		/* 30 = accept */
	{ ns(struct sys_getpeername_args), 0,
	    (sy_call_t *)sys_getpeername },	/* 31 = getpeername */
	{ ns(struct sys_getsockname_args), 0,
	    (sy_call_t *)sys_getsockname },	/* 32 = getsockname */
	{ ns(struct sys_access_args), 0,
	    (sy_call_t *)sys_access },		/* 33 = access */
	{ ns(struct sys_chflags_args), 0,
	    (sy_call_t *)sys_chflags },		/* 34 = chflags */
	{ ns(struct sys_fchflags_args), 0,
	    (sy_call_t *)sys_fchflags },	/* 35 = fchflags */
	{ 0, 0, 0,
	    (sy_call_t *)sys_sync },		/* 36 = sync */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 37 = kill */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 38 = stat43 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_getppid },		/* 39 = getppid */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 40 = lstat43 */
	{ ns(struct sys_dup_args), 0,
	    (sy_call_t *)sys_dup },		/* 41 = dup */
	{ 0, 0, 0,
	    (sy_call_t *)sys_pipe },		/* 42 = pipe */
	{ 0, 0, 0,
	    (sy_call_t *)sys_getegid },		/* 43 = getegid */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 44 = profil */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 45 = ktrace */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 46 = sigaction13 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_getgid_with_egid },/* 47 = getgid */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 48 = sigprocmask13 */
	{ ns(struct sys___getlogin_args), 0,
	    (sy_call_t *)sys___getlogin },	/* 49 = __getlogin */
	{ ns(struct sys___setlogin_args), 0,
	    (sy_call_t *)sys___setlogin },	/* 50 = __setlogin */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 51 = acct */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 52 = sigpending13 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 53 = sigaltstack13 */
	{ ns(struct sys_ioctl_args), 0,
	    (sy_call_t *)sys_ioctl },		/* 54 = ioctl */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 55 = oreboot */
	{ ns(struct sys_revoke_args), 0,
	    (sy_call_t *)sys_revoke },		/* 56 = revoke */
	{ ns(struct sys_symlink_args), 0,
	    (sy_call_t *)sys_symlink },		/* 57 = symlink */
	{ ns(struct sys_readlink_args), 0,
	    (sy_call_t *)sys_readlink },	/* 58 = readlink */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 59 = execve */
	{ ns(struct sys_umask_args), 0,
	    (sy_call_t *)sys_umask },		/* 60 = umask */
	{ ns(struct sys_chroot_args), 0,
	    (sy_call_t *)sys_chroot },		/* 61 = chroot */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 62 = fstat43 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 63 = ogetkerninfo */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 64 = ogetpagesize */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 65 = msync */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 66 = vfork */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 67 = obsolete vread */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 68 = obsolete vwrite */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 69 = sbrk */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 70 = sstk */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 71 = ommap */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 72 = vadvise */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 73 = munmap */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 74 = mprotect */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 75 = madvise */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 76 = obsolete vhangup */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 77 = obsolete vlimit */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 78 = mincore */
	{ ns(struct sys_getgroups_args), 0,
	    (sy_call_t *)sys_getgroups },	/* 79 = getgroups */
	{ ns(struct sys_setgroups_args), 0,
	    (sy_call_t *)sys_setgroups },	/* 80 = setgroups */
	{ 0, 0, 0,
	    (sy_call_t *)sys_getpgrp },		/* 81 = getpgrp */
	{ ns(struct sys_setpgid_args), 0,
	    (sy_call_t *)sys_setpgid },		/* 82 = setpgid */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 83 = setitimer */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 84 = owait */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 85 = oswapon */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 86 = getitimer */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 87 = ogethostname */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 88 = osethostname */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 89 = ogetdtablesize */
	{ ns(struct sys_dup2_args), 0,
	    (sy_call_t *)sys_dup2 },		/* 90 = dup2 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 91 = unimplemented getdopt */
	{ ns(struct sys_fcntl_args), 0,
	    (sy_call_t *)sys_fcntl },		/* 92 = fcntl */
	{ ns(struct compat_50_sys_select_args), 0,
	    (sy_call_t *)compat_50_sys_select },/* 93 = compat_50_select */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 94 = unimplemented setdopt */
	{ ns(struct sys_fsync_args), 0,
	    (sy_call_t *)sys_fsync },		/* 95 = fsync */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 96 = setpriority */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 97 = socket */
	{ ns(struct sys_connect_args), 0,
	    (sy_call_t *)sys_connect },		/* 98 = connect */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 99 = oaccept */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 100 = getpriority */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 101 = osend */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 102 = orecv */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 103 = sigreturn13 */
	{ ns(struct sys_bind_args), 0,
	    (sy_call_t *)sys_bind },		/* 104 = bind */
	{ ns(struct sys_setsockopt_args), 0,
	    (sy_call_t *)sys_setsockopt },	/* 105 = setsockopt */
	{ ns(struct sys_listen_args), 0,
	    (sy_call_t *)sys_listen },		/* 106 = listen */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 107 = obsolete vtimes */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 108 = osigvec */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 109 = osigblock */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 110 = osigsetmask */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 111 = sigsuspend13 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 112 = osigstack */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 113 = orecvmsg */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 114 = osendmsg */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 115 = obsolete vtrace */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 116 = gettimeofday */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 117 = getrusage */
	{ ns(struct sys_getsockopt_args), 0,
	    (sy_call_t *)sys_getsockopt },	/* 118 = getsockopt */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 119 = obsolete resuba */
	{ ns(struct sys_readv_args), 0,
	    (sy_call_t *)sys_readv },		/* 120 = readv */
	{ ns(struct sys_writev_args), 0,
	    (sy_call_t *)sys_writev },		/* 121 = writev */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 122 = settimeofday */
	{ ns(struct sys_fchown_args), 0,
	    (sy_call_t *)sys_fchown },		/* 123 = fchown */
	{ ns(struct sys_fchmod_args), 0,
	    (sy_call_t *)sys_fchmod },		/* 124 = fchmod */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 125 = orecvfrom */
	{ ns(struct sys_setreuid_args), 0,
	    (sy_call_t *)sys_setreuid },	/* 126 = setreuid */
	{ ns(struct sys_setregid_args), 0,
	    (sy_call_t *)sys_setregid },	/* 127 = setregid */
	{ ns(struct sys_rename_args), 0,
	    (sy_call_t *)sys_rename },		/* 128 = rename */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 129 = otruncate */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 130 = oftruncate */
	{ ns(struct sys_flock_args), 0,
	    (sy_call_t *)sys_flock },		/* 131 = flock */
	{ ns(struct sys_mkfifo_args), 0,
	    (sy_call_t *)sys_mkfifo },		/* 132 = mkfifo */
	{ ns(struct sys_sendto_args), 0,
	    (sy_call_t *)sys_sendto },		/* 133 = sendto */
	{ ns(struct sys_shutdown_args), 0,
	    (sy_call_t *)sys_shutdown },	/* 134 = shutdown */
	{ ns(struct sys_socketpair_args), 0,
	    (sy_call_t *)sys_socketpair },	/* 135 = socketpair */
	{ ns(struct sys_mkdir_args), 0,
	    (sy_call_t *)sys_mkdir },		/* 136 = mkdir */
	{ ns(struct sys_rmdir_args), 0,
	    (sy_call_t *)sys_rmdir },		/* 137 = rmdir */
	{ ns(struct compat_50_sys_utimes_args), 0,
	    (sy_call_t *)compat_50_sys_utimes },/* 138 = compat_50_utimes */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 139 = obsolete 4.2 sigreturn */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 140 = adjtime */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 141 = ogetpeername */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 142 = ogethostid */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 143 = osethostid */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 144 = ogetrlimit */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 145 = osetrlimit */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 146 = okillpg */
	{ 0, 0, 0,
	    (sy_call_t *)sys_setsid },		/* 147 = setsid */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 148 = quotactl */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 149 = oquota */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 150 = ogetsockname */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 151 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 152 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 153 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 154 = unimplemented */
	{ ns(struct sys_nfssvc_args), 0,
	    (sy_call_t *)sys_nomodule },	/* 155 = nfssvc */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 156 = ogetdirentries */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 157 = statfs */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 158 = fstatfs */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 159 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 160 = unimplemented */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 161 = getfh */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 162 = ogetdomainname */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 163 = osetdomainname */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 164 = ouname */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 165 = sysarch */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 166 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 167 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 168 = unimplemented */
#if (defined(SYSVSEM) || !defined(_KERNEL_OPT)) && !defined(_LP64)
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 169 = osemsys */
#else
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 169 = excluded 1.0 semsys */
#endif
#if (defined(SYSVMSG) || !defined(_KERNEL_OPT)) && !defined(_LP64)
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 170 = omsgsys */
#else
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 170 = excluded 1.0 msgsys */
#endif
#if (defined(SYSVSHM) || !defined(_KERNEL_OPT)) && !defined(_LP64)
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 171 = oshmsys */
#else
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 171 = excluded 1.0 shmsys */
#endif
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 172 = unimplemented */
	{ ns(struct sys_pread_args), 0,
	    (sy_call_t *)sys_pread },		/* 173 = pread */
	{ ns(struct sys_pwrite_args), 0,
	    (sy_call_t *)sys_pwrite },		/* 174 = pwrite */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 175 = ntp_gettime */
#if defined(NTP) || !defined(_KERNEL_OPT)
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 176 = ntp_adjtime */
#else
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 176 = excluded ntp_adjtime */
#endif
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 177 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 178 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 179 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 180 = unimplemented */
	{ ns(struct sys_setgid_args), 0,
	    (sy_call_t *)sys_setgid },		/* 181 = setgid */
	{ ns(struct sys_setegid_args), 0,
	    (sy_call_t *)sys_setegid },		/* 182 = setegid */
	{ ns(struct sys_seteuid_args), 0,
	    (sy_call_t *)sys_seteuid },		/* 183 = seteuid */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 184 = lfs_bmapv */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 185 = lfs_markv */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 186 = lfs_segclean */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 187 = lfs_segwait */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 188 = stat12 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 189 = fstat12 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 190 = lstat12 */
	{ ns(struct sys_pathconf_args), 0,
	    (sy_call_t *)sys_pathconf },	/* 191 = pathconf */
	{ ns(struct sys_fpathconf_args), 0,
	    (sy_call_t *)sys_fpathconf },	/* 192 = fpathconf */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 193 = unimplemented */
	{ ns(struct sys_getrlimit_args), 0,
	    (sy_call_t *)sys_getrlimit },	/* 194 = getrlimit */
	{ ns(struct sys_setrlimit_args), 0,
	    (sy_call_t *)sys_setrlimit },	/* 195 = setrlimit */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 196 = getdirentries */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 197 = mmap */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 198 = __syscall */
	{ ns(struct sys_lseek_args), 0,
	    (sy_call_t *)sys_lseek },		/* 199 = lseek */
	{ ns(struct sys_truncate_args), 0,
	    (sy_call_t *)sys_truncate },	/* 200 = truncate */
	{ ns(struct sys_ftruncate_args), 0,
	    (sy_call_t *)sys_ftruncate },	/* 201 = ftruncate */
	{ ns(struct sys___sysctl_args), 0,
	    (sy_call_t *)sys___sysctl },	/* 202 = __sysctl */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 203 = mlock */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 204 = munlock */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 205 = undelete */
	{ ns(struct compat_50_sys_futimes_args), 0,
	    (sy_call_t *)compat_50_sys_futimes },/* 206 = compat_50_futimes */
	{ ns(struct sys_getpgid_args), 0,
	    (sy_call_t *)sys_getpgid },		/* 207 = getpgid */
	{ ns(struct sys_reboot_args), 0,
	    (sy_call_t *)sys_reboot },		/* 208 = reboot */
	{ ns(struct sys_poll_args), 0,
	    (sy_call_t *)sys_poll },		/* 209 = poll */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 210 = afssys */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 211 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 212 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 213 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 214 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 215 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 216 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 217 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 218 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 219 = unimplemented */
#if defined(SYSVSEM) || !defined(_KERNEL_OPT)
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 220 = __semctl */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 221 = semget */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 222 = semop */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 223 = semconfig */
#else
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 220 = excluded compat_14_semctl */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 221 = excluded semget */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 222 = excluded semop */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 223 = excluded semconfig */
#endif
#if defined(SYSVMSG) || !defined(_KERNEL_OPT)
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 224 = msgctl */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 225 = msgget */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 226 = msgsnd */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 227 = msgrcv */
#else
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 224 = excluded compat_14_msgctl */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 225 = excluded msgget */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 226 = excluded msgsnd */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 227 = excluded msgrcv */
#endif
#if defined(SYSVSHM) || !defined(_KERNEL_OPT)
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 228 = shmat */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 229 = shmctl */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 230 = shmdt */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 231 = shmget */
#else
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 228 = excluded shmat */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 229 = excluded compat_14_shmctl */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 230 = excluded shmdt */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 231 = excluded shmget */
#endif
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 232 = clock_gettime */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 233 = clock_settime */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 234 = clock_getres */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 235 = timer_create */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 236 = timer_delete */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 237 = timer_settime */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 238 = timer_gettime */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 239 = timer_getoverrun */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 240 = nanosleep */
	{ ns(struct sys_fdatasync_args), 0,
	    (sy_call_t *)sys_fdatasync },	/* 241 = fdatasync */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 242 = mlockall */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 243 = munlockall */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 244 = __sigtimedwait */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 245 = sigqueueinfo */
	{ ns(struct sys_modctl_args), 0,
	    (sy_call_t *)sys_modctl },		/* 246 = modctl */
	{ ns(struct sys__ksem_init_args), 0,
	    (sy_call_t *)sys_nomodule },	/* 247 = _ksem_init */
	{ ns(struct sys__ksem_open_args), 0,
	    (sy_call_t *)sys_nomodule },	/* 248 = _ksem_open */
	{ ns(struct sys__ksem_unlink_args), 0,
	    (sy_call_t *)sys_nomodule },	/* 249 = _ksem_unlink */
	{ ns(struct sys__ksem_close_args), 0,
	    (sy_call_t *)sys_nomodule },	/* 250 = _ksem_close */
	{ ns(struct sys__ksem_post_args), 0,
	    (sy_call_t *)sys_nomodule },	/* 251 = _ksem_post */
	{ ns(struct sys__ksem_wait_args), 0,
	    (sy_call_t *)sys_nomodule },	/* 252 = _ksem_wait */
	{ ns(struct sys__ksem_trywait_args), 0,
	    (sy_call_t *)sys_nomodule },	/* 253 = _ksem_trywait */
	{ ns(struct sys__ksem_getvalue_args), 0,
	    (sy_call_t *)sys_nomodule },	/* 254 = _ksem_getvalue */
	{ ns(struct sys__ksem_destroy_args), 0,
	    (sy_call_t *)sys_nomodule },	/* 255 = _ksem_destroy */
	{ ns(struct sys__ksem_timedwait_args), 0,
	    (sy_call_t *)sys_nomodule },	/* 256 = _ksem_timedwait */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 257 = mq_open */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 258 = mq_close */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 259 = mq_unlink */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 260 = mq_getattr */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 261 = mq_setattr */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 262 = mq_notify */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 263 = mq_send */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 264 = mq_receive */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 265 = mq_timedsend */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 266 = mq_timedreceive */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 267 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 268 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 269 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 270 = __posix_rename */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 271 = swapctl */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 272 = getdents */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 273 = minherit */
	{ ns(struct sys_lchmod_args), 0,
	    (sy_call_t *)sys_lchmod },		/* 274 = lchmod */
	{ ns(struct sys_lchown_args), 0,
	    (sy_call_t *)sys_lchown },		/* 275 = lchown */
	{ ns(struct compat_50_sys_lutimes_args), 0,
	    (sy_call_t *)compat_50_sys_lutimes },/* 276 = compat_50_lutimes */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 277 = __msync13 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 278 = __stat13 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 279 = __fstat13 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 280 = __lstat13 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 281 = __sigaltstack14 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 282 = __vfork14 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 283 = __posix_chown */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 284 = __posix_fchown */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 285 = __posix_lchown */
	{ ns(struct sys_getsid_args), 0,
	    (sy_call_t *)sys_getsid },		/* 286 = getsid */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 287 = __clone */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 288 = fktrace */
	{ ns(struct sys_preadv_args), 0,
	    (sy_call_t *)sys_preadv },		/* 289 = preadv */
	{ ns(struct sys_pwritev_args), 0,
	    (sy_call_t *)sys_pwritev },		/* 290 = pwritev */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 291 = __sigaction14 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 292 = __sigpending14 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 293 = __sigprocmask14 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 294 = __sigsuspend14 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 295 = __sigreturn14 */
	{ ns(struct sys___getcwd_args), 0,
	    (sy_call_t *)sys___getcwd },	/* 296 = __getcwd */
	{ ns(struct sys_fchroot_args), 0,
	    (sy_call_t *)sys_fchroot },		/* 297 = fchroot */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 298 = fhopen */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 299 = fhstat */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 300 = fhstatfs */
#if defined(SYSVSEM) || !defined(_KERNEL_OPT)
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 301 = ____semctl13 */
#else
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 301 = excluded ____semctl13 */
#endif
#if defined(SYSVMSG) || !defined(_KERNEL_OPT)
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 302 = __msgctl13 */
#else
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 302 = excluded __msgctl13 */
#endif
#if defined(SYSVSHM) || !defined(_KERNEL_OPT)
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 303 = __shmctl13 */
#else
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 303 = excluded __shmctl13 */
#endif
	{ ns(struct sys_lchflags_args), 0,
	    (sy_call_t *)sys_lchflags },	/* 304 = lchflags */
	{ 0, 0, 0,
	    (sy_call_t *)sys_issetugid },	/* 305 = issetugid */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 306 = utrace */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 307 = getcontext */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 308 = setcontext */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 309 = _lwp_create */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 310 = _lwp_exit */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 311 = _lwp_self */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 312 = _lwp_wait */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 313 = _lwp_suspend */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 314 = _lwp_continue */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 315 = _lwp_wakeup */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 316 = _lwp_getprivate */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 317 = _lwp_setprivate */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 318 = _lwp_kill */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 319 = _lwp_detach */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 320 = _lwp_park */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 321 = _lwp_unpark */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 322 = _lwp_unpark_all */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 323 = _lwp_setname */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 324 = _lwp_getname */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 325 = _lwp_ctl */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 326 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 327 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 328 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 329 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 330 = sa_register */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 331 = sa_stacks */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 332 = sa_enable */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 333 = sa_setconcurrency */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 334 = sa_yield */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 335 = sa_preempt */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 336 = obsolete sys_sa_unblockyield */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 337 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 338 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 339 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 340 = __sigaction_sigtramp */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 341 = pmc_get_info */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 342 = pmc_control */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 343 = rasctl */
	{ 0, 0, 0,
	    (sy_call_t *)sys_kqueue },		/* 344 = kqueue */
	{ ns(struct compat_50_sys_kevent_args), 0,
	    (sy_call_t *)compat_50_sys_kevent },/* 345 = compat_50_kevent */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 346 = _sched_setparam */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 347 = _sched_getparam */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 348 = _sched_setaffinity */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 349 = _sched_getaffinity */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 350 = sched_yield */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 351 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 352 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 353 = unimplemented */
	{ ns(struct sys_fsync_range_args), 0,
	    (sy_call_t *)sys_fsync_range },	/* 354 = fsync_range */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 355 = uuidgen */
	{ ns(struct sys_getvfsstat_args), 0,
	    (sy_call_t *)sys_getvfsstat },	/* 356 = getvfsstat */
	{ ns(struct sys_statvfs1_args), 0,
	    (sy_call_t *)sys_statvfs1 },	/* 357 = statvfs1 */
	{ ns(struct sys_fstatvfs1_args), 0,
	    (sy_call_t *)sys_fstatvfs1 },	/* 358 = fstatvfs1 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 359 = fhstatvfs1 */
	{ ns(struct sys_extattrctl_args), 0,
	    (sy_call_t *)sys_extattrctl },	/* 360 = extattrctl */
	{ ns(struct sys_extattr_set_file_args), 0,
	    (sy_call_t *)sys_extattr_set_file },/* 361 = extattr_set_file */
	{ ns(struct sys_extattr_get_file_args), 0,
	    (sy_call_t *)sys_extattr_get_file },/* 362 = extattr_get_file */
	{ ns(struct sys_extattr_delete_file_args), 0,
	    (sy_call_t *)sys_extattr_delete_file },/* 363 = extattr_delete_file */
	{ ns(struct sys_extattr_set_fd_args), 0,
	    (sy_call_t *)sys_extattr_set_fd },	/* 364 = extattr_set_fd */
	{ ns(struct sys_extattr_get_fd_args), 0,
	    (sy_call_t *)sys_extattr_get_fd },	/* 365 = extattr_get_fd */
	{ ns(struct sys_extattr_delete_fd_args), 0,
	    (sy_call_t *)sys_extattr_delete_fd },/* 366 = extattr_delete_fd */
	{ ns(struct sys_extattr_set_link_args), 0,
	    (sy_call_t *)sys_extattr_set_link },/* 367 = extattr_set_link */
	{ ns(struct sys_extattr_get_link_args), 0,
	    (sy_call_t *)sys_extattr_get_link },/* 368 = extattr_get_link */
	{ ns(struct sys_extattr_delete_link_args), 0,
	    (sy_call_t *)sys_extattr_delete_link },/* 369 = extattr_delete_link */
	{ ns(struct sys_extattr_list_fd_args), 0,
	    (sy_call_t *)sys_extattr_list_fd },	/* 370 = extattr_list_fd */
	{ ns(struct sys_extattr_list_file_args), 0,
	    (sy_call_t *)sys_extattr_list_file },/* 371 = extattr_list_file */
	{ ns(struct sys_extattr_list_link_args), 0,
	    (sy_call_t *)sys_extattr_list_link },/* 372 = extattr_list_link */
	{ ns(struct compat_50_sys_pselect_args), 0,
	    (sy_call_t *)compat_50_sys_pselect },/* 373 = compat_50_pselect */
	{ ns(struct compat_50_sys_pollts_args), 0,
	    (sy_call_t *)compat_50_sys_pollts },/* 374 = compat_50_pollts */
	{ ns(struct sys_setxattr_args), 0,
	    (sy_call_t *)sys_setxattr },	/* 375 = setxattr */
	{ ns(struct sys_lsetxattr_args), 0,
	    (sy_call_t *)sys_lsetxattr },	/* 376 = lsetxattr */
	{ ns(struct sys_fsetxattr_args), 0,
	    (sy_call_t *)sys_fsetxattr },	/* 377 = fsetxattr */
	{ ns(struct sys_getxattr_args), 0,
	    (sy_call_t *)sys_getxattr },	/* 378 = getxattr */
	{ ns(struct sys_lgetxattr_args), 0,
	    (sy_call_t *)sys_lgetxattr },	/* 379 = lgetxattr */
	{ ns(struct sys_fgetxattr_args), 0,
	    (sy_call_t *)sys_fgetxattr },	/* 380 = fgetxattr */
	{ ns(struct sys_listxattr_args), 0,
	    (sy_call_t *)sys_listxattr },	/* 381 = listxattr */
	{ ns(struct sys_llistxattr_args), 0,
	    (sy_call_t *)sys_llistxattr },	/* 382 = llistxattr */
	{ ns(struct sys_flistxattr_args), 0,
	    (sy_call_t *)sys_flistxattr },	/* 383 = flistxattr */
	{ ns(struct sys_removexattr_args), 0,
	    (sy_call_t *)sys_removexattr },	/* 384 = removexattr */
	{ ns(struct sys_lremovexattr_args), 0,
	    (sy_call_t *)sys_lremovexattr },	/* 385 = lremovexattr */
	{ ns(struct sys_fremovexattr_args), 0,
	    (sy_call_t *)sys_fremovexattr },	/* 386 = fremovexattr */
	{ ns(struct compat_50_sys___stat30_args), 0,
	    (sy_call_t *)compat_50_sys___stat30 },/* 387 = compat_50___stat30 */
	{ ns(struct compat_50_sys___fstat30_args), 0,
	    (sy_call_t *)compat_50_sys___fstat30 },/* 388 = compat_50___fstat30 */
	{ ns(struct compat_50_sys___lstat30_args), 0,
	    (sy_call_t *)compat_50_sys___lstat30 },/* 389 = compat_50___lstat30 */
	{ ns(struct sys___getdents30_args), 0,
	    (sy_call_t *)sys___getdents30 },	/* 390 = __getdents30 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 391 = ignored old posix_fadvise */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 392 = __fhstat30 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 393 = __ntp_gettime30 */
	{ ns(struct sys___socket30_args), 0,
	    (sy_call_t *)sys___socket30 },	/* 394 = __socket30 */
	{ ns(struct sys___getfh30_args), 0,
	    (sy_call_t *)sys___getfh30 },	/* 395 = __getfh30 */
	{ ns(struct sys___fhopen40_args), 0,
	    (sy_call_t *)sys___fhopen40 },	/* 396 = __fhopen40 */
	{ ns(struct sys___fhstatvfs140_args), 0,
	    (sy_call_t *)sys___fhstatvfs140 },	/* 397 = __fhstatvfs140 */
	{ ns(struct compat_50_sys___fhstat40_args), 0,
	    (sy_call_t *)compat_50_sys___fhstat40 },/* 398 = compat_50___fhstat40 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 399 = aio_cancel */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 400 = aio_error */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 401 = aio_fsync */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 402 = aio_read */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 403 = aio_return */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 404 = aio_suspend */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 405 = aio_write */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 406 = lio_listio */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 407 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 408 = unimplemented */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 409 = unimplemented */
	{ ns(struct sys___mount50_args), 0,
	    (sy_call_t *)sys___mount50 },	/* 410 = __mount50 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 411 = mremap */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 412 = pset_create */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 413 = pset_destroy */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 414 = pset_assign */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 415 = _pset_bind */
	{ ns(struct sys___posix_fadvise50_args), 0,
	    (sy_call_t *)sys___posix_fadvise50 },/* 416 = __posix_fadvise50 */
	{ ns(struct sys___select50_args), 0,
	    (sy_call_t *)sys___select50 },	/* 417 = __select50 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 418 = __gettimeofday50 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 419 = __settimeofday50 */
	{ ns(struct sys___utimes50_args), 0,
	    (sy_call_t *)sys___utimes50 },	/* 420 = __utimes50 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 421 = __adjtime50 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 422 = __lfs_segwait50 */
	{ ns(struct sys___futimes50_args), 0,
	    (sy_call_t *)sys___futimes50 },	/* 423 = __futimes50 */
	{ ns(struct sys___lutimes50_args), 0,
	    (sy_call_t *)sys___lutimes50 },	/* 424 = __lutimes50 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 425 = __setitimer50 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 426 = __getitimer50 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 427 = __clock_gettime50 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 428 = __clock_settime50 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 429 = __clock_getres50 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 430 = __nanosleep50 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 431 = ____sigtimedwait50 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 432 = __mq_timedsend50 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 433 = __mq_timedreceive50 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 434 = _lwp_park */
	{ ns(struct sys___kevent50_args), 0,
	    (sy_call_t *)sys___kevent50 },	/* 435 = __kevent50 */
	{ ns(struct sys___pselect50_args), 0,
	    (sy_call_t *)sys___pselect50 },	/* 436 = __pselect50 */
	{ ns(struct sys___pollts50_args), 0,
	    (sy_call_t *)sys___pollts50 },	/* 437 = __pollts50 */
	{ 0, 0, 0,
	    (sy_call_t *)sys_nomodule }, 	/* 438 = __aio_suspend50 */
	{ ns(struct sys___stat50_args), 0,
	    (sy_call_t *)sys___stat50 },	/* 439 = __stat50 */
	{ ns(struct sys___fstat50_args), 0,
	    (sy_call_t *)sys___fstat50 },	/* 440 = __fstat50 */
	{ ns(struct sys___lstat50_args), 0,
	    (sy_call_t *)sys___lstat50 },	/* 441 = __lstat50 */
#if defined(SYSVSEM) || !defined(_KERNEL_OPT)
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 442 = ____semctl50 */
#else
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 442 = excluded ____semctl50 */
#endif
#if defined(SYSVSHM) || !defined(_KERNEL_OPT)
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 443 = __shmctl50 */
#else
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 443 = excluded ____shmctl50 */
#endif
#if defined(SYSVMSG) || !defined(_KERNEL_OPT)
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 444 = __msgctl50 */
#else
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 444 = excluded ____msgctl50 */
#endif
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 445 = __getrusage50 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 446 = __timer_settime50 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 447 = __timer_gettime50 */
#if defined(NTP) || !defined(_KERNEL_OPT)
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 448 = __ntp_gettime50 */
#else
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 448 = excluded ___ntp_gettime50 */
#endif
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 449 = __wait450 */
	{ ns(struct sys___mknod50_args), 0,
	    (sy_call_t *)sys___mknod50 },	/* 450 = __mknod50 */
	{ ns(struct sys___fhstat50_args), 0,
	    (sy_call_t *)sys___fhstat50 },	/* 451 = __fhstat50 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 452 = obsolete 5.99 quotactl */
	{ ns(struct sys_pipe2_args), 0,
	    (sy_call_t *)sys_pipe2 },		/* 453 = pipe2 */
	{ ns(struct sys_dup3_args), 0,
	    (sy_call_t *)sys_dup3 },		/* 454 = dup3 */
	{ ns(struct sys_kqueue1_args), 0,
	    (sy_call_t *)sys_kqueue1 },		/* 455 = kqueue1 */
	{ ns(struct sys_paccept_args), 0,
	    (sy_call_t *)sys_paccept },		/* 456 = paccept */
	{ ns(struct sys_linkat_args), 0,
	    (sy_call_t *)sys_linkat },		/* 457 = linkat */
	{ ns(struct sys_renameat_args), 0,
	    (sy_call_t *)sys_renameat },	/* 458 = renameat */
	{ ns(struct sys_mkfifoat_args), 0,
	    (sy_call_t *)sys_mkfifoat },	/* 459 = mkfifoat */
	{ ns(struct sys_mknodat_args), 0,
	    (sy_call_t *)sys_mknodat },		/* 460 = mknodat */
	{ ns(struct sys_mkdirat_args), 0,
	    (sy_call_t *)sys_mkdirat },		/* 461 = mkdirat */
	{ ns(struct sys_faccessat_args), 0,
	    (sy_call_t *)sys_faccessat },	/* 462 = faccessat */
	{ ns(struct sys_fchmodat_args), 0,
	    (sy_call_t *)sys_fchmodat },	/* 463 = fchmodat */
	{ ns(struct sys_fchownat_args), 0,
	    (sy_call_t *)sys_fchownat },	/* 464 = fchownat */
	{ ns(struct sys_fexecve_args), 0,
	    (sy_call_t *)sys_fexecve },		/* 465 = fexecve */
	{ ns(struct sys_fstatat_args), 0,
	    (sy_call_t *)sys_fstatat },		/* 466 = fstatat */
	{ ns(struct sys_utimensat_args), 0,
	    (sy_call_t *)sys_utimensat },	/* 467 = utimensat */
	{ ns(struct sys_openat_args), 0,
	    (sy_call_t *)sys_openat },		/* 468 = openat */
	{ ns(struct sys_readlinkat_args), 0,
	    (sy_call_t *)sys_readlinkat },	/* 469 = readlinkat */
	{ ns(struct sys_symlinkat_args), 0,
	    (sy_call_t *)sys_symlinkat },	/* 470 = symlinkat */
	{ ns(struct sys_unlinkat_args), 0,
	    (sy_call_t *)sys_unlinkat },	/* 471 = unlinkat */
	{ ns(struct sys_futimens_args), 0,
	    (sy_call_t *)sys_futimens },	/* 472 = futimens */
	{ ns(struct sys___quotactl_args), 0,
	    (sy_call_t *)sys___quotactl },	/* 473 = __quotactl */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 474 = posix_spawn */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 475 = recvmmsg */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 476 = sendmmsg */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 477 = clock_nanosleep */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys }, 	/* 478 = ___lwp_park60 */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 479 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 480 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 481 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 482 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 483 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 484 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 485 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 486 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 487 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 488 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 489 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 490 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 491 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 492 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 493 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 494 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 495 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 496 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 497 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 498 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 499 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 500 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 501 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 502 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 503 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 504 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 505 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 506 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 507 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 508 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 509 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 510 = filler */
	{ 0, 0, SYCALL_NOSYS,
	    (sy_call_t *)rump_enosys },		/* 511 = filler */
};
CTASSERT(__arraycount(rump_sysent) == SYS_NSYSENT);
__strong_alias(sysent,rump_sysent);
#endif /* RUMP_CLIENT */
